
#########################
#hook
# push alias
_cp_=`alias cp 2>/dev/null` && _cp_="alias $_cp_"
_mv_=`alias mv 2>/dev/null` && _mv_="alias $_mv_"
unalias mv cp 2>/dev/null
# 重载 mv,cp 添加 log 
MV=`which mv`
CP=`which cp`
RM=`which rm`
LN=`which ln`
ln(){
	#echo "$2 --> $3"
	printf "%-38s --> %s\n" "$2" "$3"
	local dest="${3%%/}/`basename $2`"
	#ls -lhd $dest
	[ -L "$dest" ] && rm "$dest"
	$LN $*
}
mv(){
	local src=$1
	local dst=$2
	#echo "$src -> $dst"
	printf "%-38s --> %s\n" "$src" "$dst"
	$MV $src $dst
}
cp(){
	local src=$1
	local dst=$2
	#echo "$src -> $dst"
	printf "%-38s --> %s\n" "$src" "$dst"
	$CP $src $dst
}
rm(){
	local dst="$*"
	echo "rm $dst"
	$RM $dst
}
echoY(){
    echo -e "\e[33m$*\e[0m"
}
#########################
# fix path
fix_path(){
	echo '--- fix  path  ---'
	##php
	#ini
	ln -s /opt/etc/php.ini /etc/php.ini
	ln -s /opt/etc/php7 /etc/php7 

	#lib
	ln -s /opt/usr/lib/php /usr/lib/php

	##php fpm
	#init.d
	ln -s /opt/etc/init.d/php7-fpm /etc/init.d/php7-fpm
	#uci
	ln -s /opt/etc/config/php7-fpm /etc/config/php7-fpm
	#conf
	ln -s /opt/etc/php7-fpm.conf /etc/php7-fpm.conf
	ln -s /opt/etc/php7-fpm.d /etc/php7-fpm.d
	#bin
	ln -s /opt/usr/bin/php-fpm /usr/bin/php-fpm
}
rm_link(){
	local dst="$1"
	[ -L "$dst" ] && rm "$dst"
}
undo_fix_path(){
	echo '--- undo fix path  ---'
	##php
	#ini
	rm_link /etc/php.ini
	rm_link /etc/php7

	#lib
	rm_link /usr/lib/php

	##php fpm
	#init.d
	rm_link /etc/init.d/php7-fpm
	#uci
	rm_link /etc/config/php7-fpm
	#conf
	rm_link /etc/php7-fpm.conf
	rm_link /etc/php7-fpm.d
	#bin
	rm_link /usr/bin/php-fpm
}

#########################
# setup conf
listen_mode_set(){
	echo '--- listen.mode 0666'
	sed -i 's/.*listen.mode = .*/listen.mode = 0666/' /etc/php7-fpm.d/www.conf
}
doc_root_clear(){
	echo '--- doc_root clear'
	sed -i 's/^doc_root.*/doc_root = /' /etc/php.ini
}
display_errors_on(){
	echo '--- display_errros on'
	sed -i '/^php_flag\[display_errors\]/d' /etc/php7-fpm.d/www.conf
	echo 'php_flag[display_errors] = on' >> /etc/php7-fpm.d/www.conf
}
#service_stop not work well with syslink exe
fix_init_script(){
	echo '--- fix init script'
	sed -i 's:PROG=.*:PROG=/opt/usr/bin/php-fpm:' /etc/init.d/php7-fpm
}
setup_conf(){
	echo '--- setup conf ---'
	fix_init_script
	listen_mode_set
	doc_root_clear
	display_errors_on
}

#########################
setup_site(){
	echo '--- setup site ---'
	cp vh.php.conf  /etc/nginx	
	cp info.php     /opt/app/

	echo '--- restart nginx'
	/etc/init.d/nginx    restart
	echo '--- restart php7-fpm'
	/etc/init.d/php7-fpm restart
}

test_site(){
	echo '--- test  site ---'
	echoY 'test page: http://hiwifi.com:9999/info.php'
	curl -s localhost:9999/info.php | head -n 10
}

#########################
install_ipk(){
	echo '--- install ipk'
	opkg install *.ipk  --add-dest cry:/opt/ --dest cry	
}


install(){
	echoY '-----   install -----'
	install_ipk
	fix_path
	setup_conf
	setup_site
	test_site
}
#########################
ipks='
libltdl_2.4-1_ralink.ipk
libmcrypt_2.5.8-2_ralink.ipk
libmysqlclient_5.1.53-7_ralink.ipk
libpq_9.0.1-3_ralink.ipk
php7-cgi_7.0.10-1_ralink.ipk
php7-cli_7.0.10-1_ralink.ipk
php7-fastcgi_7.0.10-1_ralink.ipk
php7-fpm_7.0.10-1_ralink.ipk
php7-mod-calendar_7.0.10-1_ralink.ipk
php7-mod-ctype_7.0.10-1_ralink.ipk
php7-mod-curl_7.0.10-1_ralink.ipk
php7-mod-fileinfo_7.0.10-1_ralink.ipk
php7-mod-hash_7.0.10-1_ralink.ipk
php7-mod-iconv_7.0.10-1_ralink.ipk
php7-mod-json_7.0.10-1_ralink.ipk
php7-mod-mbstring_7.0.10-1_ralink.ipk
php7-mod-mcrypt_7.0.10-1_ralink.ipk
php7-mod-mysqli_7.0.10-1_ralink.ipk
php7-mod-openssl_7.0.10-1_ralink.ipk
php7-mod-pdo-mysql_7.0.10-1_ralink.ipk
php7-mod-pdo-pgsql_7.0.10-1_ralink.ipk
php7-mod-pdo-sqlite_7.0.10-1_ralink.ipk
php7-mod-pdo_7.0.10-1_ralink.ipk
php7-mod-session_7.0.10-1_ralink.ipk
php7-mod-sockets_7.0.10-1_ralink.ipk
php7-mod-sqlite3_7.0.10-1_ralink.ipk
php7-mod-tokenizer_7.0.10-1_ralink.ipk
php7-mod-xml_7.0.10-1_ralink.ipk
php7-mod-zip_7.0.10-1_ralink.ipk
php7_7.0.10-1_ralink.ipk
'

uninstall_ipk(){
	echo '--- uninstall ipk'
	#for i in *.ipk ; do
	for i in $ipks ; do
		#echo opkg remove --force-depends  --add-dest cry:/tmp/cryptdata --dest cry  ${i%%_*};
		opkg remove --force-depends  --add-dest cry:/tmp/cryptdata --dest cry  ${i%%_*};
	done
}
clean_conf(){
	echo '--- clean conf'
	rm /opt/etc/php.ini
}
clean_site(){
	echo '--- clean site'
	rm /etc/nginx/vh.php.conf
	rm /opt/www/info.php

	echo '--- restart nginx'
	/etc/init.d/nginx    restart
	echo '--- stop    php7-fpm'
	/etc/init.d/php7-fpm stop
}
uninstall(){
	echoY '----- uninstall -----'
	clean_site
	clean_conf
	undo_fix_path
	uninstall_ipk
}

