#!/bin/sh

#目录地址
Root=/opt/app
File=/koolproxy

#启动命令
chmod +x $Root$File/koolproxy_RootStrat
cd $Root$File/
./koolproxy_RootStrat -b $Root$File/data/ -d
ipset restore -f $Root$File/data/white_list.txt
iptables -t nat -N KOOLPROXY
iptables -t nat -N KOOLPROXY_HTTP
iptables -t nat -N KOOLPROXY_HTTPS
#忽略特殊ip段
iptables -t nat -A KOOLPROXY -m set --match-set white_list dst -j RETURN
#处理http或者http+https
iptables -t nat -A KOOLPROXY_HTTP -p tcp -m tcp --dport 80 -j REDIRECT --to-ports 3000
iptables -t nat -A KOOLPROXY_HTTPS -p tcp -m multiport --dports 80,443 -j REDIRECT --to-ports 3000
iptables -t nat -A KOOLPROXY -p tcp -j KOOLPROXY_HTTP
iptables -t nat -A PREROUTING -p tcp -j KOOLPROXY
cd $Root$File/data/
chmod +x gen_ca.sh
sh gen_ca.sh
iptables -t nat -A KOOLPROXY -p tcp -j KOOLPROXY_HTTPS
iptables -t nat -A KOOLPROXY_HTTPS -p tcp -d 110.110.110.110 --dport 80 -j REDIRECT --to-port 3000
#查看PREROUTING链中S*S规则在行数
iptables -t nat --list --line
#X为行数+1
iptables -t nat -I PREROUTING X -p tcp -j KOOLPROXY

#将进程名写入 pid.txt
echo "koolproxy_RootStrat" >> /opt/pid.txt
huoqu=$(pgrep koolproxy_RootStrat)
	jieguo=$( echo $huoqu | awk  ""'{print NF}')   
	if [ $jieguo = 0 ]; then
	#没有
         echo "插件并未运行"
    else
	#有
	echo "插件已运行"
    fi
done