<?php
//*****************************************************************//
// This file is part of bloofoxCMS! Do not delete this copyright!!!
// - system/class_config.php -
//
// Copyrights (c) 2006-2012 Alexander Lang, Germany
// info@bloofox.com
// http://www.bloofox.com
//
// bloofoxCMS is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// any later version.
//
// bloofoxCMS is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//*****************************************************************//

// Forbid direct call
if(!defined('SYS_INDEX')) {
	die("You can't call this file directly!");
}

class config {

	// Init variables
	var $id_found = 0;
	var $sys_config_vars = array();
	var $sys_request_url = "";
	
	// Constructor
	function config()
	{
		$this->get_request_url();
	}
	
	// Create and get sys_request_url
	function get_request_url()
	{
		$SERVER_NAME = $_SERVER['SERVER_NAME'];
		$SCRIPT_PATH = $_SERVER['REQUEST_URI'];
		$requested_url = "http://".$SERVER_NAME.$SCRIPT_PATH;

		$this->sys_request_url = trim($requested_url);
	}

	// get sys_config_vars
	function get_config_vars($db,$check=1)
	{
		global $tbl_prefix;
		
		if(!isset($_GET['page']) || CheckInteger($_GET['page']) == FALSE) {
			$this->sys_config_vars = $this->get_config($db);
		} else {
			$db->query("SELECT config_id FROM ".$tbl_prefix."sys_explorer WHERE eid = '".$_GET['page']."' LIMIT 1");
			while($db->next_record()):
				$config_id = $db->f("config_id");
			endwhile;
			$this->sys_config_vars = $this->set_config($db,$config_id);
		}

		if($this->sys_config_vars['cid'] == "" && $check == 1) {
			echo(show_error_screen("Error","Project configuration not found! Please check your projects in Admincenter."));
			die();
		}
		
		return($this->sys_config_vars);
	}
	
	// Get correct config from database
	function get_config($db)
	{
		global $tbl_prefix;
		$db->query("SELECT cid,urls FROM ".$tbl_prefix."sys_config ORDER BY cid");
		// -debug
		//echo "\n\rRequest: ".$this->sys_request_url;
		
		while($db->next_record()):
			$request_url_handler = explode("\n",$db->f("urls"));
			if(empty($request_url_handler[0])) {
				$request_url_handler[0] = "@";
				$this->id_found = 2;
			}
			
			for($x=0; $x<count($request_url_handler); $x++) {
				if(empty($request_url_handler[$x])) {
					$request_url_handler[$x] = "@";
				}
				
				$request_url_handler[$x] = $this->url_add_slash(trim($request_url_handler[$x]));
				// -debug
				//echo "\n\rHandler: ".$request_url_handler[$x];
				
				if($request_url_handler[$x] == $this->sys_request_url && $this->id_found == 0) {
					$this->set_config($db,$db->f("cid"));
					$this->id_found = 1;
				}
			}
			
			if($this->id_found == 1) {
				return($this->sys_config_vars);
			}
		endwhile;
		
		$this->set_config($db,"");
		return($this->sys_config_vars);
	}
	
	// add slash to end of URL
	function url_add_slash($url)
	{
		if($url == "@") {
			return($url);
		}
		
		if(substr($url, -1) != "/") {
			$url = $url."/";
		}
		
		return($url);
	}
	
	// Set sys_config_vars-Array
	function set_config($db,$cid="")
	{
		global $tbl_prefix;
		$config_vars = array();
		
		if($cid != "") {
			$db->query("SELECT * FROM ".$tbl_prefix."sys_config WHERE cid = '".$cid."' ORDER BY cid LIMIT 1");
		} else {
			$db->query("SELECT * FROM ".$tbl_prefix."sys_config ORDER BY cid LIMIT 1");
		}
		while($db->next_record()):
			$config_vars["cid"] = $db->f("cid");
			$config_vars["lang_id"] = $db->f("lang_id");
			$url = explode("\n",$db->f("urls"));
			$config_vars["url"] = trim($url['0']);
			$config_vars["tmpl_id"] = $db->f("tmpl_id");
			$config_vars["company_name"] = $db->f("company_name");
			$config_vars["root_id"] = $db->f("root_id");
			$config_vars["user_groups"] = $db->f("user_groups");
			$config_vars["meta_title"] = $db->f("meta_title");
			$config_vars["meta_desc"] = $db->f("meta_desc");
			$config_vars["meta_keywords"] = $db->f("meta_keywords");
			$config_vars["meta_author"] = $db->f("meta_author");
			$config_vars["meta_charset"] = $db->f("meta_charset");
			$config_vars["meta_doctype"] = $db->f("meta_doctype");
			$config_vars["meta_copyright"] = $db->f("meta_copyright");
			$config_vars["mod_rewrite"] = $db->f("mod_rewrite");
			$config_vars["mail"] = $db->f("mail");
			$config_vars["default_group"] = $db->f("default_group");
			$config_vars["generator_text"] = "<!--\nThis Website was generated by bloofoxCMS.\nbloofoxCMS is open source published under the gnu gpl. Visit www.bloofox.com for more details!\nCopyrights (c) 2006-2012 by Alexander Lang\n//-->\n";
		endwhile;
		
		$this->sys_config_vars = $config_vars;
		return($this->sys_config_vars);
	}
	
	// Set sys_setting_vars-Array
	function get_setting_vars($db,$isAC=0)
	{
		global $tbl_prefix;
		$setting_vars = array();
		
		$db->query("SELECT * FROM ".$tbl_prefix."sys_setting ORDER BY sid");
		while($db->next_record()):
			$setting_vars[$db->f("setting_property")] = $db->f("setting_value");
		endwhile;
		
		// check settings
		if($isAC == 0) {
			$this->check_settings($setting_vars);
		}
		
		if($setting_vars["textbox_width"] < 500) {
			$setting_vars["textbox_width"] = 500;
		}
		if($setting_vars["textbox_height"] < 100) {
			$setting_vars["textbox_height"] = 100;
		}
		
		return($setting_vars);
	}
	
	// Check sys_setting_vars
	function check_settings($setting_vars)
	{
		// Check Maintenance Mode
		if($setting_vars['maintenance'] == "1") {
			echo(show_error_screen(get_caption('3640','Maintenance Mode'),get_caption('0','The content management system is in maintenance. Please contact the system administrator and try again later.')));
			die();
		}
	}
	
	// Set language parameters in sys_vars-Array
	function get_language_vars($db,$sys_config_vars)
	{
		global $tbl_prefix;
		$sys_lang_vars = array();
		
		$db->query("SELECT filename,date,datetime,token FROM ".$tbl_prefix."sys_lang WHERE lid = '".$sys_config_vars['lang_id']."' ORDER BY lid LIMIT 1");
		while($db->next_record()):
			$sys_lang_vars['token'] = $db->f("token");
			$sys_lang_vars['language'] = $db->f("filename");
			$sys_lang_vars['date'] = $db->f("date");
			$sys_lang_vars['datetime'] = $db->f("datetime");
		endwhile;
		
		return($sys_lang_vars);
	}
	
	// Set template parameter in sys_tmpl_vars-Array
	function get_tmpl_vars($db,$sys_config_vars,$print)
	{
		global $tbl_prefix;
		$tmpl_vars = array();
		
		$db->query("SELECT * FROM ".$tbl_prefix."sys_template WHERE tid = '".$sys_config_vars['tmpl_id']."' LIMIT 1");
		while($db->next_record()):
			$tmpl_vars['name'] = $db->f("name");
			$tmpl_vars['tmpl'] = $db->f("template");
			$tmpl_vars['css'] = $db->f("css");
			if($print == 1) {
				$tmpl_vars['tmpl'] = $db->f("template_print");
				$tmpl_vars['css'] = $db->f("template_print_css");
			}
			$tmpl_vars['login'] = $db->f("template_login");
			$tmpl_vars['text'] = $db->f("template_text");
		endwhile;
		
		if(!file_exists(SYS_WORK_DIR."/templates/".$tmpl_vars['name']."/".$tmpl_vars['tmpl']) || empty($tmpl_vars['tmpl'])) {
			echo(show_error_screen("Error","The main template file does not exist! Please check your template settings in Admincenter and your template folder '/templates'."));
			die();
		}
		if(!file_exists(SYS_WORK_DIR."/templates/".$tmpl_vars['name']."/".$tmpl_vars['text']) || empty($tmpl_vars['text'])) {
			echo(show_error_screen("Error","Article template file does not exist! Please check your template settings in Admincenter and your template folder '/templates'."));
			die();
		}
		if(!file_exists(SYS_WORK_DIR."/templates/".$tmpl_vars['name']."/".$tmpl_vars['login']) || empty($tmpl_vars['login'])) {
			echo(show_error_screen("Error","Login template file does not exist! Please check your template settings in Admincenter and your template folder '/templates'."));
			die();
		}
		
		return($tmpl_vars);
	}
}
?>