/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.server;

import java.io.IOException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.dpi.model.DPIContext;
import org.jkiss.dbeaver.dpi.server.DPIControllerImpl;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.dpi.DPIController;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.rest.RestServer;

public class DPIRestServer {
    private static final Log log = Log.getLog(DPIRestServer.class);
    private final RestServer<?> restServer;

    public DPIRestServer(DBPApplication application, int portNumber) throws IOException {
        DPIContext dpiContext = new DPIContext((DBRProgressMonitor)new LoggingProgressMonitor(log), (Object)application);
        DPIControllerImpl dpiController = new DPIControllerImpl(dpiContext);
        this.restServer = RestServer.builder(DPIController.class, (Object)dpiController).setFilter(address -> address.getAddress().isLoopbackAddress()).setPort(portNumber).setGson(dpiContext.getGson()).create();
        dpiController.setServer(this.restServer);
    }

    public void join() {
        while (this.restServer.isRunning()) {
            RuntimeUtils.pause((int)100);
        }
    }
}

