/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.app;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.dpi.app.DPIActivator;
import org.jkiss.dbeaver.dpi.app.DPIWorkspace;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.impl.app.DefaultCertificateStorage;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMRegistry;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.BaseApplicationImpl;
import org.jkiss.dbeaver.registry.BasePlatformImpl;
import org.jkiss.dbeaver.runtime.qm.QMRegistryImpl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DPIPlatform
extends BasePlatformImpl {
    public static final String PLUGIN_ID = "org.jkiss.dbeaver.dpi.app";
    private static final Log log = Log.getLog(DPIPlatform.class);
    static DPIPlatform instance;
    private static volatile boolean isClosing;
    private Path tempFolder;
    private DPIWorkspace workspace;
    private QMRegistryImpl qmController;
    private DefaultCertificateStorage defaultCertificateStorage;

    static {
        isClosing = false;
    }

    public static boolean isClosing() {
        return isClosing;
    }

    private static void setClosing(boolean closing) {
        isClosing = closing;
    }

    DPIPlatform() {
    }

    protected void initialize() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Initialize DPI Platform...");
        try {
            Path installPath = RuntimeUtils.getLocalPathFromURL((URL)Platform.getInstallLocation().getURL());
            this.tempFolder = installPath.resolve("temp");
            this.defaultCertificateStorage = new DefaultCertificateStorage(installPath.resolve("security"));
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
        this.workspace = new DPIWorkspace(this);
        this.workspace.initializeProjects();
        QMUtils.initApplication((DBPPlatform)this);
        this.qmController = new QMRegistryImpl();
        log.debug((Object)("DPI Platform initialized (" + (System.currentTimeMillis() - startTime) + "ms)"));
    }

    public synchronized void dispose() {
        log.debug((Object)"Shutdown DPI...");
        DPIPlatform.setClosing(true);
        super.dispose();
        this.workspace.dispose();
        if (this.tempFolder != null) {
            if (!ContentUtils.deleteFileRecursive((Path)this.tempFolder)) {
                log.warn((Object)("Can't delete temp folder '" + String.valueOf(this.tempFolder) + "'"));
            }
            this.tempFolder = null;
        }
        instance = null;
    }

    @NotNull
    public DPIWorkspace getWorkspace() {
        return this.workspace;
    }

    @NotNull
    public DBPApplication getApplication() {
        return BaseApplicationImpl.getInstance();
    }

    @NotNull
    public QMRegistry getQueryManager() {
        return this.qmController;
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return new BundlePreferenceStore(PLUGIN_ID);
    }

    @NotNull
    public DBACertificateStorage getCertificateStorage() {
        return this.defaultCertificateStorage;
    }

    @NotNull
    public Path getTempFolder(DBRProgressMonitor monitor, String name) {
        return this.tempFolder.resolve(name);
    }

    protected Plugin getProductPlugin() {
        return DPIActivator.getInstance();
    }

    public boolean isShuttingDown() {
        return DPIPlatform.isClosing();
    }
}

