/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.nativetool;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceMap;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTaskSettings;
import org.jkiss.dbeaver.model.task.DBTTaskSettingsInput;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.encode.SecuredPasswordEncrypter;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractNativeToolSettings<BASE_OBJECT extends DBSObject>
implements DBTTaskSettings<BASE_OBJECT>,
DBTTaskSettingsInput<BASE_OBJECT> {
    private static final Log log = Log.getLog(AbstractNativeToolSettings.class);
    private final String PROP_NAME_EXTRA_ARGS = "tools.wizard." + this.getClass().getSimpleName() + ".extraArgs";
    @Nullable
    private DBPNativeClientLocation clientHome;
    private PrintStream logWriter = System.out;
    private String clientHomeName;
    private String toolUserName;
    private String toolUserPassword;
    private String extraCommandArgs;
    private DBPDataSourceContainer dataSourceContainer;
    private final List<BASE_OBJECT> databaseObjects = new ArrayList<BASE_OBJECT>();

    public List<BASE_OBJECT> getDatabaseObjects() {
        return this.databaseObjects;
    }

    public DBPProject getProject() {
        return this.dataSourceContainer == null ? null : this.dataSourceContainer.getProject();
    }

    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    public void setDataSourceContainer(DBPDataSourceContainer dataSourceContainer) {
        this.dataSourceContainer = dataSourceContainer;
    }

    protected void updateDataSourceContainer() {
        this.dataSourceContainer = this.databaseObjects.isEmpty() ? null : ((DBSObject)this.databaseObjects.get(0)).getDataSource().getContainer();
    }

    public DBPNativeClientLocation findNativeClientHome(String clientHomeId) {
        return null;
    }

    public PrintStream getLogWriter() {
        return this.logWriter;
    }

    public void setLogWriter(PrintStream logWriter) {
        this.logWriter = logWriter;
    }

    public String getClientHomeName() {
        return this.clientHomeName;
    }

    @Nullable
    public DBPNativeClientLocation getClientHome() {
        return this.clientHome;
    }

    public void setClientHome(@Nullable DBPNativeClientLocation clientHome) {
        this.clientHome = clientHome;
        this.clientHomeName = clientHome == null ? null : clientHome.getName();
    }

    public String getToolUserName() {
        return this.toolUserName;
    }

    public void setToolUserName(String toolUserName) {
        this.toolUserName = toolUserName;
    }

    public String getToolUserPassword() {
        return this.toolUserPassword;
    }

    public void setToolUserPassword(String toolUserPassword) {
        this.toolUserPassword = toolUserPassword;
    }

    public String getExtraCommandArgs() {
        return this.extraCommandArgs;
    }

    public void setExtraCommandArgs(String extraCommandArgs) {
        this.extraCommandArgs = extraCommandArgs;
    }

    public void addExtraCommandArgs(List<String> cmd) {
        if (!CommonUtils.isEmptyTrimmed((String)this.extraCommandArgs)) {
            Collections.addAll(cmd, this.extraCommandArgs.split(" "));
        }
    }

    public void loadSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) throws DBException {
        List databaseObjectList;
        String dsID;
        if (this.dataSourceContainer == null && !CommonUtils.isEmpty(this.databaseObjects)) {
            DBSObject baseObject = (DBSObject)this.databaseObjects.get(0);
            DBPDataSourceContainer dBPDataSourceContainer = this.dataSourceContainer = baseObject instanceof DBPDataSourceContainer ? (DBPDataSourceContainer)baseObject : baseObject.getDataSource().getContainer();
        }
        if (this.dataSourceContainer == null && !CommonUtils.isEmpty((String)(dsID = preferenceStore.getString("dataSource")))) {
            DBPProject project;
            String projectName = preferenceStore.getString("project");
            DBPProject dBPProject = project = CommonUtils.isEmpty((String)projectName) ? null : DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
            if (project == null) {
                if (!CommonUtils.isEmpty((String)projectName)) {
                    log.error((Object)("Can't find project '" + projectName + "' for tool configuration"));
                }
                project = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
            }
            this.dataSourceContainer = project.getDataSourceRegistry().getDataSource(dsID);
            if (this.dataSourceContainer == null) {
                log.error((Object)("Can't find datasource '" + dsID + "' in project '" + project.getName() + "' for tool configuration"));
            }
        }
        if (preferenceStore instanceof DBPPreferenceMap && this.dataSourceContainer != null && !CommonUtils.isEmpty((Collection)(databaseObjectList = (List)((DBPPreferenceMap)preferenceStore).getObject("databaseObjects")))) {
            DBPProject finalProject = this.dataSourceContainer.getProject();
            try {
                runnableContext.run(true, true, monitor -> {
                    monitor.beginTask("Load database object list", databaseObjectList.size());
                    try {
                        try {
                            for (String objectId : databaseObjectList) {
                                monitor.subTask("Load " + objectId);
                                try {
                                    DBSObject object = DBUtils.findObjectById((DBRProgressMonitor)monitor, (DBPProject)finalProject, (String)objectId);
                                    if (object != null) {
                                        this.databaseObjects.add(object);
                                        this.dataSourceContainer = object instanceof DBPDataSourceContainer ? (DBPDataSourceContainer)object : object.getDataSource().getContainer();
                                    }
                                }
                                catch (Throwable e) {
                                    throw new DBException("Can't find database object '" + objectId + "' in project '" + finalProject.getName() + "' for task configuration", e);
                                }
                                monitor.worked(1);
                            }
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                throw new DBException("Error loading objects configuration", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.extraCommandArgs = preferenceStore.getString(this.PROP_NAME_EXTRA_ARGS);
        this.clientHomeName = preferenceStore.getString("clientHomeName");
        if (preferenceStore instanceof DBPPreferenceMap) {
            this.toolUserName = preferenceStore.getString("tool.user");
            this.toolUserPassword = preferenceStore.getString("tool.password");
            try {
                SecuredPasswordEncrypter encrypter = new SecuredPasswordEncrypter();
                if (!CommonUtils.isEmpty((String)this.toolUserName)) {
                    this.toolUserName = encrypter.decrypt(this.toolUserName);
                }
                if (!CommonUtils.isEmpty((String)this.toolUserPassword)) {
                    this.toolUserPassword = encrypter.decrypt(this.toolUserPassword);
                }
            }
            catch (Exception e) {
                throw new DBException("Error decrypting user credentials", (Throwable)e);
            }
        }
    }

    public void saveSettings(DBRRunnableContext runnableContext, DBPPreferenceStore preferenceStore) {
        preferenceStore.setValue("project", this.getProject().getName());
        if (this.dataSourceContainer != null) {
            preferenceStore.setValue("dataSource", this.dataSourceContainer.getId());
        }
        if (preferenceStore instanceof DBPPreferenceMap) {
            Map propertyMap = ((DBPPreferenceMap)preferenceStore).getPropertyMap();
            ArrayList<String> objectList = new ArrayList<String>();
            for (DBSObject object : this.databaseObjects) {
                objectList.add(DBUtils.getObjectFullId((DBSObject)object));
            }
            propertyMap.put("databaseObjects", objectList);
            try {
                SecuredPasswordEncrypter encrypter = new SecuredPasswordEncrypter();
                if (!CommonUtils.isEmpty((String)this.toolUserName)) {
                    propertyMap.put("tool.user", encrypter.encrypt(this.toolUserName));
                } else {
                    propertyMap.put("tool.user", "");
                }
                if (!CommonUtils.isEmpty((String)this.toolUserPassword)) {
                    propertyMap.put("tool.password", encrypter.encrypt(this.toolUserPassword));
                } else {
                    propertyMap.put("tool.password", "");
                }
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        preferenceStore.setValue(this.PROP_NAME_EXTRA_ARGS, this.extraCommandArgs);
        if (this.clientHomeName != null) {
            preferenceStore.setValue("clientHomeName", this.clientHomeName);
        }
    }

    public void loadSettingsFromInput(List<BASE_OBJECT> inputObjects) {
        this.databaseObjects.addAll(inputObjects);
    }

    public boolean isMutatingTask() {
        return false;
    }

    @NotNull
    protected String makeOutFilePath(String outputFolder, String outputFileName) {
        String query = null;
        int queryStartPos = ((String)outputFolder).lastIndexOf("?");
        if (queryStartPos != -1) {
            query = ((String)outputFolder).substring(queryStartPos);
            outputFolder = ((String)outputFolder).substring(0, queryStartPos - 1);
        }
        if (!((String)outputFolder).endsWith("/")) {
            outputFolder = (String)outputFolder + "/";
        }
        String outFile = (String)outputFolder + outputFileName;
        if (query != null) {
            outFile = outFile + query;
        }
        return outFile;
    }
}

