/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSource;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedProperty;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedPropertyCache;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerExtendedPropertyOwner;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectClass;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObjectType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableTrigger;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulatorExt;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectWithScript;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSManipulationType;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public abstract class SQLServerTableBase
extends JDBCTable<SQLServerDataSource, SQLServerSchema>
implements SQLServerObject,
SQLServerExtendedPropertyOwner,
DBPNamedObject2,
DBPRefreshableObject,
DBSObjectWithScript,
DBPScriptObjectExt2,
DBPSystemObject,
DBSDataManipulatorExt {
    private static final Log log = Log.getLog(SQLServerTableBase.class);
    private long objectId;
    private String type;
    private String description;
    protected Long rowCount;
    private final SQLServerExtendedPropertyCache extendedPropertyCache = new SQLServerExtendedPropertyCache();

    protected SQLServerTableBase(SQLServerSchema schema) {
        super((DBSObject)schema, false);
    }

    protected SQLServerTableBase(DBRProgressMonitor monitor, SQLServerSchema catalog, SQLServerTableBase source) throws DBException {
        super((DBSObject)catalog, (DBSEntity)source, false);
    }

    protected SQLServerTableBase(@NotNull SQLServerSchema catalog, @NotNull ResultSet dbResult, @NotNull String name) {
        super((DBSObject)catalog, name, true);
        this.objectId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"object_id");
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
        this.type = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"type");
    }

    @Override
    @NotNull
    public SQLServerDatabase getDatabase() {
        return this.getSchema().getDatabase();
    }

    public SQLServerSchema getSchema() {
        return (SQLServerSchema)this.getContainer();
    }

    public JDBCStructCache<SQLServerSchema, ? extends JDBCTable, ? extends JDBCTableColumn> getCache() {
        return ((SQLServerSchema)this.getContainer()).getTableCache();
    }

    @Property(viewable=false, editable=false, order=5)
    public long getObjectId() {
        return this.objectId;
    }

    @Property(order=6)
    public String getType() {
        return this.type;
    }

    public boolean isSystem() {
        return SQLServerObjectType.S.name().equals(this.type);
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<SQLServerTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        List childColumns = ((SQLServerSchema)this.getContainer()).getTableCache().getChildren(monitor, (SQLServerSchema)this.getContainer(), this);
        if (childColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<SQLServerTableColumn> columns = new ArrayList<SQLServerTableColumn>(childColumns);
        columns.sort(DBUtils.orderComparator());
        return columns;
    }

    public SQLServerTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (SQLServerTableColumn)((SQLServerSchema)this.getContainer()).getTableCache().getChild(monitor, (SQLServerSchema)this.getContainer(), this, attributeName);
    }

    public SQLServerTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull long columnId) throws DBException {
        for (SQLServerTableColumn col : this.getAttributes(monitor)) {
            if (col.getObjectId() != columnId) continue;
            return col;
        }
        log.error((Object)("Column '" + columnId + "' not found in table '" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "'"));
        return null;
    }

    @Association
    public Collection<SQLServerTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return ((SQLServerSchema)this.getContainer()).getIndexCache().getObjects(monitor, this.getSchema(), this);
    }

    public SQLServerTableIndex getIndex(DBRProgressMonitor monitor, long indexId) throws DBException {
        for (SQLServerTableIndex index : this.getIndexes(monitor)) {
            if (index.getObjectId() != indexId) continue;
            return index;
        }
        log.error((Object)("Index '" + indexId + "' not found in table '" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "'"));
        return null;
    }

    public SQLServerTableIndex getIndex(DBRProgressMonitor monitor, String name) throws DBException {
        for (SQLServerTableIndex index : this.getIndexes(monitor)) {
            if (!CommonUtils.equalObjects((Object)name, (Object)index.getName())) continue;
            return index;
        }
        log.error((Object)("Index '" + name + "' not found in table '" + this.getFullyQualifiedName(DBPEvaluationContext.DML) + "'"));
        return null;
    }

    @Property(category="Statistics", viewable=false, expensive=true, order=23)
    public Long getRowCount(DBRProgressMonitor monitor) throws DBCException {
        if (this.rowCount != null || !this.isPersisted()) {
            return this.rowCount;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read row count");){
                this.rowCount = this.countData((DBCExecutionSource)new AbstractExecutionSource((DBSDataContainer)this, session.getExecutionContext(), (Object)this), session, null, 0L);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException e) {
            log.debug((Object)"Can't fetch row count", (Throwable)e);
        }
        if (this.rowCount == null) {
            this.rowCount = -1L;
        }
        return this.rowCount;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        if (!SQLServerUtils.supportsCrossDatabaseQueries((JDBCDataSource)this.getDataSource())) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
        }
        if (this.isView() && context == DBPEvaluationContext.DDL) {
            return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
        }
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getDatabase(), this.getSchema(), this});
    }

    public void beforeDataChange(@NotNull DBCSession session, @NotNull DBSManipulationType type, @NotNull DBSAttributeBase[] attributes, @NotNull DBCExecutionSource source) throws DBCException {
        if (this.hasIdentityInsert(type, attributes)) {
            this.enableIdentityInsert(session, true);
        }
    }

    public void afterDataChange(@NotNull DBCSession session, @NotNull DBSManipulationType type, @NotNull DBSAttributeBase[] attributes, @NotNull DBCExecutionSource source) throws DBCException {
        if (this.hasIdentityInsert(type, attributes)) {
            this.enableIdentityInsert(session, false);
        }
    }

    private void enableIdentityInsert(DBCSession session, boolean enable) throws DBCException {
        try {
            JDBCUtils.executeStatement((Connection)((JDBCSession)session), (String)("SET IDENTITY_INSERT " + this.getFullyQualifiedName(DBPEvaluationContext.DML) + " " + (enable ? " ON" : "OFF")));
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    private boolean hasIdentityInsert(@NotNull DBSManipulationType type, @NotNull DBSAttributeBase[] attributes) {
        if (type == DBSManipulationType.INSERT) {
            DBSAttributeBase[] dBSAttributeBaseArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                DBSAttributeBase attr = dBSAttributeBaseArray[n2];
                if (attr instanceof SQLServerTableColumn && ((SQLServerTableColumn)attr).isIdentity()) {
                    return true;
                }
                if (attr.isAutoGenerated()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.rowCount = null;
        if (this.supportsTriggers()) {
            ((SQLServerSchema)this.getContainer()).getTriggerCache().clearChildrenOf(this);
        }
        this.extendedPropertyCache.clearCache();
        return ((SQLServerSchema)this.getContainer()).getTableCache().refreshObject(monitor, (SQLServerSchema)this.getContainer(), this);
    }

    abstract boolean supportsTriggers();

    boolean isClustered(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.isView()) {
            return false;
        }
        Collection<SQLServerTableIndex> indexes = this.getIndexes(monitor);
        if (!CommonUtils.isEmpty(indexes)) {
            for (SQLServerTableIndex index : indexes) {
                if (index.getIndexType() != DBSIndexType.CLUSTERED || !index.isColumnStore()) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Association
    public List<SQLServerTableTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!this.supportsTriggers()) {
            return Collections.emptyList();
        }
        SQLServerSchema schema = this.getSchema();
        ArrayList<SQLServerTableTrigger> triggers = new ArrayList<SQLServerTableTrigger>();
        for (SQLServerTableTrigger trigger : schema.getTriggerCache().getAllObjects(monitor, schema)) {
            if (this != trigger.getTable()) continue;
            triggers.add(trigger);
        }
        return triggers;
    }

    @Association
    @NotNull
    public Collection<SQLServerExtendedProperty> getExtendedProperties(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.extendedPropertyCache.getAllObjects(monitor, this);
    }

    @Override
    public long getMajorObjectId() {
        return this.getObjectId();
    }

    @Override
    public long getMinorObjectId() {
        return 0L;
    }

    @Override
    public Pair<String, SQLServerObject> getExtendedPropertyObject(@NotNull DBRProgressMonitor monitor, int level) {
        switch (level) {
            case 0: {
                return new Pair((Object)"Schema", (Object)this.getSchema());
            }
            case 1: {
                return new Pair((Object)"Table", (Object)this);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SQLServerObjectClass getExtendedPropertyObjectClass() {
        return SQLServerObjectClass.OBJECT_OR_COLUMN;
    }

    @Override
    @NotNull
    public SQLServerExtendedPropertyCache getExtendedPropertyCache() {
        return this.extendedPropertyCache;
    }
}

