/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.sql.SQLDialectInsertReplaceMethod;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadataRegistry;
import org.jkiss.dbeaver.model.sql.registry.SQLDialectDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLInsertReplaceMethodDescriptor;
import org.jkiss.utils.CommonUtils;
import org.osgi.service.component.annotations.Component;

@Component
public class SQLDialectRegistry
implements SQLDialectMetadataRegistry {
    static final String TAG_DIALECT = "dialect";
    private static final String TAG_METHOD = "method";
    private final Map<String, SQLDialectDescriptor> dialects = new LinkedHashMap<String, SQLDialectDescriptor>();
    private final List<SQLInsertReplaceMethodDescriptor> insertMethods = new ArrayList<SQLInsertReplaceMethodDescriptor>();

    public SQLDialectRegistry() {
        this.loadExtensions(Platform.getExtensionRegistry());
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement ext;
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlDialect");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if (TAG_DIALECT.equals(ext.getName())) {
                SQLDialectDescriptor dialectDescriptor = new SQLDialectDescriptor(ext);
                this.dialects.put(dialectDescriptor.getId(), dialectDescriptor);
            }
            ++n2;
        }
        iConfigurationElementArray = extConfigs;
        n = extConfigs.length;
        n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if (TAG_DIALECT.equals(ext.getName())) {
                String dialectId = ext.getAttribute("id");
                String parentDialectId = ext.getAttribute("parent");
                if (!CommonUtils.isEmpty((String)dialectId) && !CommonUtils.isEmpty((String)parentDialectId)) {
                    SQLDialectDescriptor dialect = this.dialects.get(dialectId);
                    SQLDialectDescriptor parentDialect = this.dialects.get(parentDialectId);
                    if (dialect != null && parentDialect != null) {
                        dialect.setParentDialect(parentDialect);
                    }
                }
            }
            ++n2;
        }
        iConfigurationElementArray = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlInsertMethod");
        n = iConfigurationElementArray.length;
        n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if (TAG_METHOD.equals(ext.getName())) {
                this.insertMethods.add(new SQLInsertReplaceMethodDescriptor(ext));
            }
            ++n2;
        }
    }

    public void dispose() {
        this.dialects.clear();
    }

    public List<SQLDialectMetadata> getDialects() {
        return new ArrayList<SQLDialectMetadata>(this.dialects.values());
    }

    public SQLDialectDescriptor getDialect(String id) {
        return this.dialects.get(id);
    }

    public List<SQLDialectMetadata> getRootDialects() {
        ArrayList<SQLDialectMetadata> roots = new ArrayList<SQLDialectMetadata>();
        for (SQLDialectDescriptor dd : this.dialects.values()) {
            if (dd.getParentDialect() != null) continue;
            roots.add(dd);
        }
        return roots;
    }

    public List<SQLInsertReplaceMethodDescriptor> getInsertMethods() {
        return new ArrayList<SQLInsertReplaceMethodDescriptor>(this.insertMethods);
    }

    public SQLDialectInsertReplaceMethod getInsertReplaceMethod(String insertMethodId) {
        for (SQLInsertReplaceMethodDescriptor method : this.insertMethods) {
            if (!method.getId().equalsIgnoreCase(insertMethodId)) continue;
            return method;
        }
        return null;
    }

    public SQLInsertReplaceMethodDescriptor getInsertMethodOnLabel(String label) {
        for (SQLInsertReplaceMethodDescriptor method : this.insertMethods) {
            if (!method.getLabel().equalsIgnoreCase(label)) continue;
            return method;
        }
        return null;
    }
}

