/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.HelpEnabledDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverSelectViewer;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverTreeViewer;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class DriverManagerDialog
extends HelpEnabledDialog
implements ISelectionChangedListener,
IDoubleClickListener {
    private static final String DIALOG_ID = "DBeaver.DriverManagerDialog";
    private static final String DEFAULT_DS_PROVIDER = "generic";
    private static final boolean SHOW_EXPORT = false;
    private DataSourceProviderDescriptor selectedProvider;
    private DataSourceProviderDescriptor onlyManagableProvider;
    private String selectedCategory;
    private DriverDescriptor selectedDriver;
    private Button newButton;
    private Button copyButton;
    private Button editButton;
    private Button deleteButton;
    private DriverSelectViewer treeControl;
    private Text descText;

    public DriverManagerDialog(Shell shell) {
        super(shell, "database-drivers");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        List enabledProviders = DataSourceProviderRegistry.getInstance().getEnabledDataSourceProviders();
        DBPDataSourceProviderDescriptor manProvider = null;
        for (DBPDataSourceProviderDescriptor provider : DataSourceProviderRegistry.getInstance().getEnabledDataSourceProviders()) {
            if (!provider.isDriversManagable()) continue;
            if (manProvider != null) {
                manProvider = null;
                break;
            }
            manProvider = provider;
        }
        if (manProvider != null) {
            this.onlyManagableProvider = (DataSourceProviderDescriptor)manProvider;
        }
        this.getShell().setText(UIConnectionMessages.dialog_driver_manager_title);
        this.getShell().setMinimumSize(300, 300);
        ImageDescriptor dialogImage = DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.DRIVER_MANAGER);
        Image image = dialogImage.createImage();
        this.getShell().setImage(image);
        this.getShell().addDisposeListener(e -> UIUtils.dispose((Resource)image));
        Composite group = UIUtils.createPlaceholder((Composite)super.createDialogArea(parent), (int)2);
        group.setLayoutData((Object)new GridData(1808));
        this.treeControl = new DriverSelectViewer(group, (Object)this, enabledProviders, false, DriverSelectViewer.SelectorViewType.tree);
        GridData gd = new GridData(1808);
        gd.heightHint = 400;
        gd.widthHint = 500;
        this.treeControl.getControl().setLayoutData((Object)gd);
        Composite buttonBar = new Composite(group, 128);
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        GridData gd2 = new GridData(1040);
        buttonBar.setLayoutData((Object)gd2);
        this.newButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIConnectionMessages.dialog_driver_manager_button_new, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverManagerDialog.this.createDriver();
            }
        });
        this.newButton.setLayoutData((Object)new GridData(768));
        this.copyButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIConnectionMessages.dialog_driver_manager_button_copy, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverManagerDialog.this.copyDriver();
            }
        });
        this.copyButton.setLayoutData((Object)new GridData(768));
        this.editButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIConnectionMessages.dialog_driver_manager_button_edit, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverManagerDialog.this.editDriver();
            }
        });
        this.editButton.setLayoutData((Object)new GridData(768));
        this.deleteButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIConnectionMessages.dialog_driver_manager_button_delete, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DriverManagerDialog.this.deleteDriver();
            }
        });
        this.deleteButton.setLayoutData((Object)new GridData(768));
        Button unDeleteButton = UIUtils.createPushButton((Composite)buttonBar, (String)UIConnectionMessages.dialog_driver_manager_button_undelete, null, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DriverManagerDialog.this.undeleteDrivers()) {
                    DriverManagerDialog.this.treeControl.refresh();
                }
            }
        });
        unDeleteButton.setLayoutData((Object)new GridData(768));
        Composite legend = UIUtils.createPlaceholder((Composite)buttonBar, (int)2, (int)5);
        gd2 = new GridData(768);
        gd2.verticalIndent = 5;
        gd2.horizontalSpan = 2;
        legend.setLayoutData((Object)gd2);
        UIUtils.createLabel((Composite)legend, (DBPImage)DBIcon.OVER_LAMP);
        UIUtils.createLabel((Composite)legend, (String)UIConnectionMessages.dialog_driver_manager_label_user_defined);
        UIUtils.createLabel((Composite)legend, (DBPImage)DBIcon.OVER_ERROR);
        UIUtils.createLabel((Composite)legend, (String)UIConnectionMessages.dialog_driver_manager_label_unavailable);
        this.descText = new Text(group, 8);
        gd = new GridData(768);
        gd.verticalIndent = 5;
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        this.descText.setLayoutData((Object)gd);
        this.setDefaultSelection();
        this.updateButtons();
        return group;
    }

    private void exportDriverList() {
        if (!(this.treeControl.getSelectorViewer() instanceof DriverTreeViewer)) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        DriverTreeViewer driverTreeViewer = (DriverTreeViewer)this.treeControl.getSelectorViewer();
        List driverList = (List)driverTreeViewer.getInput();
        for (Object dObj : driverList) {
            if (dObj instanceof DriverTreeViewer.DriverCategory) {
                DriverTreeViewer.DriverCategory category = (DriverTreeViewer.DriverCategory)dObj;
                buf.append(category.getName()).append("\n");
                for (DriverDescriptor driver : category.getDrivers()) {
                    buf.append("\t");
                    this.printDriverInfo(buf, driver);
                }
                continue;
            }
            if (!(dObj instanceof DriverDescriptor)) continue;
            DriverDescriptor driver = (DriverDescriptor)dObj;
            this.printDriverInfo(buf, driver);
        }
        UIUtils.setClipboardContents((Display)Display.getCurrent(), (Transfer)TextTransfer.getInstance(), (Object)buf.toString());
    }

    private void printDriverInfo(StringBuilder buf, DriverDescriptor driver) {
        if (driver.isDisabled() || driver.getReplacedBy() != null || driver.isCustom()) {
            return;
        }
        buf.append(driver.getName());
        if (driver.getIcon() == DBIcon.DATABASE_DEFAULT || driver.getIcon() instanceof DBIcon && driver.getIcon().getLocation().endsWith("database.png")) {
            buf.append("\tN/A");
        } else {
            buf.append("\t+");
        }
        buf.append("\n");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.setReturnCode(0);
            this.close();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setDefaultSelection();
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
            if (selectedObject instanceof DriverDescriptor) {
                this.selectedDriver = (DriverDescriptor)selectedObject;
                this.selectedCategory = this.selectedDriver.getCategory();
                this.selectedProvider = this.selectedDriver.getProviderDescriptor();
            } else if (selectedObject instanceof DataSourceProviderDescriptor) {
                this.selectedProvider = (DataSourceProviderDescriptor)selectedObject;
            } else if (selectedObject instanceof DriverTreeViewer.DriverCategory) {
                this.selectedCategory = ((DriverTreeViewer.DriverCategory)selectedObject).getName();
            }
        }
        this.updateButtons();
    }

    private void setDefaultSelection() {
        this.selectedDriver = null;
        this.selectedProvider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(DEFAULT_DS_PROVIDER);
        this.selectedCategory = null;
    }

    public void doubleClick(DoubleClickEvent event) {
        if (this.selectedDriver != null) {
            this.editDriver();
        }
    }

    private void updateButtons() {
        this.newButton.setEnabled(this.onlyManagableProvider != null || this.selectedProvider != null && this.selectedProvider.isDriversManagable());
        this.copyButton.setEnabled(this.selectedDriver != null && this.selectedDriver.isManagable());
        this.editButton.setEnabled(this.selectedDriver != null);
        this.deleteButton.setEnabled(this.selectedDriver != null && this.selectedDriver.getProviderDescriptor().isDriversManagable());
        if (this.selectedDriver != null) {
            this.descText.setText(CommonUtils.toString((Object)this.selectedDriver.getDescription()));
        } else if (this.selectedCategory != null) {
            this.descText.setText(this.selectedCategory + " drivers");
        } else if (this.selectedProvider != null) {
            this.descText.setText(this.selectedProvider.getName() + " provider");
        } else {
            this.descText.setText("");
        }
    }

    private void createDriver() {
        if (this.onlyManagableProvider != null || this.selectedProvider != null) {
            DriverEditDialog dialog;
            DataSourceProviderDescriptor provider = this.selectedProvider;
            if (provider == null || !provider.isDriversManagable()) {
                provider = this.onlyManagableProvider;
            }
            if ((dialog = new DriverEditDialog(this.getShell(), provider, this.selectedCategory)).open() == 0) {
                this.treeControl.refresh();
                this.treeControl.setSelection((ISelection)new StructuredSelection((Object)dialog.getDriver()));
            }
        }
    }

    private void copyDriver() {
        DriverEditDialog dialog;
        if (this.selectedDriver != null && (dialog = new DriverEditDialog(this.getShell(), this.selectedDriver.getProviderDescriptor(), this.selectedDriver)).open() == 0) {
            this.treeControl.refresh();
            this.treeControl.setSelection((ISelection)new StructuredSelection((Object)dialog.getDriver()));
        }
    }

    private void editDriver() {
        DriverDescriptor driver = this.selectedDriver;
        if (driver != null) {
            DriverEditDialog dialog = new DriverEditDialog(this.getShell(), (DBPDriver)driver);
            dialog.open();
            this.treeControl.refresh((DBPDriver)driver);
        }
    }

    private void deleteDriver() {
        List usedDS = DriverUtils.getUsedBy((DBPDriver)this.selectedDriver, (List)DataSourceRegistry.getAllDataSources());
        if (!usedDS.isEmpty()) {
            StringBuilder message = new StringBuilder(NLS.bind((String)UIConnectionMessages.dialog_driver_manager_message_cant_delete_text, (Object)this.selectedDriver.getName()));
            for (DBPDataSourceContainer ds : usedDS) {
                message.append("\n - ").append(ds.getName());
            }
            UIUtils.showMessageBox((Shell)this.getShell(), (String)UIConnectionMessages.dialog_driver_manager_message_cant_delete_title, (String)message.toString(), (int)1);
            return;
        }
        if (UIUtils.confirmAction((Shell)this.getShell(), (String)UIConnectionMessages.dialog_driver_manager_message_delete_driver_title, (String)(UIConnectionMessages.dialog_driver_manager_message_delete_driver_text + this.selectedDriver.getName() + "'?"))) {
            this.selectedDriver.getProviderDescriptor().removeDriver(this.selectedDriver);
            this.selectedDriver.getProviderDescriptor().getRegistry().saveDrivers();
            this.treeControl.refresh();
        }
    }

    private boolean undeleteDrivers() {
        final ArrayList drivers = new ArrayList();
        BaseDialog dialog = new BaseDialog(this.getShell(), "Restore deleted driver(s)", null){

            protected Composite createDialogArea(Composite parent) {
                Composite composite = super.createDialogArea(parent);
                Table driverTable = new Table(composite, 67616);
                driverTable.setLayoutData((Object)new GridData(1808));
                for (DBPDataSourceProviderDescriptor dspd : DataSourceProviderRegistry.getInstance().getEnabledDataSourceProviders()) {
                    for (DBPDriver dd : dspd.getDrivers()) {
                        if (!dd.isDisabled()) continue;
                        TableItem item = new TableItem(driverTable, 0);
                        item.setImage(DBeaverIcons.getImage((DBPImage)dd.getIcon()));
                        item.setText(dd.getName());
                        item.setData((Object)dd);
                    }
                }
                driverTable.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                    if (((TableItem)e.item).getChecked()) {
                        drivers.add((DriverDescriptor)e.item.getData());
                    } else {
                        drivers.remove((DriverDescriptor)e.item.getData());
                    }
                }));
                return super.createDialogArea(parent);
            }
        };
        if (dialog.open() == 0) {
            for (DriverDescriptor dd : drivers) {
                dd.setDisabled(false);
                dd.getProviderDescriptor().getRegistry().saveDrivers();
            }
            return true;
        }
        return false;
    }

    public boolean close() {
        return super.close();
    }
}

