/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPApplicationDesktop;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMTransactionState;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.DisconnectJob;
import org.jkiss.dbeaver.runtime.jobs.EndIdleTransactionsJob;
import org.jkiss.dbeaver.runtime.jobs.KeepAlivePingJob;

public class DataSourceMonitorJob
extends AbstractJob {
    private static final int MONITOR_INTERVAL = 3000;
    private static final long SYSTEM_SUSPEND_INTERVAL = 30000L;
    private static final Log log = Log.getLog(DataSourceMonitorJob.class);
    private static final int MAX_FAILED_ATTEMPTS_BEFORE_DISCONNECT = 5;
    private static final int MAX_FAILED_ATTEMPTS_BEFORE_IGNORE = 10;
    private final DBPPlatform platform;
    private final Map<String, Long> checkCache = new HashMap<String, Long>();
    private final Set<String> pingCache = new HashSet<String>();
    private long lastPingTime = -1L;

    public DataSourceMonitorJob(DBPPlatform platform) {
        super("Keep-Alive monitor");
        this.setUser(false);
        this.setSystem(true);
        this.platform = platform;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        if (this.platform.isShuttingDown()) {
            return Status.OK_STATUS;
        }
        if (this.lastPingTime > 0L && System.currentTimeMillis() - this.lastPingTime > 30000L) {
            log.debug("System suspend detected! Reinitialize all remote connections.");
        }
        this.lastPingTime = System.currentTimeMillis();
        DBPWorkspace workspace = this.platform.getWorkspace();
        for (DBPProject dBPProject : workspace.getProjects()) {
            if (!dBPProject.isOpen() || !dBPProject.isRegistryLoaded()) continue;
            DBPDataSourceRegistry dataSourceRegistry = dBPProject.getDataSourceRegistry();
            for (DBPDataSourceContainer dBPDataSourceContainer : dataSourceRegistry.getDataSources()) {
                this.checkDataSourceAlive(dBPDataSourceContainer);
            }
        }
        if (!this.platform.isShuttingDown()) {
            this.scheduleMonitor();
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDataSourceAlive(DBPDataSourceContainer dataSourceDescriptor) {
        Date connectTime;
        Long lastCheckTime;
        int keepAliveInterval;
        if (!dataSourceDescriptor.isConnected()) {
            return;
        }
        final String dsId = dataSourceDescriptor.getId();
        DataSourceMonitorJob dataSourceMonitorJob = this;
        synchronized (dataSourceMonitorJob) {
            if (this.pingCache.contains(dsId)) {
                return;
            }
        }
        if (dataSourceDescriptor.isAutoCloseTransactions() || dataSourceDescriptor.getConnectionConfiguration().getCloseIdleInterval() > 0) {
            this.endIdleTransactions(dataSourceDescriptor);
        }
        if ((keepAliveInterval = dataSourceDescriptor.getConnectionConfiguration().getKeepAliveInterval()) <= 0) {
            return;
        }
        DBPDataSource dataSource = dataSourceDescriptor.getDataSource();
        if (dataSource == null) {
            return;
        }
        DataSourceMonitorJob dataSourceMonitorJob2 = this;
        synchronized (dataSourceMonitorJob2) {
            lastCheckTime = this.checkCache.get(dsId);
        }
        if (lastCheckTime == null && (connectTime = dataSourceDescriptor.getConnectTime()) != null) {
            lastCheckTime = connectTime.getTime();
        }
        if (lastCheckTime == null) {
            log.debug("Can't determine last check time for " + dsId);
            return;
        }
        long curTime = System.currentTimeMillis();
        if ((curTime - lastCheckTime) / 1000L > (long)keepAliveInterval) {
            boolean disconnectOnError = false;
            int failedAttemptCount = KeepAlivePingJob.getFailedAttemptCount(dataSource);
            if (failedAttemptCount >= 10) {
                return;
            }
            if (failedAttemptCount > 5) {
                disconnectOnError = true;
            }
            KeepAlivePingJob pingJob = new KeepAlivePingJob(dataSource, disconnectOnError);
            pingJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    DataSourceMonitorJob dataSourceMonitorJob = DataSourceMonitorJob.this;
                    synchronized (dataSourceMonitorJob) {
                        DataSourceMonitorJob.this.checkCache.put(dsId, System.currentTimeMillis());
                        DataSourceMonitorJob.this.pingCache.remove(dsId);
                    }
                }
            });
            DataSourceMonitorJob dataSourceMonitorJob3 = this;
            synchronized (dataSourceMonitorJob3) {
                this.pingCache.add(dsId);
            }
            pingJob.schedule();
        }
    }

    private void endIdleTransactions(DBPDataSourceContainer dsDescriptor) {
        if (!dsDescriptor.isConnected()) {
            return;
        }
        long lastUserActivityTime = DataSourceMonitorJob.getLastUserActivityTime();
        if (lastUserActivityTime < 0L) {
            return;
        }
        long idleInterval = (System.currentTimeMillis() - lastUserActivityTime) / 1000L;
        long disconnectTimeoutSeconds = DataSourceMonitorJob.getDisconnectTimeoutSeconds(dsDescriptor);
        long rollbackTimeoutSeconds = DataSourceMonitorJob.getTransactionTimeoutSeconds(dsDescriptor);
        if (disconnectTimeoutSeconds > 0L && idleInterval > disconnectTimeoutSeconds) {
            if (DisconnectJob.isInProcess(dsDescriptor)) {
                return;
            }
            DisconnectJob disconnectJob = new DisconnectJob(dsDescriptor);
            disconnectJob.schedule();
            return;
        }
        if (idleInterval < rollbackTimeoutSeconds) {
            return;
        }
        if (EndIdleTransactionsJob.isInProcess(dsDescriptor)) {
            return;
        }
        DBPDataSource dataSource = dsDescriptor.getDataSource();
        if (dataSource != null) {
            try {
                IdentityHashMap<DBCExecutionContext, DBCTransactionManager> txnToEnd = new IdentityHashMap<DBCExecutionContext, DBCTransactionManager>();
                for (DBSInstance dBSInstance : dataSource.getAvailableInstances()) {
                    DBCExecutionContext[] dBCExecutionContextArray = dBSInstance.getAllContexts();
                    int n = dBCExecutionContextArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        QMTransactionState txnState;
                        DBCTransactionManager txnManager;
                        DBCExecutionContext ec = dBCExecutionContextArray[n2];
                        if (ec.isConnected() && (txnManager = DBUtils.getTransactionManager(ec)) != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit() && (txnState = QMUtils.getTransactionState(ec)).getUpdateCount() > 0 && txnState.getTransactionStartTime() <= lastUserActivityTime) {
                            txnToEnd.put(ec, txnManager);
                        }
                        ++n2;
                    }
                }
                if (!txnToEnd.isEmpty()) {
                    new EndIdleTransactionsJob(dataSource, txnToEnd).schedule();
                }
            }
            catch (DBCException e) {
                log.error(e);
            }
        }
    }

    public void scheduleMonitor() {
        this.schedule(3000L);
    }

    public static long getDisconnectTimeoutSeconds(@NotNull DBPDataSourceContainer container) {
        int timeout = container.getConnectionConfiguration().getCloseIdleInterval();
        return Math.max(0, timeout);
    }

    public static long getTransactionTimeoutSeconds(@NotNull DBPDataSourceContainer container) {
        DBPConnectionType connectionType;
        DBPPreferenceStore pref = container.getPreferenceStore();
        DBPConnectionConfiguration config = container.getConnectionConfiguration();
        long ttlSeconds = 0L;
        if (pref.contains("transaction.auto.close.enabled")) {
            ttlSeconds = pref.getLong("transaction.auto.close.ttl");
        }
        if (ttlSeconds == 0L && (connectionType = config.getConnectionType()).isAutoCloseTransactions()) {
            ttlSeconds = connectionType.getCloseIdleConnectionPeriod();
        }
        return Math.max(0L, ttlSeconds);
    }

    /*
     * WARNING - void declaration
     */
    public static long getLastUserActivityTime() {
        long lastUserActivityTime = -1L;
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (dBPApplication instanceof DBPApplicationDesktop) {
            void app;
            DBPApplicationDesktop dBPApplicationDesktop = (DBPApplicationDesktop)dBPApplication;
            DBPApplicationDesktop cfr_ignored_0 = (DBPApplicationDesktop)dBPApplication;
            lastUserActivityTime = app.getLastUserActivityTime();
        }
        return lastUserActivityTime;
    }
}

