/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.jobs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ConnectJob
extends AbstractJob {
    private static final Log log = Log.getLog(ConnectJob.class);
    private volatile Thread connectThread;
    protected boolean initialize = true;
    protected boolean reflect = true;
    protected Throwable connectError;
    protected IStatus connectStatus;
    protected final DBPDataSourceContainer container;

    public ConnectJob(DBPDataSourceContainer container) {
        super("Connect to '" + container.getName() + "'");
        this.setUser(true);
        this.container = container;
    }

    public IStatus getConnectStatus() {
        return this.connectStatus;
    }

    public Throwable getConnectError() {
        return this.connectError;
    }

    @Override
    protected IStatus run(DBRProgressMonitor monitor) {
        try {
            String oldName;
            if (this.container.getDriver().isDeprecated()) {
                throw new DBException("Driver " + this.container.getDriver().getFullName() + " is deprecated. Please see the connection page for more info.");
            }
            this.connectThread = this.getThread();
            String string = oldName = this.connectThread == null ? null : this.connectThread.getName();
            if (this.reflect && this.connectThread != null) {
                this.connectThread.setName(this.getName());
            }
            try {
                boolean connected = this.container.connect(monitor, this.initialize, this.reflect);
                this.connectStatus = connected ? Status.OK_STATUS : Status.CANCEL_STATUS;
            }
            finally {
                if (this.connectThread != null && oldName != null) {
                    this.connectThread.setName(oldName);
                    this.connectThread = null;
                }
            }
        }
        catch (Throwable ex) {
            this.connectError = ex;
            this.connectStatus = GeneralUtils.makeExceptionStatus(ex);
        }
        return Status.OK_STATUS;
    }

    public IStatus runSync(DBRProgressMonitor monitor) {
        AbstractJob curJob = (AbstractJob)((Object)CURRENT_JOB.get());
        if (curJob != null) {
            curJob.setAttachedJob(this);
        }
        try {
            this.setThread(Thread.currentThread());
            this.reflect = false;
            IStatus iStatus = this.run(monitor);
            return iStatus;
        }
        finally {
            if (curJob != null) {
                curJob.setAttachedJob(null);
            }
        }
    }

    public boolean belongsTo(Object family) {
        return this.container == family;
    }

    @Override
    protected void canceling() {
        if (this.connectThread != null) {
            this.connectThread.interrupt();
        }
    }
}

