/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPMessageType;

public class DBeaverNotifications {
    public static final String NT_COMMIT = "commit";
    public static final String NT_ROLLBACK = "rollback";
    public static final String NT_ROLLBACK_IDLE = "rollback.idle";
    public static final String NT_RECONNECT_SUCCESS = "reconnect.success";
    public static final String NT_RECONNECT_FAILURE = "reconnect.failure";
    public static final String NT_GENERIC = "generic";
    @NotNull
    private static NotificationHandler notificationHandler = new ConsoleHandler();

    public static void showNotification(DBPDataSource dataSource, String id, String text, DBPMessageType messageType) {
        DBeaverNotifications.showNotification(dataSource, id, text, messageType, null);
    }

    public static void showNotification(DBPDataSource dataSource, String id, String text, DBPMessageType messageType, Runnable feedback) {
        notificationHandler.sendNotification(dataSource, id, text, messageType, feedback);
    }

    public static void showNotification(String id, String title, String text, DBPMessageType messageType, Runnable feedback) {
        notificationHandler.sendNotification(id, title, text, messageType, feedback);
    }

    public static void setHandler(@NotNull NotificationHandler handler) {
        notificationHandler = handler;
    }

    private static class ConsoleHandler
    implements NotificationHandler {
        private ConsoleHandler() {
        }

        @Override
        public void sendNotification(DBPDataSource dataSource, String id, String text, DBPMessageType messageType, Runnable feedback) {
            System.out.println(text);
        }

        @Override
        public void sendNotification(String id, String title, String text, DBPMessageType messageType, Runnable feedback) {
            System.out.println(title + "\n\t" + text);
        }
    }

    public static interface NotificationHandler {
        public void sendNotification(DBPDataSource var1, String var2, String var3, DBPMessageType var4, Runnable var5);

        public void sendNotification(String var1, String var2, String var3, DBPMessageType var4, Runnable var5);
    }
}

