/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.secret;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionSecretKeeper;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public interface DBSSecretController {
    @Nullable
    public String getSecretValue(@NotNull String var1) throws DBException;

    public void setSecretValue(@NotNull String var1, @Nullable String var2) throws DBException;

    public void flushChanges() throws DBException;

    @NotNull
    public static DBSSecretController getProjectSecretController(DBPProject project) throws DBException {
        return DBSSecretController.getSessionSecretController(project.getWorkspaceSession());
    }

    @NotNull
    public static DBSSecretController getGlobalSecretController() throws DBException {
        return DBSSecretController.getSessionSecretController(DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession());
    }

    @NotNull
    public static DBSSecretController getSessionSecretController(SMSession spaceSession) throws DBException {
        DBSSecretController secretController;
        SMSessionSecretKeeper secretKeeper = DBUtils.getAdapter(SMSessionSecretKeeper.class, spaceSession);
        if (secretKeeper != null && (secretController = secretKeeper.getSecretController()) != null) {
            return secretController;
        }
        throw new IllegalStateException("Session secret controller not found");
    }
}

