/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBInfoUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConfigurationProfile;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.rm.RMProjectType;
import org.jkiss.dbeaver.model.secret.DBSSecret;
import org.jkiss.dbeaver.model.secret.DBSSecretBrowser;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.secret.DBSSecretSubject;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class DBWNetworkProfile
extends DBPConfigurationProfile {
    public static final String PROFILE_KEY_PREFIX = "/network-profile/";
    private transient DBSSecretSubject secretSubject;
    @NotNull
    private final List<DBWHandlerConfiguration> configurations = new ArrayList<DBWHandlerConfiguration>();

    @NotNull
    public List<DBWHandlerConfiguration> getConfigurations() {
        return this.configurations;
    }

    public DBWNetworkProfile() {
    }

    public DBWNetworkProfile(DBPProject project) {
        super(project);
    }

    @Override
    public String getProfileSource() {
        return this.secretSubject == null ? null : this.secretSubject.getSecretSubjectId();
    }

    public void setSecretSubject(DBSSecretSubject secretSubject) {
        this.secretSubject = secretSubject;
    }

    public void updateConfiguration(@NotNull DBWHandlerConfiguration cfg) {
        int i = 0;
        while (i < this.configurations.size()) {
            DBWHandlerConfiguration c = this.configurations.get(i);
            if (Objects.equals(cfg.getId(), c.getId())) {
                this.configurations.set(i, cfg);
                return;
            }
            ++i;
        }
        this.configurations.add(cfg);
    }

    @Nullable
    public DBWHandlerConfiguration getConfiguration(DBWHandlerDescriptor handler) {
        for (DBWHandlerConfiguration cfg : this.configurations) {
            if (!Objects.equals(cfg.getId(), handler.getId())) continue;
            return cfg;
        }
        return null;
    }

    @Nullable
    public DBWHandlerConfiguration getConfiguration(String configId) {
        for (DBWHandlerConfiguration cfg : this.configurations) {
            if (!Objects.equals(cfg.getId(), configId)) continue;
            return cfg;
        }
        return null;
    }

    public String getSecretKeyId() {
        DBPProject project = this.getProject();
        String prefix = project != null ? RMProjectType.getPlainProjectId(project) : (this.secretSubject != null ? this.secretSubject.getSecretSubjectId() : "global");
        return prefix + PROFILE_KEY_PREFIX + this.getProfileId();
    }

    @Override
    public void persistSecrets(DBSSecretController secretController) throws DBException {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("profile-id", this.getProfileId());
        props.put("profile-name", this.getProfileName());
        ArrayList<Map<String, Object>> handlersConfigs = new ArrayList<Map<String, Object>>();
        for (DBWHandlerConfiguration cfg : this.configurations) {
            Map<String, Object> hcProps = cfg.saveToMap();
            if (hcProps.isEmpty()) continue;
            hcProps.put("id", cfg.getId());
            handlersConfigs.add(hcProps);
        }
        if (!handlersConfigs.isEmpty()) {
            props.put("handlers", handlersConfigs);
        }
        String secretValue = DBInfoUtils.SECRET_GSON.toJson(props);
        secretController.setSecretValue(this.getSecretKeyId(), secretValue);
    }

    @Override
    public void resolveSecrets(DBSSecretController secretController) throws DBException {
        String secretValue = secretController.getSecretValue(this.getSecretKeyId());
        if (secretValue == null) {
            if (!DBWorkbench.isDistributed()) {
                this.loadFromLegacySecret(secretController);
            }
            return;
        }
        Map<String, Object> props = JSONUtils.parseMap(DBInfoUtils.SECRET_GSON, new StringReader(secretValue));
        List<Map<String, Object>> handlerConfigs = JSONUtils.getObjectList(props, "handlers");
        for (Map<String, Object> hc : handlerConfigs) {
            String configId = JSONUtils.getString(hc, "id");
            DBWHandlerConfiguration configuration = this.getConfiguration(configId);
            if (configuration == null) continue;
            configuration.loadFromMap(hc);
        }
    }

    private void loadFromLegacySecret(DBSSecretController secretController) throws DBException {
        if (!(secretController instanceof DBSSecretBrowser) || this.getProject() == null) {
            return;
        }
        DBSSecretBrowser secretBrowser = (DBSSecretBrowser)((Object)secretController);
        for (DBWHandlerConfiguration cfg : this.configurations) {
            String prefix = "projects/" + this.getProject().getId() + "/network/" + cfg.getId() + "/profile/" + this.getProfileId();
            LinkedHashMap<String, String> secureProps = new LinkedHashMap<String, String>();
            for (DBSSecret secret : secretBrowser.listSecrets(prefix)) {
                String secretId = secret.getId();
                switch (secret.getName()) {
                    case "user": {
                        cfg.setUserName(secretController.getSecretValue(secretId));
                        break;
                    }
                    case "password": {
                        cfg.setPassword(secretController.getSecretValue(secretId));
                        break;
                    }
                    default: {
                        secureProps.put(secret.getName(), secretController.getSecretValue(secretId));
                    }
                    case "name": 
                }
            }
            if (secureProps.isEmpty()) continue;
            cfg.setSecureProperties(secureProps);
        }
    }
}

