/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.utils.CommonUtils;

public class DBNDatabaseObject
extends DBNDatabaseNode
implements DBSObject {
    private DBXTreeObject meta;

    DBNDatabaseObject(DBNNode parent, DBXTreeObject meta) {
        super(parent);
        this.meta = meta;
        this.registerNode();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSObject.class) {
            DBSObject databaseObject = this.getObject();
            return adapter.cast(databaseObject);
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected void dispose(boolean reflect) {
        this.unregisterNode(reflect);
        super.dispose(reflect);
    }

    @Override
    public DBXTreeObject getMeta() {
        return this.meta;
    }

    @Override
    protected boolean reloadObject(DBRProgressMonitor monitor, DBSObject object) {
        return false;
    }

    @Override
    public DBSObject getObject() {
        return this;
    }

    @Override
    public Object getValueObject() {
        return this;
    }

    @Override
    public String getNodeFullName() {
        StringBuilder pathName = new StringBuilder();
        DBNNode parent = this.getParentNode();
        while (parent != null) {
            String parentName;
            if (!(parent instanceof DBNDatabaseFolder) && !CommonUtils.isEmpty((String)(parentName = parent.getNodeName()))) {
                if (pathName.length() > 0) {
                    pathName.insert(0, '.');
                }
                pathName.insert(0, parentName);
            }
            parent = parent.getParentNode();
        }
        pathName.insert(0, this.getNodeName() + " (");
        pathName.append(")");
        return pathName.toString();
    }

    @Override
    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.meta.getNodeTypeLabel(this.getDataSource(), null);
    }

    @Override
    public String getLocalizedName(String locale) {
        return this.meta.getNodeTypeLabel(this.getDataSource(), locale);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.meta.getDescription();
    }

    @Override
    public DBSObject getParentObject() {
        return this.getParentNode() instanceof DBNDatabaseNode ? ((DBSWrapper)((Object)this.getParentNode())).getObject() : null;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        DBSObject parentObject = this.getParentObject();
        return parentObject == null ? null : parentObject.getDataSource();
    }

    @Override
    public boolean isPersisted() {
        return true;
    }
}

