/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.struct;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPToolTipObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBPositiveNumberTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt2;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectExt3;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractAttribute
implements DBSAttributeBase,
DBSTypedObjectExt2,
DBSTypedObjectExt3,
DBPToolTipObject,
DBPNamedObject2 {
    protected String name;
    protected int valueType;
    protected long maxLength;
    protected boolean required;
    protected boolean autoGenerated;
    protected int scale;
    protected int precision;
    protected String typeName;
    protected int ordinalPosition;

    protected AbstractAttribute() {
    }

    protected AbstractAttribute(DBSAttributeBase source) {
        this(source.getName(), source.getTypeName(), source.getTypeID(), source.getOrdinalPosition(), source.getMaxLength(), source.getScale(), source.getPrecision(), source.isRequired(), source.isAutoGenerated());
    }

    protected AbstractAttribute(String name, String typeName, int valueType, int ordinalPosition, long maxLength, Integer scale, Integer precision, boolean required, boolean autoGenerated) {
        this.name = name;
        this.valueType = valueType;
        this.maxLength = maxLength;
        this.scale = scale == null ? -1 : scale;
        this.precision = precision == null ? -1 : precision;
        this.required = required;
        this.autoGenerated = autoGenerated;
        this.typeName = typeName;
        this.ordinalPosition = ordinalPosition;
    }

    @Override
    @Property(viewable=true, order=10, valueTransformer=DBObjectNameCaseTransformer.class)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String columnName) {
        this.name = columnName;
    }

    @Override
    @Property(viewable=true, order=15, valueRenderer=DBPositiveNumberTransformer.class)
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public void setOrdinalPosition(int ordinalPosition) {
        this.ordinalPosition = ordinalPosition;
    }

    @Override
    @Property(viewable=true, order=20)
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getFullTypeName() {
        return DBUtils.getFullTypeName(this);
    }

    @Override
    public void setTypeName(String typeName) throws DBException {
        this.typeName = typeName;
    }

    @Override
    public void setFullTypeName(String fullTypeName) throws DBException {
        String plainTypeName;
        int divPos = fullTypeName.indexOf("(");
        if (divPos == -1) {
            plainTypeName = fullTypeName;
            this.validateTypeName(plainTypeName);
        } else {
            plainTypeName = fullTypeName.substring(0, divPos);
            this.validateTypeName(plainTypeName);
            int divPos2 = fullTypeName.indexOf(41, divPos);
            if (divPos2 != -1) {
                String modifiers = fullTypeName.substring(divPos + 1, divPos2);
                int divPos3 = modifiers.indexOf(44);
                if (divPos3 == -1) {
                    this.precision = CommonUtils.toInt((Object)modifiers, (int)-1);
                    this.maxLength = this.precision;
                } else {
                    this.precision = CommonUtils.toInt((Object)modifiers.substring(0, divPos3).trim());
                    this.scale = CommonUtils.toInt((Object)modifiers.substring(divPos3 + 1).trim());
                }
            }
        }
        this.setTypeName(plainTypeName);
    }

    protected void validateTypeName(String typeName) throws DBException {
    }

    @Override
    public int getTypeID() {
        return this.valueType;
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
    }

    @Override
    @Property(viewable=true, order=40)
    public long getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setMaxLength(long maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    @Property(viewable=false, valueRenderer=DBPositiveNumberTransformer.class, order=41)
    public Integer getScale() {
        return this.scale == -1 ? null : Integer.valueOf(this.scale);
    }

    @Override
    public void setScale(Integer scale) {
        this.scale = scale == null ? -1 : scale;
    }

    @Override
    @Property(viewable=false, valueRenderer=DBPositiveNumberTransformer.class, order=42)
    public Integer getPrecision() {
        return this.precision == -1 ? null : Integer.valueOf(this.precision);
    }

    @Override
    public void setPrecision(Integer precision) {
        this.precision = precision == null ? -1 : precision;
    }

    @Override
    @Property(viewable=true, order=50)
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    @Property(viewable=true, order=55)
    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public void setAutoGenerated(boolean autoGenerated) {
        this.autoGenerated = autoGenerated;
    }

    @Override
    public long getTypeModifiers() {
        return 0L;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @Override
    public String getObjectToolTip() {
        return this.getFullTypeName();
    }

    public String toString() {
        return this.name + ", type=" + this.typeName + ", pos=" + this.ordinalPosition;
    }

    protected void onChangeDataType(DBSTypedObject oldType, DBSTypedObject newType) {
        if (oldType != null && newType != null) {
            DBPDataKind newTypeDataKind = newType.getDataKind();
            if (oldType.getDataKind() != newTypeDataKind) {
                long maxLength = newType.getMaxLength();
                this.maxLength = (newTypeDataKind == DBPDataKind.STRING || newTypeDataKind == DBPDataKind.CONTENT) && maxLength > this.maxLength ? 100L : (long)CommonUtils.toInt((Object)maxLength, (int)-1);
                this.precision = CommonUtils.toInt((Object)newType.getPrecision(), (int)-1);
                this.scale = CommonUtils.toInt((Object)newType.getScale(), (int)-1);
            }
        }
    }
}

