/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.app;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.secret.DBSSecret;
import org.jkiss.dbeaver.model.secret.DBSSecretBrowser;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBSecurityException;

public class LocalSecretController
implements DBSSecretController,
DBSSecretBrowser {
    public static final String SECRET_PREFS_ROOT = "dbeaver";
    public static final LocalSecretController INSTANCE = new LocalSecretController("");
    private final Path root;

    public LocalSecretController(String root) {
        this.root = Path.of(root, new String[0]);
    }

    @Override
    @Nullable
    public String getSecretValue(@NotNull String secretId) throws DBException {
        try {
            Path keyPath = this.root.resolve(this.escapeSecretKey(secretId));
            return LocalSecretController.getNodeByPath(keyPath.getParent()).get(keyPath.getFileName().toString(), null);
        }
        catch (StorageException e) {
            if (e.getErrorCode() == 4) {
                throw new DBSecurityException("Cannot load secure settings - master password is not provided");
            }
            throw new DBSecurityException("Error getting preference value '" + secretId + "'", e);
        }
    }

    @Override
    public void setSecretValue(@NotNull String secretId, @Nullable String secretValue) throws DBException {
        try {
            Path keyPath = this.root.resolve(this.escapeSecretKey(secretId));
            ISecurePreferences node = LocalSecretController.getNodeByPath(keyPath.getParent());
            if (secretValue != null) {
                node.put(keyPath.getFileName().toString(), secretValue, true);
            } else {
                node.remove(keyPath.getFileName().toString());
            }
        }
        catch (StorageException e) {
            if (e.getErrorCode() == 4) {
                throw new DBSecurityException("Cannot save secure settings - master password is not provided");
            }
            throw new DBSecurityException("Error setting preference value '" + secretId + "'", e);
        }
    }

    @Override
    public void flushChanges() throws DBException {
        try {
            SecurePreferencesFactory.getDefault().flush();
        }
        catch (IOException e) {
            throw new DBException("Error flushing secure preferences", e);
        }
    }

    private static ISecurePreferences getNodeByPath(Path path) {
        ISecurePreferences rootNode = SecurePreferencesFactory.getDefault().node(SECRET_PREFS_ROOT);
        if (path != null) {
            for (Path name : path) {
                rootNode = rootNode.node(name.toString());
            }
        }
        return rootNode;
    }

    @Override
    @NotNull
    public List<DBSSecret> listSecrets(@Nullable String path) throws DBException {
        Path keyPath = path == null ? this.root : this.root.resolve(this.escapeSecretKey(path));
        return Arrays.stream(LocalSecretController.getNodeByPath(keyPath).keys()).map(k -> new DBSSecret(keyPath.resolve(this.escapeSecretKey((String)k)).toString(), (String)k)).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public DBSSecret getSecret(@NotNull String secretId) throws DBException {
        String keyId;
        Path keyPath;
        block3: {
            try {
                keyPath = this.root.resolve(this.escapeSecretKey(secretId));
                keyId = keyPath.getFileName().toString();
                String value = LocalSecretController.getNodeByPath(keyPath.getParent()).get(keyId, null);
                if (value != null) break block3;
                return null;
            }
            catch (StorageException e) {
                throw new DBSecurityException("Error getting secret info '" + secretId + "'", e);
            }
        }
        return new DBSSecret(keyPath.toString(), keyId);
    }

    @Override
    public void deleteSecret(@NotNull String secretId) throws DBException {
        throw new DBCFeatureNotSupportedException();
    }

    @Override
    public void clearAllSecrets(String keyPrefix) throws DBException {
        LocalSecretController.getNodeByPath(this.root.resolve(this.escapeSecretKey(keyPrefix))).removeNode();
    }

    private String escapeSecretKey(String key) {
        return key.replace(':', '_');
    }
}

