/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs.nio;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.jkiss.dbeaver.model.fs.DBFFileStoreProvider;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFile;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFileStore;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFileSystemRoot;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOFolder;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOListener;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOMonitor;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class EFSNIOResource
extends PlatformObject
implements DBFFileStoreProvider,
IResource,
IResourceProxy {
    public static final QualifiedName NIO_RESOURCE_PROPERTY_NAME = new QualifiedName("org.jkiss.dbeaver.resources", "nioPath");
    private final EFSNIOFileSystemRoot root;
    private final java.nio.file.Path nioPath;

    protected EFSNIOResource(EFSNIOFileSystemRoot root, java.nio.file.Path nioPath) {
        this.root = root;
        this.nioPath = nioPath;
    }

    public EFSNIOFileSystemRoot getRoot() {
        return this.root;
    }

    public java.nio.file.Path getNioPath() {
        return this.nioPath;
    }

    public boolean contains(ISchedulingRule rule) {
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return false;
    }

    public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(final IResourceProxyVisitor visitor, int depth, int memberFlags) throws CoreException {
        this.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                return visitor.visit((IResourceProxy)((EFSNIOResource)resource));
            }
        }, depth, 0);
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        this.accept(visitor, depth, 0);
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        this.visit(visitor, depth);
    }

    protected boolean visit(IResourceVisitor visitor, int depth) throws CoreException {
        return visitor.visit((IResource)this);
    }

    public void clearHistory(IProgressMonitor monitor) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        block12: {
            try {
                File targetFile = destination.toFile();
                if (targetFile != null) {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (InputStream is = Files.newInputStream(this.nioPath, new OpenOption[0]);){
                        Files.copy(is, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                throw new IOException("Can't find file for location " + String.valueOf(destination));
            }
            catch (Exception e) {
                throw new CoreException(GeneralUtils.makeExceptionStatus(e));
            }
        }
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        try {
            if (!(destination instanceof IFile)) {
                throw new IOException("Can't copy to " + String.valueOf(destination));
            }
            ((IFile)destination).setContents(Files.newInputStream(this.nioPath, new OpenOption[0]), updateFlags, monitor);
        }
        catch (Exception e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus(e));
        }
    }

    public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public IMarker createMarker(String type) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public IMarker createMarker(String type, Map<String, ? extends Object> attributes) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public IResourceProxy createProxy() {
        return this;
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        this.delete(force ? 1 : 0, monitor);
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        try {
            Files.delete(this.getNioPath());
            EFSNIOMonitor.notifyResourceChange(this, EFSNIOListener.Action.DELETE);
        }
        catch (Exception e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus(e));
        }
    }

    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public int hashCode() {
        return this.nioPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EFSNIOResource)) {
            return false;
        }
        EFSNIOResource other = (EFSNIOResource)obj;
        return this.nioPath.equals(other.nioPath);
    }

    public boolean exists() {
        return Files.exists(this.nioPath, new LinkOption[0]);
    }

    public IMarker findMarker(long id) throws CoreException {
        return null;
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        return new IMarker[0];
    }

    public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) throws CoreException {
        return 0;
    }

    public String getFileExtension() {
        java.nio.file.Path fileName = this.getNioPath().getFileName();
        if (fileName == null) {
            return null;
        }
        String fileNameStr = fileName.toString();
        int divPos = fileNameStr.lastIndexOf(46);
        return divPos == -1 ? null : fileNameStr.substring(divPos + 1);
    }

    public IPath getFullPath() {
        return new Path(this.nioPath.toUri().getSchemeSpecificPart());
    }

    public long getLocalTimeStamp() {
        try {
            return Files.getLastModifiedTime(this.nioPath, new LinkOption[0]).toMillis();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public IPath getLocation() {
        return new Path(this.getLocationURI().toString());
    }

    public URI getLocationURI() {
        return URI.create(DBNNode.NodePathType.dbvfs.getPrefix() + this.root.getProject().getName() + "/" + this.root.getPrefix() + "/?" + URLEncoder.encode(this.nioPath.toUri().getPath(), StandardCharsets.UTF_8));
    }

    public IMarker getMarker(long id) {
        return null;
    }

    public long getModificationStamp() {
        return this.getLocalTimeStamp();
    }

    public String getName() {
        java.nio.file.Path fileName = this.nioPath.getFileName();
        return fileName == null ? this.nioPath.toUri().getPath() : fileName.toString();
    }

    public IPathVariableManager getPathVariableManager() {
        return this.getProject().getPathVariableManager();
    }

    public IContainer getParent() {
        java.nio.file.Path parentPath = this.nioPath.getParent();
        if (parentPath == null) {
            return this.getProject();
        }
        if (CommonUtils.equalObjects((Object)this.nioPath.toUri(), (Object)parentPath.toUri())) {
            return this.getProject();
        }
        return new EFSNIOFolder(this.root, parentPath);
    }

    public Map<QualifiedName, String> getPersistentProperties() throws CoreException {
        return Collections.emptyMap();
    }

    public String getPersistentProperty(QualifiedName key) throws CoreException {
        return null;
    }

    public IProject getProject() {
        return this.root.getProject();
    }

    public IPath getProjectRelativePath() {
        return this.getLocation().makeRelativeTo(this.getProject().getLocation());
    }

    public IPath getRawLocation() {
        return this.getLocation();
    }

    public URI getRawLocationURI() {
        return this.getLocationURI();
    }

    public ResourceAttributes getResourceAttributes() {
        return null;
    }

    public Map<QualifiedName, Object> getSessionProperties() {
        return Collections.singletonMap(NIO_RESOURCE_PROPERTY_NAME, this.nioPath);
    }

    public Object getSessionProperty(QualifiedName key) {
        if (NIO_RESOURCE_PROPERTY_NAME.equals((Object)key)) {
            return this.nioPath;
        }
        return null;
    }

    public IWorkspace getWorkspace() {
        return this.getProject().getWorkspace();
    }

    public boolean isAccessible() {
        return true;
    }

    public boolean isDerived() {
        return false;
    }

    public boolean isDerived(int options) {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isHidden(int options) {
        return false;
    }

    public boolean isLinked() {
        return false;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isLinked(int options) {
        return false;
    }

    @Deprecated
    public boolean isLocal(int depth) {
        return true;
    }

    public boolean isPhantom() {
        return false;
    }

    @Deprecated
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchronized(int depth) {
        return true;
    }

    public boolean isTeamPrivateMember() {
        return false;
    }

    public boolean isTeamPrivateMember(int options) {
        return false;
    }

    public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        this.move(destination, 1, monitor);
    }

    public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        try {
            java.nio.file.Path targetPath = destination.toPath();
            Files.move(this.nioPath, targetPath, new CopyOption[0]);
            EFSNIOMonitor.notifyResourceChange(new EFSNIOFile(this.root, targetPath), EFSNIOListener.Action.CREATE);
            EFSNIOMonitor.notifyResourceChange(this, EFSNIOListener.Action.DELETE);
        }
        catch (Exception e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus(e));
        }
    }

    public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
    }

    public void revertModificationStamp(long value) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    @Deprecated
    public void setDerived(boolean isDerived) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public void setDerived(boolean isDerived, IProgressMonitor monitor) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public void setHidden(boolean isHidden) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    @Deprecated
    public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public long setLocalTimeStamp(long value) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    @Deprecated
    public void setReadOnly(boolean readOnly) {
    }

    public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
        throw new FeatureNotSupportedException();
    }

    public IPath requestFullPath() {
        return this.getFullPath();
    }

    public IResource requestResource() {
        return this;
    }

    public String toString() {
        return this.getLocationURI().toString();
    }

    public static String getPathFileNameOrHost(java.nio.file.Path path) {
        java.nio.file.Path fileName = path.getFileName();
        if (fileName == null) {
            String uriPath;
            String virtName = null;
            URI uri = path.toUri();
            if (uri != null && !CommonUtils.isEmpty((String)(uriPath = uri.getHost()))) {
                virtName = uriPath;
            }
            if (virtName == null) {
                virtName = path.toString();
            }
            return CommonUtils.removeTrailingSlash((String)CommonUtils.removeLeadingSlash(virtName));
        }
        return fileName.toString();
    }

    public EFSNIOFileStore getFileStore() {
        return new EFSNIOFileStore(this.getLocationURI(), this.getNioPath());
    }

    public static class FeatureNotSupportedException
    extends CoreException {
        private static final long serialVersionUID = 1L;

        public FeatureNotSupportedException() {
            super(Status.info((String)"Feature not supported"));
        }
    }
}

