/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.connection.DBPDriverFileSource;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocationManager;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialectMetadata;
import org.jkiss.utils.Pair;

public interface DBPDriver
extends DBPNamedObject {
    @NotNull
    public DBPDataSourceProvider getDataSourceProvider();

    @NotNull
    public DBPDataSourceProviderDescriptor getProviderDescriptor();

    @NotNull
    public String getId();

    @NotNull
    public String getProviderId();

    @Deprecated
    @Nullable
    public String getCategory();

    @NotNull
    public List<String> getCategories();

    @NotNull
    public String getFullName();

    @Nullable
    public String getDescription();

    @NotNull
    public DBPImage getIcon();

    @NotNull
    public DBPImage getPlainIcon();

    @NotNull
    public DBPImage getIconBig();

    @Nullable
    public DBPImage getLogoImage();

    @Nullable
    public String getDriverClassName();

    @Nullable
    public String getDefaultHost();

    @Nullable
    public String getDefaultPort();

    @Nullable
    public String getDefaultDatabase();

    @Nullable
    public String getDefaultServer();

    @Nullable
    public String getDefaultUser();

    @Nullable
    public String getSampleURL();

    @Nullable
    public String getWebURL();

    @Nullable
    public String getPropertiesWebURL();

    @NotNull
    public SQLDialectMetadata getScriptDialect();

    public boolean isClientRequired();

    public boolean supportsDriverProperties();

    public boolean isEmbedded();

    public boolean isPropagateDriverProperties();

    public boolean isAnonymousAccess();

    public boolean isAllowsEmptyPassword();

    public boolean isLicenseRequired();

    public boolean isCustomDriverLoader();

    public boolean isSampleURLApplicable();

    public boolean isCustomEndpointInformation();

    public boolean isSingleConnection();

    public boolean isInstantiable();

    public boolean isInternalDriver();

    public boolean isCustom();

    public boolean isTemporary();

    public boolean isDisabled();

    public DBPDriver getReplacedBy();

    public boolean isDeprecated();

    @NotNull
    public String getDeprecationReason();

    public List<Pair<String, String>> getDriverReplacementsInfo();

    public int getPromotedScore();

    @Nullable
    public DBXTreeNode getNavigatorRoot();

    @NotNull
    public DBPPropertyDescriptor[] getProviderPropertyDescriptors();

    @NotNull
    public Map<String, Object> getDefaultConnectionProperties();

    @NotNull
    public Map<String, Object> getConnectionProperties();

    @NotNull
    public Map<String, Object> getDriverParameters();

    @Nullable
    public Object getDriverParameter(String var1);

    public boolean isSupportedByLocalSystem();

    public String getLicense();

    @Nullable
    public DBPNativeClientLocationManager getNativeClientManager();

    @NotNull
    public List<DBPNativeClientLocation> getNativeClientLocations();

    @Nullable
    public ClassLoader getClassLoader();

    @NotNull
    public List<? extends DBPDriverLibrary> getDriverLibraries();

    public List<? extends DBPDriverFileSource> getDriverFileSources();

    public boolean needsExternalDependencies();

    @NotNull
    public <T> T getDriverInstance(@NotNull DBRProgressMonitor var1) throws DBException;

    public void loadDriver(DBRProgressMonitor var1) throws DBException;

    public String getConnectionURL(DBPConnectionConfiguration var1);

    public DBPDriver createOriginalCopy();

    public Set<DBPDriverConfigurationType> getSupportedConfigurationTypes();

    @NotNull
    public Set<String> getSupportedPageFields();

    default public String getFullId() {
        return this.getProviderId() + ":" + this.getId();
    }

    default public String getPreconfiguredId() {
        return this.isCustom() ? this.getProviderId() + ":custom-driver" : this.getFullId();
    }
}

