/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class DatabaseURL {
    private static final Log log = Log.getLog(DatabaseURL.class);
    private static final char URL_GROUP_START = '{';
    private static final char URL_GROUP_END = '}';
    private static final char URL_OPTIONAL_START = '[';
    private static final char URL_OPTIONAL_END = ']';

    public static String generateUrlByTemplate(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String urlTemplate = driver.getSampleURL();
        return DatabaseURL.generateUrlByTemplate(urlTemplate, connectionInfo);
    }

    public static String generateUrlByTemplate(String urlTemplate, DBPConnectionConfiguration connectionInfo) {
        if (!CommonUtils.isEmpty((String)connectionInfo.getUrl()) && CommonUtils.isEmpty((String)connectionInfo.getHostPort()) && CommonUtils.isEmpty((String)connectionInfo.getHostName()) && CommonUtils.isEmpty((String)connectionInfo.getServerName()) && CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            return connectionInfo.getUrl();
        }
        try {
            if (CommonUtils.isEmptyTrimmed((String)urlTemplate)) {
                return connectionInfo.getUrl();
            }
            MetaURL metaURL = DatabaseURL.parseSampleURL(urlTemplate);
            StringBuilder url = new StringBuilder();
            Iterator<String> iterator = metaURL.getUrlComponents().iterator();
            while (iterator.hasNext()) {
                String component;
                String newComponent = component = iterator.next();
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostName())) {
                    newComponent = newComponent.replace(DatabaseURL.makePropPattern("host"), connectionInfo.getHostName());
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getHostPort())) {
                    newComponent = newComponent.replace(DatabaseURL.makePropPattern("port"), connectionInfo.getHostPort());
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getServerName())) {
                    newComponent = newComponent.replace(DatabaseURL.makePropPattern("server"), connectionInfo.getServerName());
                }
                if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
                    newComponent = newComponent.replace(DatabaseURL.makePropPattern("database"), connectionInfo.getDatabaseName());
                    newComponent = newComponent.replace(DatabaseURL.makePropPattern("folder"), connectionInfo.getDatabaseName());
                    newComponent = newComponent.replace(DatabaseURL.makePropPattern("file"), connectionInfo.getDatabaseName());
                }
                if ((newComponent = newComponent.replace(DatabaseURL.makePropPattern("user"), CommonUtils.notEmpty((String)connectionInfo.getUserName()))).startsWith("[")) {
                    if (newComponent.equals(component)) continue;
                    url.append(newComponent.substring(1, newComponent.length() - 1));
                    continue;
                }
                url.append(newComponent);
            }
            return url.toString();
        }
        catch (DBException e) {
            log.error(e);
            return null;
        }
    }

    private static String makePropPattern(String prop) {
        return "{" + prop + "}";
    }

    public static MetaURL parseSampleURL(String sampleURL) throws DBException {
        int divPos;
        MetaURL metaURL = new MetaURL();
        int offsetPos = 0;
        while ((divPos = sampleURL.indexOf(123, offsetPos)) != -1) {
            int divPos2 = sampleURL.indexOf(125, divPos);
            if (divPos2 == -1) {
                throw new DBException("Bad sample URL: " + sampleURL);
            }
            String propName = sampleURL.substring(divPos + 1, divPos2);
            boolean isOptional = false;
            int optDiv1 = sampleURL.lastIndexOf(91, divPos);
            int optDiv1c = sampleURL.lastIndexOf(93, divPos);
            int optDiv2 = sampleURL.indexOf(93, divPos2);
            int optDiv2c = sampleURL.indexOf(91, divPos2);
            if (!(optDiv1 == -1 || optDiv2 == -1 || optDiv1c != -1 && optDiv1c >= optDiv1 || optDiv2c != -1 && optDiv2c <= optDiv2)) {
                divPos = optDiv1;
                divPos2 = optDiv2;
                isOptional = true;
            }
            if (divPos > offsetPos) {
                metaURL.urlComponents.add(sampleURL.substring(offsetPos, divPos));
            }
            metaURL.urlComponents.add(sampleURL.substring(divPos, divPos2 + 1));
            metaURL.availableProperties.add(propName);
            if (!isOptional) {
                metaURL.requiredProperties.add(propName);
            }
            offsetPos = divPos2 + 1;
        }
        if (offsetPos < sampleURL.length()) {
            metaURL.urlComponents.add(sampleURL.substring(offsetPos));
        }
        return metaURL;
    }

    @NotNull
    public static Pattern getPattern(@NotNull String sampleUrl) {
        Object pattern = sampleUrl;
        pattern = CommonUtils.replaceAll((String)pattern, (String)"\\[(.*?)]", m -> "\\\\E(?:\\\\Q" + m.group(1) + "\\\\E)?\\\\Q");
        pattern = CommonUtils.replaceAll((String)pattern, (String)"\\{(.*?)}", m -> "\\\\E(\\?<\\\\Q" + m.group(1) + "\\\\E>" + DatabaseURL.getPropertyRegex(m.group(1)) + ")\\\\Q");
        pattern = "^\\Q" + (String)pattern + "\\E$";
        return Pattern.compile((String)pattern);
    }

    @Nullable
    public static DBPConnectionConfiguration extractConfigurationFromUrl(@NotNull String sampleUrl, @NotNull String targetUrl) {
        Matcher matcher = DatabaseURL.getPattern(sampleUrl).matcher(targetUrl);
        if (!matcher.find()) {
            return null;
        }
        Map<String, String> properties = DatabaseURL.getProperties(sampleUrl).stream().map(x -> new Pair(x, (Object)matcher.group((String)x))).filter(x -> CommonUtils.isNotEmpty((String)((String)x.getSecond()))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
        if (properties.isEmpty()) {
            return null;
        }
        DBPConnectionConfiguration configuration = new DBPConnectionConfiguration();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            switch (entry.getKey()) {
                case "host": {
                    configuration.setHostName(entry.getValue());
                    break;
                }
                case "port": {
                    configuration.setHostPort(entry.getValue());
                    break;
                }
                case "folder": 
                case "file": 
                case "database": {
                    configuration.setDatabaseName(entry.getValue());
                    break;
                }
                case "server": {
                    configuration.setServerName(entry.getValue());
                    break;
                }
                case "user": {
                    configuration.setUserName(entry.getValue());
                    break;
                }
                case "password": {
                    configuration.setUserPassword(entry.getValue());
                    break;
                }
                default: {
                    log.debug("Unknown property: " + entry.getKey());
                }
            }
        }
        return configuration;
    }

    @NotNull
    private static String getPropertyRegex(@NotNull String property) {
        switch (property) {
            case "folder": 
            case "file": {
                return ".+?";
            }
        }
        return "[\\\\w\\\\-_.~]+";
    }

    @NotNull
    private static List<String> getProperties(@NotNull String sampleUrl) {
        Matcher matcher = Pattern.compile("\\{(.*?)}").matcher(sampleUrl);
        ArrayList<String> properties = new ArrayList<String>();
        while (matcher.find()) {
            properties.add(matcher.group(1));
        }
        return properties;
    }

    public static class MetaURL {
        private List<String> urlComponents = new ArrayList<String>();
        private Set<String> availableProperties = new HashSet<String>();
        private Set<String> requiredProperties = new HashSet<String>();

        public List<String> getUrlComponents() {
            return this.urlComponents;
        }

        public Set<String> getAvailableProperties() {
            return this.availableProperties;
        }

        public Set<String> getRequiredProperties() {
            return this.requiredProperties;
        }
    }
}

