/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverSubstitutionDescriptor;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceViewDescriptor;
import org.jkiss.dbeaver.registry.DataSourceViewRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.ui.ICompositeDialogPageContainer;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageNetworkHandler;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

class ConnectionPageSettings
extends ActiveWizardPage<ConnectionWizard>
implements IDataSourceConnectionEditorSite,
IDialogPageProvider,
ICompositeDialogPageContainer,
IDataSourceConnectionTester {
    private static final Log log = Log.getLog(DriverDescriptor.class);
    public static final String PAGE_NAME = ConnectionPageSettings.class.getSimpleName();
    private static final Comparator<IDialogPage> PAGE_COMPARATOR = Comparator.comparing(page -> page instanceof ConnectionPageNetworkHandler).thenComparing(page -> !ConnectionPageSettings.isPagePinned(page));
    @NotNull
    private final ConnectionWizard wizard;
    @NotNull
    private final DataSourceViewDescriptor viewDescriptor;
    private final DataSourceViewDescriptor substitutedViewDescriptor;
    private final DBPDriverSubstitutionDescriptor driverSubstitution;
    @Nullable
    private IDataSourceConnectionEditor connectionEditor;
    private IDataSourceConnectionEditor originalConnectionEditor;
    @Nullable
    private final DataSourceDescriptor dataSource;
    private final Set<DataSourceDescriptor> activated = new HashSet<DataSourceDescriptor>();
    private IDialogPage[] subPages;
    private IDialogPage[] extraPages;
    private CTabFolder tabFolder;

    ConnectionPageSettings(@NotNull ConnectionWizard wizard, @NotNull DataSourceViewDescriptor viewDescriptor, @Nullable DataSourceDescriptor dataSource, @Nullable DBPDriverSubstitutionDescriptor driverSubstitution) {
        super(PAGE_NAME + "." + viewDescriptor.getId());
        this.wizard = wizard;
        this.viewDescriptor = viewDescriptor;
        this.dataSource = dataSource;
        this.driverSubstitution = driverSubstitution;
        this.substitutedViewDescriptor = driverSubstitution != null ? DataSourceViewRegistry.getInstance().findView((DBPDataSourceProviderDescriptor)DataSourceProviderRegistry.getInstance().getDataSourceProvider(driverSubstitution.getProviderId()), "org.jkiss.dbeaver.ext.ui.editConnectionDialog") : null;
        this.setTitle(wizard.isNew() ? viewDescriptor.getLabel() : CoreMessages.dialog_setting_connection_wizard_title);
        this.setDescription(CoreMessages.dialog_connection_description);
    }

    @NotNull
    private IDataSourceConnectionEditor getConnectionEditor() {
        if (this.connectionEditor == null) {
            if (this.substitutedViewDescriptor == null) {
                this.connectionEditor = this.getOriginalConnectionEditor();
            } else {
                this.connectionEditor = (IDataSourceConnectionEditor)this.substitutedViewDescriptor.createView(IDataSourceConnectionEditor.class);
                this.connectionEditor.setSite((IDataSourceConnectionEditorSite)this);
            }
        }
        return this.connectionEditor;
    }

    @NotNull
    private IDataSourceConnectionEditor getOriginalConnectionEditor() {
        if (this.originalConnectionEditor == null) {
            this.originalConnectionEditor = (IDataSourceConnectionEditor)this.viewDescriptor.createView(IDataSourceConnectionEditor.class);
            this.originalConnectionEditor.setSite((IDataSourceConnectionEditorSite)this);
        }
        return this.originalConnectionEditor;
    }

    public void activatePage() {
        if (this.connectionEditor == null) {
            this.createProviderPage(this.getControl().getParent());
        }
        Control control = this.getControl();
        control.setRedraw(false);
        try {
            this.setDescription(NLS.bind((String)CoreMessages.dialog_connection_message, (Object)this.getDriver().getFullName()));
            DataSourceDescriptor connectionInfo = this.getActiveDataSource();
            if (!this.activated.contains(connectionInfo)) {
                if (this.connectionEditor != null) {
                    this.connectionEditor.loadSettings();
                }
                if (this.subPages != null) {
                    IDialogPage[] iDialogPageArray = this.subPages;
                    int n = this.subPages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDialogPage page = iDialogPageArray[n2];
                        Control pageControl = page.getControl();
                        if (pageControl != null && page instanceof IDataSourceConnectionEditor) {
                            ((IDataSourceConnectionEditor)page).loadSettings();
                        }
                        ++n2;
                    }
                }
                this.activated.add(connectionInfo);
            } else if (this.connectionEditor != null) {
                this.connectionEditor.loadSettings();
            }
            this.activateCurrentItem();
        }
        finally {
            control.setRedraw(true);
        }
    }

    public void deactivatePage() {
        DataSourceDescriptor connectionInfo = this.getActiveDataSource();
        if (this.activated.contains(connectionInfo) && this.connectionEditor != null) {
            this.connectionEditor.saveSettings((DBPDataSourceContainer)connectionInfo);
        }
        super.deactivatePage();
    }

    public Image getImage() {
        Image image;
        if (this.connectionEditor != null && (image = this.connectionEditor.getImage()) != null) {
            return image;
        }
        return super.getImage();
    }

    void saveSettings(DataSourceDescriptor dataSource) {
        if (this.subPages != null) {
            IDialogPage[] iDialogPageArray = this.subPages;
            int n = this.subPages.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogPage page = iDialogPageArray[n2];
                if (!ArrayUtils.contains((Object[])this.extraPages, (Object)page)) {
                    if (page.getControl() != null && page instanceof IDataSourceConnectionEditor) {
                        ((IDataSourceConnectionEditor)page).saveSettings((DBPDataSourceContainer)dataSource);
                    } else if (page instanceof ConnectionWizardPage) {
                        ((ConnectionWizardPage)page).saveSettings((DBPDataSourceContainer)dataSource);
                    }
                }
                ++n2;
            }
        }
        if (this.connectionEditor != null) {
            this.connectionEditor.saveSettings((DBPDataSourceContainer)dataSource);
        }
    }

    public void createControl(Composite parent) {
        if (this.wizard.isNew()) {
            this.setControl((Control)new Composite(parent, 2048));
        } else {
            this.createProviderPage(parent);
        }
    }

    private void createProviderPage(Composite parent) {
        if (this.connectionEditor != null && this.connectionEditor.getControl() != null) {
            return;
        }
        if (this.getControl() != null) {
            this.getControl().dispose();
        }
        try {
            this.getConnectionEditor();
            Object[] allSubPages = this.getDialogPages(false, true);
            final ArrayList<IDialogPage> allPages = new ArrayList<IDialogPage>();
            allPages.add((IDialogPage)this.connectionEditor);
            if (!ArrayUtils.isEmpty((Object[])allSubPages)) {
                Collections.addAll(allPages, allSubPages);
            }
            allPages.sort(PAGE_COMPARATOR);
            this.tabFolder = new CTabFolder(parent, 128);
            this.tabFolder.setLayoutData((Object)new GridData(1808));
            this.tabFolder.setUnselectedCloseVisible(false);
            final ToolBar tabFolderChevron = this.createChevron(allPages);
            this.tabFolder.setTopRight((Control)tabFolderChevron, 131072);
            this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void close(CTabFolderEvent event) {
                    if (ConnectionPageSettings.this.confirmTabClose((CTabItem)event.item)) {
                        ConnectionPageNetworkHandler page = (ConnectionPageNetworkHandler)((Object)event.item.getData());
                        NetworkHandlerDescriptor descriptor = page.getHandlerDescriptor();
                        DBPConnectionConfiguration configuration = ConnectionPageSettings.this.getActiveDataSource().getConnectionConfiguration();
                        DBWHandlerConfiguration handler = configuration.getHandler(descriptor.getId());
                        if (handler != null) {
                            handler.setEnabled(false);
                        }
                    } else {
                        event.doit = false;
                    }
                }

                public void itemsCount(CTabFolderEvent event) {
                    tabFolderChevron.setVisible(ConnectionPageSettings.this.canShowChevron(allPages));
                }
            });
            this.tabFolder.addKeyListener(KeyListener.keyPressedAdapter(event -> {
                CTabFolder folder;
                CTabItem selection;
                if (event.keyCode == 127 && event.stateMask == 0 && (selection = (folder = (CTabFolder)event.widget).getSelection()) != null && selection.getShowClose() && this.confirmTabClose(selection)) {
                    selection.dispose();
                }
            }));
            this.setControl((Control)this.tabFolder);
            for (IDialogPage page : allPages) {
                if (ArrayUtils.contains((Object[])this.extraPages, (Object)page) || this.canShowInChevron(page)) continue;
                this.createPageTab(page, this.tabFolder.getItemCount());
            }
            this.tabFolder.setSelection(0);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageSettings.this.activateCurrentItem();
                }
            });
            this.activateCurrentItem();
            Dialog.applyDialogFont((Control)this.tabFolder);
            UIUtils.setHelp((Control)this.getControl(), (String)"con-wizard-settings");
        }
        catch (Exception ex) {
            log.warn((Object)ex);
            this.setErrorMessage("Can't create settings dialog: " + ex.getMessage());
        }
        parent.layout();
    }

    @NotNull
    private ToolBar createChevron(@NotNull List<IDialogPage> pages) {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(m -> {
            int i = 0;
            while (i < pages.size()) {
                IDialogPage page = (IDialogPage)pages.get(i);
                if (this.canShowInChevron(page)) {
                    manager.add((IAction)new AddNetworkHandlerAction((DBPDataSourceContainer)this.getActiveDataSource(), (ConnectionPageNetworkHandler)page, i));
                }
                ++i;
            }
        });
        ToolBar toolBar = new ToolBar((Composite)this.tabFolder, 0x820000);
        ToolItem toolItem = UIUtils.createToolItem((ToolBar)toolBar, (String)CoreMessages.dialog_connection_network_add_tunnel_label, null, (DBPImage)UIIcon.ADD, null);
        toolItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Rectangle bounds = toolItem.getBounds();
            Point location = toolBar.getDisplay().map((Control)toolBar, null, 0, bounds.height);
            Menu menu = manager.createContextMenu((Control)this.tabFolder);
            menu.setLocation(location.x, location.y);
            menu.setVisible(true);
        }));
        toolItem.addDisposeListener(e -> manager.dispose());
        return toolBar;
    }

    private boolean confirmTabClose(@NotNull CTabItem item) {
        if (item.getData() instanceof ConnectionPageNetworkHandler) {
            ConnectionPageNetworkHandler page = (ConnectionPageNetworkHandler)((Object)item.getData());
            NetworkHandlerDescriptor descriptor = page.getHandlerDescriptor();
            int decision = ConfirmationDialog.confirmAction((Shell)this.getShell(), (int)2, (String)"disable_network_handler", (int)5, (Object[])new Object[]{descriptor.getCodeName()});
            return decision == 0;
        }
        return false;
    }

    private boolean canShowChevron(@NotNull List<IDialogPage> pages) {
        for (IDialogPage page : pages) {
            if (!this.canShowInChevron(page)) continue;
            return true;
        }
        return false;
    }

    private boolean canShowInChevron(@NotNull IDialogPage page) {
        if (ConnectionPageSettings.isPagePinned(page) || !(page instanceof ConnectionPageNetworkHandler)) {
            return false;
        }
        NetworkHandlerDescriptor descriptor = ((ConnectionPageNetworkHandler)page).getHandlerDescriptor();
        DBPConnectionConfiguration configuration = this.getActiveDataSource().getConnectionConfiguration();
        DBWHandlerConfiguration handler = configuration.getHandler(descriptor.getId());
        return handler == null || !handler.isEnabled();
    }

    private static boolean isPagePinned(@NotNull IDialogPage page) {
        if (page instanceof ConnectionPageNetworkHandler) {
            return ((ConnectionPageNetworkHandler)page).getHandlerDescriptor().isPinned();
        }
        return true;
    }

    @NotNull
    private CTabItem createPageTab(@NotNull IDialogPage page, int index) {
        CTabItem item = new CTabItem(this.tabFolder, ConnectionPageSettings.isPagePinned(page) ? 0 : 64, index);
        item.setData((Object)page);
        item.setText(CommonUtils.isEmpty((String)page.getTitle()) ? CoreMessages.dialog_setting_connection_general : page.getTitle());
        item.setToolTipText(page.getDescription());
        if (page.getControl() == null) {
            Composite placeholder = new Composite((Composite)this.tabFolder, 0);
            placeholder.setLayout((Layout)new FillLayout());
            item.setControl((Control)placeholder);
        } else {
            Control control = page.getControl();
            control.setParent((Composite)this.tabFolder);
            item.setControl(control);
        }
        return item;
    }

    private void activateCurrentItem() {
        CTabItem selection;
        if (this.tabFolder != null && (selection = this.tabFolder.getSelection()) != null) {
            IDialogPage page = (IDialogPage)selection.getData();
            if (page.getControl() == null) {
                Composite panel = (Composite)selection.getControl();
                panel.setRedraw(false);
                try {
                    page.createControl(panel);
                    Dialog.applyDialogFont((Control)panel);
                    panel.layout(true, true);
                }
                finally {
                    panel.setRedraw(true);
                }
            }
            page.setVisible(true);
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        return this.wizard.getPageSettings() != this || this.connectionEditor != null && this.connectionEditor.isComplete();
    }

    public DBRRunnableContext getRunnableContext() {
        return this.wizard.getRunnableContext();
    }

    public DBPDataSourceRegistry getDataSourceRegistry() {
        return this.wizard.getDataSourceRegistry();
    }

    public boolean isNew() {
        return this.wizard.isNew();
    }

    public DBPDriver getDriver() {
        return this.wizard.getSelectedDriver();
    }

    @NotNull
    public DataSourceDescriptor getActiveDataSource() {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        return this.wizard.getActiveDataSource();
    }

    public void updateButtons() {
        ((ConnectionWizard)this.getWizard()).getContainer().updateButtons();
    }

    public boolean openDriverEditor() {
        DriverEditDialog dialog = new DriverEditDialog(this.wizard.getShell(), (DBPDriver)((DriverDescriptor)this.getDriver()));
        return dialog.open() == 0;
    }

    public boolean openSettingsPage(String pageId) {
        return this.wizard.openSettingsPage(pageId);
    }

    public void testConnection() {
        ((ConnectionWizard)this.getWizard()).testConnection();
    }

    public DBPProject getProject() {
        DBPDataSourceRegistry registry = this.wizard.getDataSourceRegistry();
        return registry == null ? null : registry.getProject();
    }

    public void firePropertyChange(Object source, String property, Object oldValue, Object newValue) {
        PropertyChangeEvent pcEvent = new PropertyChangeEvent(source, property, oldValue, newValue);
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            IDialogPage page = (IDialogPage)item.getData();
            if (page instanceof IPropertyChangeListener && page.getControl() != null) {
                ((IPropertyChangeListener)page).propertyChange(pcEvent);
            }
            ++n2;
        }
        cTabItemArray = ((ConnectionWizard)this.getWizard()).getPages();
        n = cTabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            CTabItem page = cTabItemArray[n2];
            if (page instanceof IPropertyChangeListener && page.getControl() != null) {
                ((IPropertyChangeListener)page).propertyChange(pcEvent);
            }
            ++n2;
        }
    }

    public void dispose() {
        if (this.connectionEditor != null) {
            this.connectionEditor.dispose();
            this.connectionEditor = null;
        }
        super.dispose();
    }

    @Nullable
    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        if (extrasOnly) {
            return this.extraPages;
        }
        if (this.subPages != null) {
            return this.subPages;
        }
        if (!forceCreate) {
            return new IDialogPage[0];
        }
        IDataSourceConnectionEditor originalConnectionEditor = this.getOriginalConnectionEditor();
        if (originalConnectionEditor instanceof IDialogPageProvider) {
            this.subPages = ((IDialogPageProvider)originalConnectionEditor).getDialogPages(extrasOnly, true);
            if (!this.getDriver().isEmbedded() && !CommonUtils.toBoolean((Object)this.getDriver().getDriverParameter("disableNetworkParameters"))) {
                for (NetworkHandlerDescriptor descriptor : NetworkHandlerRegistry.getInstance().getDescriptors((DBPDataSourceContainer)this.getActiveDataSource())) {
                    if (this.driverSubstitution != null && !this.driverSubstitution.getInstance().isNetworkHandlerSupported((DBWHandlerDescriptor)descriptor)) continue;
                    this.subPages = (IDialogPage[])ArrayUtils.add(IDialogPage.class, (Object[])this.subPages, (Object)((Object)new ConnectionPageNetworkHandler(this, descriptor)));
                }
            }
            if (this.extraPages != null) {
                this.subPages = (IDialogPage[])ArrayUtils.concatArrays((Object[])this.subPages, (Object[])this.extraPages);
            }
            try {
                IDialogPage[] dialogPages;
                IDialogPageProvider externalPagesProvider = (IDialogPageProvider)GeneralUtils.adapt((Object)this.getActiveDataSource(), IDialogPageProvider.class);
                if (externalPagesProvider != null && (dialogPages = externalPagesProvider.getDialogPages(false, true)) != null) {
                    IDialogPage[] iDialogPageArray = dialogPages;
                    int n = dialogPages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDialogPage page = iDialogPageArray[n2];
                        if (page != null) {
                            this.subPages = (IDialogPage[])ArrayUtils.add(IDialogPage.class, (Object[])this.subPages, (Object)page);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            if (!ArrayUtils.isEmpty((Object[])this.subPages)) {
                IDialogPage[] iDialogPageArray = this.subPages;
                int n = this.subPages.length;
                int n3 = 0;
                while (n3 < n) {
                    IDialogPage page = iDialogPageArray[n3];
                    if (page instanceof IDataSourceConnectionEditor) {
                        ((IDataSourceConnectionEditor)page).setSite((IDataSourceConnectionEditorSite)this);
                    }
                    ++n3;
                }
            }
            return this.subPages;
        }
        return this.extraPages;
    }

    public void addSubPage(IDialogPage page) {
        this.extraPages = this.extraPages == null ? new IDialogPage[]{page} : (IDialogPage[])ArrayUtils.concatArrays((Object[])this.extraPages, (Object[])new IDialogPage[]{page});
        if (page instanceof IWizardPage) {
            ((IWizardPage)page).setWizard(this.getWizard());
        }
    }

    public void testConnection(DBCSession session) {
        if (this.connectionEditor instanceof IDataSourceConnectionTester) {
            ((IDataSourceConnectionTester)this.connectionEditor).testConnection(session);
        }
    }

    public String toString() {
        return this.getName();
    }

    public void showSubPage(IDialogPage subPage) {
        CTabItem selection = this.tabFolder.getSelection();
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem pageTab = cTabItemArray[n2];
            if (pageTab.getData() == subPage) {
                this.tabFolder.setSelection(pageTab);
                this.activateCurrentItem();
                if (selection != null && selection.getData() != subPage && selection.getData() instanceof ActiveWizardPage) {
                    ((ActiveWizardPage)selection.getData()).deactivatePage();
                }
                if (!(subPage instanceof ActiveWizardPage)) break;
                ((ActiveWizardPage)subPage).activatePage();
                break;
            }
            ++n2;
        }
    }

    private class AddNetworkHandlerAction
    extends Action {
        private final DBPDataSourceContainer container;
        private final ConnectionPageNetworkHandler page;
        private final int index;

        public AddNetworkHandlerAction(@NotNull DBPDataSourceContainer container, ConnectionPageNetworkHandler page, int index) {
            super(page.getHandlerDescriptor().getCodeName(), 1);
            this.container = container;
            this.page = page;
            this.index = index;
        }

        public void run() {
            NetworkHandlerDescriptor descriptor = this.page.getHandlerDescriptor();
            DBPConnectionConfiguration configuration = this.container.getConnectionConfiguration();
            DBWHandlerConfiguration handler = configuration.getHandler(descriptor.getId());
            if (handler == null) {
                handler = new DBWHandlerConfiguration((DBWHandlerDescriptor)descriptor, this.container);
                configuration.updateHandler(handler);
            }
            handler.setEnabled(true);
            ConnectionPageSettings.this.tabFolder.setSelection(ConnectionPageSettings.this.createPageTab((IDialogPage)this.page, Math.min(ConnectionPageSettings.this.tabFolder.getItemCount(), this.index)));
            ConnectionPageSettings.this.activateCurrentItem();
        }
    }
}

