/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.PlatformUI;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.app.DBACertificateStorage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPApplicationController;
import org.jkiss.dbeaver.model.app.DBPDataFormatterRegistry;
import org.jkiss.dbeaver.model.app.DBPGlobalEventManager;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguage;
import org.jkiss.dbeaver.model.app.DBPPlatformLanguageManager;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.impl.app.DefaultCertificateStorage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMMetaListener;
import org.jkiss.dbeaver.model.qm.QMRegistry;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.registry.BaseApplicationImpl;
import org.jkiss.dbeaver.registry.BasePlatformImpl;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DesktopWorkspaceImpl;
import org.jkiss.dbeaver.registry.GlobalEventManagerImpl;
import org.jkiss.dbeaver.registry.formatter.DataFormatterRegistry;
import org.jkiss.dbeaver.registry.language.PlatformLanguageRegistry;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.runtime.SecurityProviderUtils;
import org.jkiss.dbeaver.runtime.qm.QMLogFileWriter;
import org.jkiss.dbeaver.runtime.qm.QMRegistryImpl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.CommonUtils;

public class DesktopPlatform
extends BasePlatformImpl
implements DBPPlatformDesktop,
DBPPlatformLanguageManager {
    public static final String PLUGIN_ID = "org.jkiss.dbeaver.core";
    private static final String TEMP_PROJECT_NAME = ".dbeaver-temp";
    private static final String OSGI_CONFIG_FILE = "config.ini";
    private static final Log log = Log.getLog(DesktopPlatform.class);
    static DesktopPlatform instance;
    private static volatile boolean isClosing;
    private Path tempFolder;
    private DesktopWorkspaceImpl workspace;
    private QMRegistryImpl queryManager;
    private QMLogFileWriter qmLogWriter;
    private DBACertificateStorage certificateStorage;
    private DBPPlatformLanguage language;

    static {
        isClosing = false;
    }

    public static boolean isStandalone() {
        return BaseApplicationImpl.getInstance().isStandalone();
    }

    public static boolean isClosing() {
        if (isClosing) {
            return true;
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return false;
        }
        return false;
    }

    static void setClosing(boolean closing) {
        isClosing = closing;
    }

    public static DBPPreferenceStore getGlobalPreferenceStore() {
        return DBeaverActivator.getInstance().getPreferences();
    }

    public DesktopPlatform() {
        instance = this;
    }

    protected void initialize() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Initialize desktop platform...");
        this.language = PlatformLanguageRegistry.getInstance().getLanguage(Locale.getDefault());
        if (this.language == null) {
            log.debug((Object)("Language for locale '" + String.valueOf(Locale.getDefault()) + "' not found. Use default."));
            this.language = PlatformLanguageRegistry.getInstance().getLanguage(Locale.ENGLISH);
        }
        if (this.getPreferenceStore().getBoolean("security.jce.bc")) {
            SecurityProviderUtils.registerSecurityProvider();
        }
        this.certificateStorage = new DefaultCertificateStorage(DBeaverActivator.getInstance().getStateLocation().toFile().toPath().resolve("security"));
        this.getApplication().beforeWorkspaceInitialization();
        this.workspace = (DesktopWorkspaceImpl)this.getApplication().createWorkspace((DBPPlatform)this, ResourcesPlugin.getWorkspace());
        this.workspace.initializeProjects();
        QMUtils.initApplication((DBPPlatform)this);
        this.queryManager = new QMRegistryImpl();
        this.qmLogWriter = new QMLogFileWriter();
        this.queryManager.registerMetaListener((QMMetaListener)this.qmLogWriter);
        super.initialize();
        log.debug((Object)("Platform initialized (" + (System.currentTimeMillis() - startTime) + "ms)"));
    }

    public synchronized void dispose() {
        long startTime = System.currentTimeMillis();
        log.debug((Object)"Shutdown desktop platform...");
        DesktopPlatform.setClosing(true);
        DBPApplication application = this.getApplication();
        if (application instanceof DBPApplicationController) {
            ((DBPApplicationController)application).setHeadlessMode(true);
        }
        super.dispose();
        if (this.workspace != null) {
            this.workspace.dispose();
            this.workspace = null;
        }
        if (this.qmLogWriter != null) {
            this.queryManager.unregisterMetaListener((QMMetaListener)this.qmLogWriter);
            this.qmLogWriter.dispose();
            this.qmLogWriter = null;
        }
        if (this.queryManager != null) {
            this.queryManager.dispose();
        }
        DataSourceProviderRegistry.dispose();
        if (DesktopPlatform.isStandalone() && this.workspace != null && !application.isExclusiveMode()) {
            try {
                this.workspace.save((DBRProgressMonitor)new LoggingProgressMonitor(log));
            }
            catch (DBException ex) {
                log.error((Object)"Can not save workspace", (Throwable)ex);
            }
        }
        if (this.tempFolder != null) {
            if (!ContentUtils.deleteFileRecursive((Path)this.tempFolder)) {
                log.warn((Object)("Can not delete temp folder '" + String.valueOf(this.tempFolder) + "'"));
            }
            this.tempFolder = null;
        }
        instance = null;
        System.gc();
        log.debug((Object)("Platform shutdown completed (" + (System.currentTimeMillis() - startTime) + "ms)"));
        new Thread(() -> {
            RuntimeUtils.pause((int)10000);
            System.out.println("App shutdown was halted. Force system shutdown!");
            System.exit(-2);
        }).start();
    }

    protected Plugin getProductPlugin() {
        return DBeaverActivator.getInstance();
    }

    @NotNull
    public DBPWorkspaceDesktop getWorkspace() {
        return this.workspace;
    }

    @NotNull
    public DBPApplication getApplication() {
        return BaseApplicationImpl.getInstance();
    }

    @NotNull
    public DBPPlatformLanguage getLanguage() {
        return this.language;
    }

    public void setPlatformLanguage(@NotNull DBPPlatformLanguage language) throws DBException {
        if (CommonUtils.equalObjects((Object)language, (Object)this.language)) {
            return;
        }
        try {
            Object var5_8;
            Throwable throwable;
            File config = new File(RuntimeUtils.getLocalFileFromURL((URL)Platform.getConfigurationLocation().getURL()), OSGI_CONFIG_FILE);
            Properties properties = new Properties();
            if (config.exists()) {
                throwable = null;
                var5_8 = null;
                try (FileInputStream is = new FileInputStream(config);){
                    properties.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            properties.put("osgi.nl", language.getCode());
            throwable = null;
            var5_8 = null;
            try (FileOutputStream os = new FileOutputStream(config);){
                properties.store(os, null);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            this.language = language;
            this.getPreferenceStore().setValue("platform.language", language.getCode());
        }
        catch (IOException e) {
            throw new DBException("Unexpected error while saving startup configuration", (Throwable)e);
        }
    }

    @NotNull
    public QMRegistry getQueryManager() {
        return this.queryManager;
    }

    public DBPGlobalEventManager getGlobalEventManager() {
        return GlobalEventManagerImpl.getInstance();
    }

    @NotNull
    public DBPDataFormatterRegistry getDataFormatterRegistry() {
        return DataFormatterRegistry.getInstance();
    }

    @NotNull
    public DBPPreferenceStore getPreferenceStore() {
        return DBeaverActivator.getInstance().getPreferences();
    }

    @NotNull
    public DBACertificateStorage getCertificateStorage() {
        return this.certificateStorage;
    }

    @NotNull
    public DBPExternalFileManager getExternalFileManager() {
        return this.workspace;
    }

    @NotNull
    public Path getTempFolder(DBRProgressMonitor monitor, String name) {
        Path localTemp;
        block13: {
            if (this.tempFolder == null) {
                monitor.subTask("Create temp folder");
                try {
                    String tempFolderPath = System.getProperty("dbeaver.io.tmpdir");
                    if (!CommonUtils.isEmpty((String)tempFolderPath)) {
                        File dbTempFolder = new File(tempFolderPath = GeneralUtils.replaceVariables((String)tempFolderPath, (IVariableResolver)new SystemVariablesResolver()));
                        if (!dbTempFolder.mkdirs()) {
                            throw new IOException("Can't create temp directory '" + dbTempFolder.getAbsolutePath() + "'");
                        }
                    } else {
                        tempFolderPath = System.getProperty("java.io.tmpdir");
                    }
                    this.tempFolder = Files.createTempDirectory(Paths.get(tempFolderPath, new String[0]), TEMP_PROJECT_NAME, new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    String sysTempFolder = System.getProperty("java.io.tmpdir");
                    if (CommonUtils.isEmpty((String)sysTempFolder)) break block13;
                    this.tempFolder = Path.of(sysTempFolder, new String[0]).resolve(TEMP_PROJECT_NAME);
                    if (Files.exists(this.tempFolder, new LinkOption[0])) break block13;
                    try {
                        Files.createDirectories(this.tempFolder, new FileAttribute[0]);
                    }
                    catch (IOException iOException2) {
                        String sysUserFolder = System.getProperty("user.home");
                        if (CommonUtils.isEmpty((String)sysUserFolder)) break block13;
                        this.tempFolder = Path.of(sysUserFolder, new String[0]).resolve(TEMP_PROJECT_NAME);
                        if (Files.exists(this.tempFolder, new LinkOption[0])) break block13;
                        try {
                            Files.createDirectories(this.tempFolder, new FileAttribute[0]);
                        }
                        catch (IOException iOException3) {
                            this.tempFolder = Path.of(TEMP_PROJECT_NAME, new String[0]);
                        }
                    }
                }
            }
        }
        Path path = localTemp = name == null ? this.tempFolder : this.tempFolder.resolve(name);
        if (!Files.exists(localTemp, new LinkOption[0])) {
            try {
                Files.createDirectories(localTemp, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Can't create temp directory " + String.valueOf(localTemp)), (Throwable)e);
            }
        }
        return localTemp;
    }

    public boolean isShuttingDown() {
        return DesktopPlatform.isClosing();
    }
}

