/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;

public abstract class JDBCTableForeignKey<TABLE extends JDBCTable, PRIMARY_KEY extends DBSEntityConstraint>
extends JDBCTableConstraint<TABLE>
implements DBSTableForeignKey {
    @Nullable
    protected PRIMARY_KEY referencedConstraint;
    protected DBSForeignKeyModifyRule deleteRule;
    protected DBSForeignKeyModifyRule updateRule;

    public JDBCTableForeignKey(@NotNull TABLE table, @NotNull String name, @Nullable String description, @Nullable PRIMARY_KEY referencedConstraint, DBSForeignKeyModifyRule deleteRule, DBSForeignKeyModifyRule updateRule, boolean persisted) {
        super(table, name, description, DBSEntityConstraintType.FOREIGN_KEY, persisted);
        this.referencedConstraint = referencedConstraint;
        this.deleteRule = deleteRule;
        this.updateRule = updateRule;
    }

    public JDBCTableForeignKey(@NotNull DBRProgressMonitor monitor, @NotNull TABLE table, @NotNull DBSEntityAssociation source, boolean persisted) throws DBException {
        super(table, (DBSEntityConstraint)source, persisted);
        DBSEntity refEntity;
        DBSEntityConstraint srcRefConstraint = source.getReferencedConstraint();
        if (srcRefConstraint != null && (refEntity = srcRefConstraint.getParentObject()) != null) {
            if (srcRefConstraint instanceof JDBCTableConstraint && refEntity.getParentObject() == table.getParentObject()) {
                this.referencedConstraint = srcRefConstraint;
            } else {
                DBSObject refTable;
                DBSObject tableContainer = table.getContainer();
                if (tableContainer instanceof DBSObjectContainer && (refTable = ((DBSObjectContainer)tableContainer).getChild(monitor, refEntity.getName())) instanceof DBSEntity && this.referencedConstraint instanceof DBSEntityReferrer) {
                    List refAttrs = DBUtils.getEntityAttributes((DBRProgressMonitor)monitor, (DBSEntityReferrer)((DBSEntityReferrer)this.referencedConstraint));
                    this.referencedConstraint = DBUtils.findEntityConstraint((DBRProgressMonitor)monitor, (DBSEntity)((DBSEntity)refTable), (Collection)refAttrs);
                }
            }
        }
        if (source instanceof DBSTableForeignKey) {
            this.deleteRule = ((DBSTableForeignKey)source).getDeleteRule();
            this.updateRule = ((DBSTableForeignKey)source).getUpdateRule();
        } else {
            this.deleteRule = DBSForeignKeyModifyRule.NO_ACTION;
            this.updateRule = DBSForeignKeyModifyRule.NO_ACTION;
        }
    }

    @Property(viewable=true, order=3)
    @Nullable
    public TABLE getReferencedTable() {
        return (TABLE)((Object)(this.referencedConstraint == null ? null : (JDBCTable)this.referencedConstraint.getParentObject()));
    }

    @Property(id="reference", viewable=true, order=4)
    @Nullable
    public PRIMARY_KEY getReferencedConstraint() {
        return this.referencedConstraint;
    }

    public void setReferencedConstraint(PRIMARY_KEY referencedConstraint) {
        this.referencedConstraint = referencedConstraint;
    }

    @Property(viewable=true, editable=true, listProvider=ConstraintModifyRuleListProvider.class, order=5)
    @NotNull
    public DBSForeignKeyModifyRule getDeleteRule() {
        return this.deleteRule;
    }

    public void setDeleteRule(DBSForeignKeyModifyRule deleteRule) {
        this.deleteRule = deleteRule;
    }

    @Property(viewable=true, editable=true, listProvider=ConstraintModifyRuleListProvider.class, order=6)
    @NotNull
    public DBSForeignKeyModifyRule getUpdateRule() {
        return this.updateRule;
    }

    public void setUpdateRule(DBSForeignKeyModifyRule updateRule) {
        this.updateRule = updateRule;
    }

    public TABLE getAssociatedEntity() {
        return this.getReferencedTable();
    }

    public static class ConstraintModifyRuleListProvider
    implements IPropertyValueListProvider<JDBCTableForeignKey> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(JDBCTableForeignKey foreignKey) {
            return new DBSForeignKeyModifyRule[]{DBSForeignKeyModifyRule.NO_ACTION, DBSForeignKeyModifyRule.CASCADE, DBSForeignKeyModifyRule.RESTRICT, DBSForeignKeyModifyRule.SET_NULL, DBSForeignKeyModifyRule.SET_DEFAULT};
        }
    }
}

