/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDLabelValuePair;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDValueBinder;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchWithMultipleInsert;
import org.jkiss.dbeaver.model.impl.data.ExecuteInsertBatchImpl;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStringValueHandler;
import org.jkiss.dbeaver.model.impl.sql.ChangeTableDataStatement;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDictionary;
import org.jkiss.dbeaver.model.struct.DBSDictionaryAccessor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCTable<DATASOURCE extends DBPDataSource, CONTAINER extends DBSObject>
extends AbstractTable<DATASOURCE, CONTAINER>
implements DBSDictionary,
DBSDataManipulator,
DBPSaveableObject,
ChangeTableDataStatement {
    private static final Log log = Log.getLog(JDBCTable.class);
    private static final String DEFAULT_TABLE_ALIAS = "x";
    private boolean persisted;

    protected JDBCTable(CONTAINER container, boolean persisted) {
        super(container);
        this.persisted = persisted;
    }

    protected JDBCTable(CONTAINER container, DBSEntity source, boolean persisted) {
        super(container, source);
        this.persisted = persisted;
    }

    protected JDBCTable(CONTAINER container, @Nullable String tableName, boolean persisted) {
        super(container, tableName);
        this.persisted = persisted;
    }

    public abstract JDBCStructCache<CONTAINER, ? extends DBSEntity, ? extends DBSEntityAttribute> getCache();

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public String[] getSupportedFeatures() {
        if (this.isTruncateSupported()) {
            return new String[]{"data.count", "data.filter", "data.search", "data.insert", "data.update", "data.delete", "data.truncate"};
        }
        return new String[]{"data.count", "data.filter", "data.search", "data.insert", "data.update", "data.delete"};
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    protected String getTableName() {
        return this.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    protected void appendSelectSource(DBRProgressMonitor monitor, StringBuilder query, String tableAlias, DBDPseudoAttribute rowIdAttribute) throws DBCException {
        String asteriskString = this.getDataSource().getSQLDialect().getAllAttributesAlias();
        if (asteriskString == null) {
            List attributes;
            try {
                attributes = CommonUtils.safeList((List)this.getAttributes(monitor));
            }
            catch (Exception e) {
                throw new DBCException("Error getting table attributes", (Throwable)e);
            }
            int i = 0;
            while (i < attributes.size()) {
                if (i > 0) {
                    query.append(", ");
                }
                if (tableAlias != null) {
                    query.append(tableAlias).append(".");
                }
                query.append(((DBSEntityAttribute)attributes.get(i)).getName());
                ++i;
            }
        } else if (rowIdAttribute != null) {
            query.append(tableAlias).append(".").append(asteriskString);
            query.append(",").append(rowIdAttribute.translateExpression(tableAlias));
            if (rowIdAttribute.getAlias() != null) {
                query.append(" as ").append(rowIdAttribute.getAlias());
            }
        } else {
            if (tableAlias != null) {
                query.append(tableAlias).append(".");
            }
            query.append(asteriskString);
        }
    }

    protected boolean needAliasInSelect(@Nullable DBDDataFilter dataFilter, @Nullable DBDPseudoAttribute rowIdAttribute, @NotNull DBPDataSource dataSource) {
        return (dataFilter != null || rowIdAttribute != null) && dataSource.getSQLDialect().supportsAliasInSelect();
    }

    protected void appendExtraSelectParameters(@NotNull StringBuilder query) {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        DBRProgressMonitor monitor = session.getProgressMonitor();
        String asteriskString = this.getDataSource().getSQLDialect().getDefaultGroupAttribute();
        if (asteriskString == null) {
            asteriskString = "";
        }
        StringBuilder query = new StringBuilder();
        query.append("SELECT COUNT(").append(asteriskString).append(") FROM ");
        query.append(this.getTableName());
        SQLUtils.appendQueryConditions((DBPDataSource)this.getDataSource(), (StringBuilder)query, null, (DBDDataFilter)dataFilter);
        monitor.subTask(ModelMessages.model_jdbc_fetch_table_row_count);
        Throwable throwable = null;
        Object var10_10 = null;
        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, false);){
            DBCResultSet dbResult;
            block22: {
                Object result;
                block24: {
                    block23: {
                        dbStat.setStatementSource(source);
                        if (!dbStat.executeStatement()) {
                            return 0L;
                        }
                        dbResult = dbStat.openResultSet();
                        if (dbResult == null) {
                            return 0L;
                        }
                        try {
                            if (!dbResult.nextRow()) break block22;
                            result = dbResult.getAttributeValue(0);
                            if (result != null) break block23;
                        }
                        catch (Throwable throwable2) {
                            dbResult.close();
                            throw throwable2;
                        }
                        dbResult.close();
                        return 0L;
                    }
                    if (!(result instanceof Number)) break block24;
                    long l = ((Number)result).longValue();
                    dbResult.close();
                    return l;
                }
                long l = Long.parseLong(result.toString());
                dbResult.close();
                return l;
            }
            dbResult.close();
            return 0L;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, @NotNull DBCExecutionSource source, Map<String, Object> options) throws DBCException {
        boolean multiRowInsertSupported;
        this.readRequiredMeta(session.getProgressMonitor());
        boolean bl = multiRowInsertSupported = this.getDataSource().getSQLDialect().getDefaultMultiValueInsertMode() == SQLDialect.MultiValueInsertMode.GROUP_ROWS;
        if (CommonUtils.toBoolean((Object)options.get("data.manipulate.useMultiInsert")) && multiRowInsertSupported) {
            return new ExecuteBatchWithMultipleInsert(attributes, keysReceiver, true, session, source, (DBSTable)this);
        }
        return new ExecuteInsertBatchImpl(attributes, keysReceiver, true, session, source, (DBSTable)this, this.useUpsert(session));
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] updateAttributes, final @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        if (this.useUpsert(session)) {
            return this.insertData(session, (DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes), keysReceiver, source, Collections.emptyMap());
        }
        this.readRequiredMeta(session.getProgressMonitor());
        DBSAttributeBase[] attributes = (DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes);
        return new ExecuteBatchImpl(attributes, keysReceiver, false){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                DBSAttributeBase attribute;
                String updateSet;
                String tableAlias = null;
                SQLDialect dialect = session.getDataSource().getSQLDialect();
                if (dialect.supportsAliasInUpdate()) {
                    tableAlias = JDBCTable.DEFAULT_TABLE_ALIAS;
                }
                StringBuilder query = new StringBuilder();
                String tableName = DBUtils.getEntityScriptName((DBSEntity)JDBCTable.this, options);
                query.append(JDBCTable.this.generateTableUpdateBegin(tableName));
                if (tableAlias != null) {
                    query.append(' ').append(tableAlias);
                }
                if (!CommonUtils.isEmpty((String)(updateSet = JDBCTable.this.generateTableUpdateSet()))) {
                    query.append("\n\t").append(updateSet);
                }
                boolean hasKey = false;
                int i = 0;
                while (i < updateAttributes.length) {
                    attribute = updateAttributes[i];
                    if (hasKey) {
                        query.append(",");
                    }
                    hasKey = true;
                    if (tableAlias != null) {
                        query.append(tableAlias).append(dialect.getStructSeparator());
                    }
                    query.append(DBStructUtils.getAttributeName((DBSAttributeBase)attribute, (DBPAttributeReferencePurpose)DBPAttributeReferencePurpose.UPDATE_TARGET)).append("=");
                    DBDValueHandler valueHandler = handlers[i];
                    if (valueHandler instanceof DBDValueBinder) {
                        query.append(((DBDValueBinder)valueHandler).makeQueryBind(attribute, attributeValues[i]));
                    } else {
                        query.append("?");
                    }
                    ++i;
                }
                if (keyAttributes.length > 0) {
                    query.append("\n\tWHERE ");
                    hasKey = false;
                    i = 0;
                    while (i < keyAttributes.length) {
                        attribute = keyAttributes[i];
                        if (hasKey) {
                            query.append(" AND ");
                        }
                        hasKey = true;
                        JDBCTable.this.appendAttributeCriteria(tableAlias, dialect, query, attribute, attributeValues[updateAttributes.length + i]);
                        ++i;
                    }
                }
                DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, this.keysReceiver != null);
                dbStat.setStatementSource(source);
                return dbStat;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                int paramIndex = 0;
                int k = 0;
                while (k < handlers.length) {
                    DBSAttributeBase attribute = this.attributes[k];
                    if (k < updateAttributes.length || !DBUtils.isNullValue((Object)attributeValues[k])) {
                        handlers[k].bindValueObject(statement.getSession(), statement, (DBSTypedObject)attribute, paramIndex++, attributeValues[k]);
                    }
                    ++k;
                }
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] keyAttributes, final @NotNull DBCExecutionSource source) throws DBCException {
        this.readRequiredMeta(session.getProgressMonitor());
        return new ExecuteBatchImpl(keyAttributes, null, false){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                String tableAlias = null;
                SQLDialect dialect = session.getDataSource().getSQLDialect();
                if (dialect.supportsAliasInUpdate()) {
                    tableAlias = JDBCTable.DEFAULT_TABLE_ALIAS;
                }
                StringBuilder query = new StringBuilder();
                String tableName = DBUtils.getEntityScriptName((DBSEntity)JDBCTable.this, options);
                query.append(JDBCTable.this.generateTableDeleteFrom(tableName));
                if (tableAlias != null) {
                    query.append(' ').append(tableAlias);
                }
                if (keyAttributes.length > 0) {
                    query.append("\n\tWHERE ");
                    boolean hasKey = false;
                    int i = 0;
                    while (i < keyAttributes.length) {
                        if (hasKey) {
                            query.append(" AND ");
                        }
                        hasKey = true;
                        JDBCTable.this.appendAttributeCriteria(tableAlias, dialect, query, keyAttributes[i], attributeValues[i]);
                        ++i;
                    }
                }
                DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, query.toString(), false, false, false);
                dbStat.setStatementSource(source);
                return dbStat;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                int paramIndex = 0;
                int k = 0;
                while (k < handlers.length) {
                    DBSAttributeBase attribute = this.attributes[k];
                    if (!DBUtils.isNullValue((Object)attributeValues[k])) {
                        handlers[k].bindValueObject(statement.getSession(), statement, (DBSTypedObject)attribute, paramIndex++, attributeValues[k]);
                    }
                    ++k;
                }
            }
        };
    }

    public boolean supportsDictionaryEnumeration() {
        return true;
    }

    @NotNull
    public List<DBDLabelValuePair> getDictionaryEnumeration(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute keyColumn, @Nullable Object keyPattern, @Nullable String searchText, @Nullable List<DBDAttributeValue> preceedingKeys, boolean caseInsensitiveSearch, boolean sortAsc, boolean sortByValue, int offset, int maxResults) throws DBException {
        return this.readKeyEnumeration(monitor, keyColumn, keyPattern, searchText, preceedingKeys, sortByValue, sortAsc, caseInsensitiveSearch, maxResults, offset);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public List<DBDLabelValuePair> getDictionaryValues(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute keyColumn, @NotNull List<Object> keyValues, @Nullable List<DBDAttributeValue> preceedingKeys, boolean sortByValue, boolean sortAsc) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private List<DBDLabelValuePair> readKeyEnumeration(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute keyColumn, @Nullable Object keyValue, @Nullable String searchText, @Nullable List<DBDAttributeValue> preceedingKeys, boolean sortByValue, boolean sortAsc, boolean caseInsensitiveSearch, int maxResults, int offset) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DBSDictionaryAccessor getDictionaryAccessor(DBRProgressMonitor monitor, List<DBDAttributeValue> preceedingKeys, DBSEntityAttribute keyColumn, boolean sortAsc, boolean sortByDesc) throws DBException {
        return new DictionaryAccessor(monitor, preceedingKeys, keyColumn, sortAsc, sortByDesc);
    }

    @NotNull
    public DBCStatistics truncateData(@NotNull DBCSession session, @NotNull DBCExecutionSource source) throws DBCException {
        if (!this.isTruncateSupported()) {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DBSDataManipulator.ExecuteBatch batch = this.deleteData(session, new DBSAttributeBase[0], source);){
                batch.add(new Object[0]);
                return batch.execute(session, Collections.emptyMap());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        DBCStatistics statistics = new DBCStatistics();
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.subTask("Truncate data");
        Throwable throwable = null;
        Object var6_12 = null;
        try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, this.getTruncateTableQuery(), false, false, false);){
            dbStat.setStatementSource(source);
            dbStat.executeStatement();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        statistics.addStatementsCount();
        statistics.addExecuteTime();
        return statistics;
    }

    protected boolean isTruncateSupported() {
        return true;
    }

    protected String getTruncateTableQuery() {
        return "TRUNCATE TABLE " + this.getFullyQualifiedName(DBPEvaluationContext.DML);
    }

    private boolean useUpsert(@NotNull DBCSession session) {
        SQLDialect dialect = session.getDataSource().getSQLDialect();
        return dialect instanceof JDBCSQLDialect && ((JDBCSQLDialect)dialect).supportsUpsertStatement();
    }

    private void appendAttributeCriteria(@Nullable String tableAlias, SQLDialect dialect, StringBuilder query, DBSAttributeBase attribute, Object value) {
        DBDPseudoAttribute pseudoAttribute = null;
        if (DBUtils.isPseudoAttribute((DBSAttributeBase)attribute)) {
            if (attribute instanceof DBDAttributeBindingMeta) {
                pseudoAttribute = ((DBDAttributeBindingMeta)attribute).getPseudoAttribute();
            } else {
                log.error((Object)("Unsupported attribute argument: " + String.valueOf(attribute)));
            }
        }
        if (pseudoAttribute != null) {
            if (tableAlias == null) {
                tableAlias = this.getFullyQualifiedName(DBPEvaluationContext.DML);
            }
            String criteria = pseudoAttribute.translateExpression(tableAlias);
            query.append(criteria);
        } else {
            if (tableAlias != null) {
                query.append(tableAlias).append(dialect.getStructSeparator());
            }
            query.append(dialect.getCastedAttributeName(attribute, DBStructUtils.getAttributeName((DBSAttributeBase)attribute)));
        }
        if (DBUtils.isNullValue((Object)value)) {
            query.append(" IS NULL");
        } else {
            query.append("=").append(dialect.getTypeCastClause((DBSTypedObject)attribute, "?", true));
        }
    }

    private void readRequiredMeta(DBRProgressMonitor monitor) throws DBCException {
        try {
            this.getAttributes(monitor);
        }
        catch (DBException e) {
            throw new DBCException("Can't cache table columns", (Throwable)e);
        }
    }

    public String generateTableUpdateBegin(String tableName) {
        return "UPDATE " + tableName;
    }

    public String generateTableUpdateSet() {
        return "SET ";
    }

    public String generateTableDeleteFrom(String tableName) {
        return "DELETE FROM " + tableName;
    }

    private static class AttrInfo<T> {
        public final T attr;
        public final DBDValueHandler handler;

        public AttrInfo(T attr, DBDValueHandler handler) {
            this.attr = attr;
            this.handler = handler;
        }
    }

    protected class DictionaryAccessor
    implements DBSDictionaryAccessor {
        private final List<AttrInfo<DBDAttributeValue>> preceedingKeysInfo;
        private final DBSEntityAttribute keyColumn;
        private final boolean sortAsc;
        private final boolean sortByDesc;
        private final DBDValueHandler keyValueHandler;
        private final String descColumns;
        private final Collection<DBSEntityAttribute> descAttributes;
        private final Collection<AttrInfo<DBSEntityAttribute>> descAttributesInfo;
        private final boolean isKeyComparable;
        private final DBDDataFilter filter;
        private JDBCSession session;

        public DictionaryAccessor(@Nullable DBRProgressMonitor monitor, @NotNull List<DBDAttributeValue> preceedingKeys, DBSEntityAttribute keyColumn, boolean sortAsc, boolean sortByDesc) throws DBException {
            this.keyColumn = keyColumn;
            this.sortAsc = sortAsc;
            this.sortByDesc = sortByDesc;
            this.keyValueHandler = DBUtils.findValueHandler((DBPDataSource)keyColumn.getDataSource(), (DBSTypedObject)keyColumn);
            this.descColumns = DBVUtils.getDictionaryDescriptionColumns((DBRProgressMonitor)monitor, (DBSEntityAttribute)keyColumn);
            this.descAttributes = this.descColumns == null ? null : DBVEntity.getDescriptionColumns((DBRProgressMonitor)monitor, (DBSEntity)JDBCTable.this, (String)this.descColumns);
            this.isKeyComparable = ArrayUtils.contains((Object[])DBUtils.getAttributeOperators((DBSTypedObject)keyColumn), (Object)DBCLogicalOperator.LESS);
            this.session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)JDBCTable.this, (String)"Load attribute values count");
            int capacity = preceedingKeys == null ? 0 : preceedingKeys.size() + 1;
            ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>(capacity);
            ArrayList<AttrInfo<DBDAttributeValue>> preceedingKeysInfo = new ArrayList<AttrInfo<DBDAttributeValue>>(capacity);
            if (preceedingKeys != null) {
                for (DBDAttributeValue key : preceedingKeys) {
                    DBDAttributeConstraint constraint = new DBDAttributeConstraint(key.getAttribute(), constraints.size());
                    constraint.setValue(key.getValue());
                    constraint.setOperator(DBCLogicalOperator.EQUALS);
                    constraints.add(constraint);
                    DBDValueHandler precValueHandler = DBUtils.findValueHandler((DBCSession)this.session, (DBSTypedObject)key.getAttribute());
                    preceedingKeysInfo.add(new AttrInfo<DBDAttributeValue>(key, precValueHandler));
                }
            }
            this.preceedingKeysInfo = preceedingKeysInfo;
            this.filter = new DBDDataFilter(constraints);
            this.descAttributesInfo = this.descAttributes == null ? Collections.emptyList() : (Collection)this.descAttributes.stream().map(a -> new AttrInfo<DBSEntityAttribute>((DBSEntityAttribute)a, DBUtils.findValueHandler((DBCSession)this.session, (DBSTypedObject)a))).collect(Collectors.toList());
        }

        public boolean isKeyComparable() {
            return this.isKeyComparable;
        }

        private int bindPrecedingKeys(@NotNull DBCStatement dbStat) throws DBCException {
            int paramPos = 0;
            if (!this.preceedingKeysInfo.isEmpty()) {
                for (AttrInfo<DBDAttributeValue> k : this.preceedingKeysInfo) {
                    k.handler.bindValueObject((DBCSession)this.session, dbStat, (DBSTypedObject)((DBDAttributeValue)k.attr).getAttribute(), paramPos++, ((DBDAttributeValue)k.attr).getValue());
                }
            }
            return paramPos;
        }

        @NotNull
        public List<DBDLabelValuePair> getValueEntry(@NotNull Object keyValue) throws DBException {
            DBDDataFilter filter = new DBDDataFilter(this.filter);
            List constraints = filter.getConstraints();
            DBDAttributeConstraint constraint = new DBDAttributeConstraint((DBSAttributeBase)this.keyColumn, constraints.size());
            constraint.setValue(keyValue);
            constraint.setOperator(DBCLogicalOperator.EQUALS);
            constraints.add(constraint);
            StringBuilder query = this.prepareQueryString(filter);
            Throwable throwable = null;
            Object var7_8 = null;
            try (DBCStatement dbStat = DBUtils.makeStatement(null, (DBCSession)this.session, (DBCStatementType)DBCStatementType.QUERY, (String)query.toString(), (long)0L, (long)1L);){
                int paramPos = this.bindPrecedingKeys(dbStat);
                this.keyValueHandler.bindValueObject((DBCSession)this.session, dbStat, (DBSTypedObject)this.keyColumn, paramPos, keyValue);
                return this.readValues(dbStat);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @NotNull
        public List<DBDLabelValuePair> getValues(long offset, int pageSize) throws DBException {
            StringBuilder query = this.prepareQueryString(this.filter);
            this.appendSortingClause(query, false);
            Throwable throwable = null;
            Object var6_6 = null;
            try (DBCStatement dbStat = DBUtils.makeStatement(null, (DBCSession)this.session, (DBCStatementType)DBCStatementType.QUERY, (String)query.toString(), (long)offset, (long)pageSize);){
                this.bindPrecedingKeys(dbStat);
                return this.readValues(dbStat);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @NotNull
        public List<DBDLabelValuePair> getValuesNear(@NotNull Object value, boolean isPreceeding, long offset, long maxResults) throws DBException {
            DBDDataFilter filter = new DBDDataFilter(this.filter);
            List constraints = filter.getConstraints();
            DBDAttributeConstraint constraint = new DBDAttributeConstraint((DBSAttributeBase)this.keyColumn, constraints.size());
            constraint.setValue(value);
            constraint.setOperator(isPreceeding ^ this.sortAsc ? DBCLogicalOperator.GREATER_EQUALS : DBCLogicalOperator.LESS);
            constraints.add(constraint);
            StringBuilder query = this.prepareQueryString(filter);
            this.appendSortingClause(query, isPreceeding);
            Throwable throwable = null;
            Object var12_11 = null;
            try (DBCStatement dbStat = DBUtils.makeStatement(null, (DBCSession)this.session, (DBCStatementType)DBCStatementType.QUERY, (String)query.toString(), (long)offset, (long)maxResults);){
                int paramPos = this.bindPrecedingKeys(dbStat);
                this.keyValueHandler.bindValueObject((DBCSession)this.session, dbStat, (DBSTypedObject)this.keyColumn, paramPos, value);
                return this.readValues(dbStat);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @NotNull
        public List<DBDLabelValuePair> getSimilarValues(@NotNull Object pattern, boolean caseInsensitive, boolean byDesc, long offset, long maxResults) throws DBException {
            StringBuilder query = this.prepareQueryString(this.filter);
            this.appendByPatternCondition(query, this.filter, pattern, caseInsensitive, byDesc);
            this.appendSortingClause(query, false);
            Throwable throwable = null;
            Object var10_9 = null;
            try (DBCStatement dbStat = DBUtils.makeStatement(null, (DBCSession)this.session, (DBCStatementType)DBCStatementType.QUERY, (String)query.toString(), (long)offset, (long)maxResults);){
                int paramPos = this.bindPrecedingKeys(dbStat);
                this.bindPattern(dbStat, pattern, byDesc, paramPos);
                return this.readValues(dbStat);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @NotNull
        public List<DBDLabelValuePair> getSimilarValuesNear(@NotNull Object pattern, boolean caseInsensitive, boolean byDesc, Object value, boolean isPreceeding, long offset, long maxResults) throws DBException {
            DBDDataFilter filter = new DBDDataFilter(this.filter);
            List constraints = filter.getConstraints();
            DBDAttributeConstraint constraint = new DBDAttributeConstraint((DBSAttributeBase)this.keyColumn, constraints.size());
            constraint.setValue(value);
            constraint.setOperator(isPreceeding ^ this.sortAsc ? DBCLogicalOperator.GREATER_EQUALS : DBCLogicalOperator.LESS);
            constraints.add(constraint);
            StringBuilder query = this.prepareQueryString(filter);
            this.appendByPatternCondition(query, filter, pattern, caseInsensitive, byDesc);
            this.appendSortingClause(query, isPreceeding);
            Throwable throwable = null;
            Object var15_14 = null;
            try (DBCStatement dbStat = DBUtils.makeStatement(null, (DBCSession)this.session, (DBCStatementType)DBCStatementType.QUERY, (String)query.toString(), (long)offset, (long)maxResults);){
                int paramPos = this.bindPrecedingKeys(dbStat);
                this.keyValueHandler.bindValueObject((DBCSession)this.session, dbStat, (DBSTypedObject)this.keyColumn, paramPos++, value);
                this.bindPattern(dbStat, pattern, byDesc, paramPos);
                return this.readValues(dbStat);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @NotNull
        private StringBuilder prepareQueryString(@NotNull DBDDataFilter filter) {
            StringBuilder query = new StringBuilder();
            query.append("SELECT ").append(DBUtils.getQuotedIdentifier((DBSObject)this.keyColumn, (DBPAttributeReferencePurpose)DBPAttributeReferencePurpose.DATA_SELECTION));
            if (this.descAttributes != null) {
                if (DBUtils.findObject(this.descAttributes, (String)this.keyColumn.getName(), (boolean)true) != null) {
                    query.append(" dbvrvalue");
                }
                query.append(", ").append(this.descColumns);
            }
            query.append(" FROM ").append(DBUtils.getObjectFullName((DBPNamedObject)JDBCTable.this, (DBPEvaluationContext)DBPEvaluationContext.DML));
            if (filter.getConstraints().size() > 0) {
                query.append(" WHERE ");
            }
            JDBCTable.this.getDataSource().getSQLDialect().getQueryGenerator().appendConditionString(filter, JDBCTable.this.getDataSource(), null, query, false);
            return query;
        }

        @NotNull
        private List<DBDLabelValuePair> readValues(@NotNull DBCStatement dbStat) throws DBException {
            if (dbStat.executeStatement()) {
                Throwable throwable = null;
                Object var3_4 = null;
                try (DBCResultSet dbResult = dbStat.openResultSet();){
                    return DBVUtils.readDictionaryRows((DBCSession)this.session, (DBSEntityAttribute)this.keyColumn, (DBDValueHandler)this.keyValueHandler, (DBCResultSet)dbResult, (boolean)true, (boolean)false);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return Collections.emptyList();
        }

        private void appendByPatternCondition(@NotNull StringBuilder query, @NotNull DBDDataFilter existingFilter, @NotNull Object pattern, boolean caseInsensitive, boolean byDesc) {
            if (existingFilter.getConstraints().size() > 0) {
                query.append(" AND ");
            } else {
                query.append(" WHERE ");
            }
            DBDDataFilter patternFilter = this.prepareByPatternCondition(pattern, caseInsensitive, byDesc);
            query.append("(");
            JDBCTable.this.getDataSource().getSQLDialect().getQueryGenerator().appendConditionString(patternFilter, JDBCTable.this.getDataSource(), null, query, false);
            if (CommonUtils.isNotEmpty((String)this.descColumns) && (this.descAttributes == null || this.descAttributes.isEmpty())) {
                if (patternFilter.hasConditions()) {
                    query.append(" OR ");
                }
                query.append("(").append(this.descColumns).append(") LIKE ").append("?");
            }
            query.append(")");
        }

        @NotNull
        private DBDDataFilter prepareByPatternCondition(@NotNull Object pattern, boolean caseInsensitive, boolean byDesc) {
            DBDDataFilter filter = new DBDDataFilter();
            filter.setAnyConstraint(true);
            List constraints = filter.getConstraints();
            DBDAttributeConstraint keyConstraint = new DBDAttributeConstraint((DBSAttributeBase)this.keyColumn, constraints.size());
            if (this.keyColumn.getDataKind() == DBPDataKind.STRING) {
                boolean ilikeUsable = ArrayUtils.contains((Object[])this.keyValueHandler.getSupportedOperators((DBSTypedObject)this.keyColumn), (Object)DBCLogicalOperator.ILIKE);
                keyConstraint.setValue((Object)("%" + String.valueOf(pattern) + "%"));
                keyConstraint.setOperator(caseInsensitive && ilikeUsable ? DBCLogicalOperator.ILIKE : DBCLogicalOperator.LIKE);
            } else if (this.keyColumn.getDataKind() == DBPDataKind.NUMERIC) {
                if (CommonUtils.isNumber((Object)pattern)) {
                    keyConstraint.setValue(pattern);
                    keyConstraint.setOperator(DBCLogicalOperator.GREATER_EQUALS);
                }
            } else if (pattern instanceof CharSequence) {
                keyConstraint.setValue(pattern);
                keyConstraint.setOperator(DBCLogicalOperator.EQUALS);
            }
            if (keyConstraint.getValue() != null) {
                constraints.add(keyConstraint);
            }
            if (byDesc && pattern instanceof CharSequence) {
                for (AttrInfo<DBSEntityAttribute> a : this.descAttributesInfo) {
                    if (((DBSEntityAttribute)a.attr).getDataKind() != DBPDataKind.STRING) continue;
                    DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)this.session, (DBSTypedObject)((DBSTypedObject)a.attr));
                    boolean ilikeUsable = ArrayUtils.contains((Object[])valueHandler.getSupportedOperators((DBSTypedObject)a.attr), (Object)DBCLogicalOperator.ILIKE);
                    DBDAttributeConstraint descConstraint = new DBDAttributeConstraint((DBSAttributeBase)a.attr, constraints.size());
                    descConstraint.setValue((Object)("%" + String.valueOf(pattern) + "%"));
                    descConstraint.setOperator(caseInsensitive && ilikeUsable ? DBCLogicalOperator.ILIKE : DBCLogicalOperator.LIKE);
                    constraints.add(descConstraint);
                }
            }
            return filter;
        }

        private void bindPattern(@NotNull DBCStatement dbStat, @NotNull Object pattern, boolean byDesc, int bindAt) throws DBCException {
            int paramPos = bindAt;
            if (this.keyColumn.getDataKind() == DBPDataKind.STRING) {
                this.keyValueHandler.bindValueObject((DBCSession)this.session, dbStat, (DBSTypedObject)this.keyColumn, paramPos++, (Object)("%" + String.valueOf(pattern) + "%"));
            } else if (this.keyColumn.getDataKind() == DBPDataKind.NUMERIC) {
                if (CommonUtils.isNumber((Object)pattern)) {
                    this.keyValueHandler.bindValueObject((DBCSession)this.session, dbStat, (DBSTypedObject)this.keyColumn, paramPos++, pattern);
                }
            } else if (pattern instanceof CharSequence) {
                this.keyValueHandler.bindValueObject((DBCSession)this.session, dbStat, (DBSTypedObject)this.keyColumn, paramPos++, pattern);
            }
            if (byDesc && pattern instanceof CharSequence) {
                for (AttrInfo<DBSEntityAttribute> a : this.descAttributesInfo) {
                    if (((DBSEntityAttribute)a.attr).getDataKind() != DBPDataKind.STRING) continue;
                    a.handler.bindValueObject((DBCSession)this.session, dbStat, (DBSTypedObject)a.attr, paramPos++, (Object)("%" + String.valueOf(pattern) + "%"));
                }
            }
            if (CommonUtils.isNotEmpty((String)this.descColumns) && (this.descAttributes == null || this.descAttributes.isEmpty())) {
                JDBCStringValueHandler.INSTANCE.bindValueObject(this.session, dbStat, null, paramPos++, "%" + String.valueOf(pattern) + "%");
            }
        }

        private void appendSortingClause(@NotNull StringBuilder query, boolean isPreceeding) {
            if (this.isKeyComparable() || this.sortByDesc) {
                query.append(" ORDER BY ");
                if (this.sortByDesc) {
                    query.append(this.descColumns);
                } else {
                    query.append(DBUtils.getQuotedIdentifier((DBSObject)this.keyColumn));
                }
                if (this.sortAsc ^ isPreceeding) {
                    query.append(" ASC");
                } else {
                    query.append(" DESC");
                }
            }
        }

        public void close() throws Exception {
            this.session.close();
        }
    }
}

