/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.struct;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCDataType<OWNER extends DBSObject>
implements DBSDataType {
    private final OWNER owner;
    private int valueType;
    private String name;
    private String remarks;
    private boolean isUnsigned;
    private boolean isSearchable;
    private int precision;
    private int minScale;
    private int maxScale;

    public JDBCDataType(OWNER owner, int valueType, String name, @Nullable String remarks, boolean unsigned, boolean searchable, int precision, int minScale, int maxScale) {
        this.owner = owner;
        this.valueType = valueType;
        this.name = name;
        this.remarks = remarks;
        this.isUnsigned = unsigned;
        this.isSearchable = searchable;
        this.precision = precision;
        this.minScale = minScale;
        this.maxScale = maxScale;
    }

    public JDBCDataType(OWNER owner, DBSTypedObject typed) {
        this(owner, typed.getTypeID(), typed.getTypeName(), null, false, false, typed.getPrecision(), typed.getScale(), typed.getScale());
    }

    public String getTypeName() {
        return this.name;
    }

    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public int getTypeID() {
        return this.valueType;
    }

    protected void setTypeID(int valueType) {
        this.valueType = valueType;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @NotNull
    public OWNER getParentObject() {
        return this.owner;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.owner.getDataSource();
    }

    public DBPDataKind getDataKind() {
        return JDBCUtils.resolveDataKind(this.getDataSource(), this.name, this.valueType);
    }

    public Integer getScale() {
        return this.minScale;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isSearchable() {
        return this.isSearchable;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public long getMaxLength() {
        return this.precision;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    @Nullable
    public Object geTypeExtension() {
        return null;
    }

    @Nullable
    public DBSDataType getComponentType(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public int getMinScale() {
        return this.minScale;
    }

    public int getMaxScale() {
        return this.maxScale;
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(DBSTypedObject attribute) {
        return DBUtils.getDefaultOperators((DBSTypedObject)attribute);
    }

    public String toString() {
        if (this.owner instanceof DBPDataSource) {
            return this.name;
        }
        return this.owner.getName() + "." + this.name;
    }

    public boolean isPersisted() {
        return true;
    }
}

