/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.svg;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.parser.SVGLoader;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.svg.ImageConverter;

public class SVGImageDescriptor
extends ImageDescriptor {
    private static final Log log = Log.getLog(SVGImageDescriptor.class);
    private final URL url;

    private SVGImageDescriptor(@NotNull URL url) {
        this.url = url;
    }

    @NotNull
    public static ImageDescriptor createFromURL(@Nullable URL url) {
        if (url != null && url.getPath().endsWith(".svg")) {
            return new SVGImageDescriptor(url);
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImageData getImageData(int zoom) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = this.openStream();){
                if (is == null) {
                    return null;
                }
                SVGLoader loader = new SVGLoader();
                SVGDocument document = loader.load(is);
                if (document == null) {
                    return null;
                }
                float factor = (float)zoom / 100.0f;
                int width = (int)(document.size().width * factor);
                int height = (int)(document.size().height * factor);
                BufferedImage target = new BufferedImage(width, height, 2);
                Graphics2D graphics = target.createGraphics();
                try {
                    graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
                    graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
                    graphics.scale(factor, factor);
                    document.render(null, graphics);
                    return ImageConverter.convertToImageData(target);
                }
                finally {
                    graphics.dispose();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"Can't load SVG image", (Throwable)e);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        SVGImageDescriptor that = (SVGImageDescriptor)((Object)object);
        return Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    @Nullable
    private InputStream openStream() throws IOException {
        URL resolved = FileLocator.find((URL)this.url);
        if (resolved == null) {
            return null;
        }
        return new BufferedInputStream(resolved.openStream());
    }
}

