/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.IOUtils;

public final class ShellUtils {
    private static final Log log = Log.getLog(ShellUtils.class);

    private ShellUtils() {
    }

    public static boolean launchProgram(@NotNull String path) {
        return Program.launch((String)path);
    }

    public static boolean openExternalFile(@NotNull Path path) {
        block6: {
            if (!RuntimeUtils.isMacOS()) break block6;
            ShellUtils.executeWithReturnCodeCheck("open", "-a", "Finder.app", path.toAbsolutePath().toString());
            return true;
        }
        try {
            if (RuntimeUtils.isLinux()) {
                ShellUtils.executeWithReturnCodeCheck("xdg-open", path.toAbsolutePath().toString());
                return true;
            }
        }
        catch (IOException | InterruptedException e) {
            log.debug((Object)("Unable to open external program in a platform-specific way: " + e.getMessage()));
        }
        try {
            Desktop.getDesktop().open(path.toFile());
            return true;
        }
        catch (IOException e) {
            log.error((Object)"Unable to open external file", (Throwable)e);
            return false;
        }
    }

    public static void showInSystemExplorer(@NotNull String path) {
        File file = new File(path);
        try {
            String cmd = ShellUtils.formShowInSystemExplorerCommand(file);
            Process process = Util.isLinux() || Util.isMac() ? Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", cmd}, null) : Runtime.getRuntime().exec(cmd, null);
            int code = process.waitFor();
            if (code != 0 && !Util.isWindows()) {
                log.debug((Object)("Execution of '" + cmd + "' failed with return code: " + code));
            }
        }
        catch (IOException | InterruptedException e) {
            log.debug((Object)"Error opening file in explorer", (Throwable)e);
            if (file.isDirectory()) {
                ShellUtils.launchProgram(file.getAbsolutePath());
            }
            ShellUtils.launchProgram(file.getParent());
        }
    }

    private static void executeWithReturnCodeCheck(String ... cmd) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(cmd);
        int code = process.waitFor();
        if (code != 0) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringWriter writer = new StringWriter();
            IOUtils.copyText((Reader)reader, (Writer)writer);
            throw new IOException("Process ended with code " + code + ": " + String.valueOf(writer));
        }
    }

    @NotNull
    private static String formShowInSystemExplorerCommand(@NotNull File path) throws IOException {
        String command = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SYSTEM_EXPLORER");
        command = Util.replaceAll((String)command, (String)"${selected_resource_loc}", (String)ShellUtils.quotePath(path.getCanonicalPath()));
        command = Util.replaceAll((String)command, (String)"${selected_resource_uri}", (String)path.getCanonicalFile().toURI().toString());
        File parent = path.getParentFile();
        if (parent != null) {
            command = Util.replaceAll((String)command, (String)"${selected_resource_parent_loc}", (String)ShellUtils.quotePath(parent.getCanonicalPath()));
        }
        return command;
    }

    @NotNull
    private static String quotePath(@NotNull String path) {
        if (Util.isLinux() || Util.isMac()) {
            return path.replaceAll("[\"$`]", "\\\\$0");
        }
        return path;
    }
}

