/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ActionUtils {
    private static final Log log = Log.getLog(ActionUtils.class);
    private static final Set<IPropertyChangeListener> propertyEvaluationRequestListeners = Collections.synchronizedSet(new HashSet());

    public static void addPropertyEvaluationRequestListener(@NotNull IPropertyChangeListener listener) {
        propertyEvaluationRequestListeners.add(listener);
    }

    public static void removePropertyEvaluationRequestListener(@NotNull IPropertyChangeListener listener) {
        propertyEvaluationRequestListeners.remove(listener);
    }

    public static CommandContributionItem makeCommandContribution(@NotNull IServiceLocator serviceLocator, @NotNull String commandId) {
        return ActionUtils.makeCommandContribution(serviceLocator, commandId, 8);
    }

    public static CommandContributionItem makeCommandContribution(@NotNull IServiceLocator serviceLocator, @NotNull String commandId, int style) {
        return new CommandContributionItem(new CommandContributionItemParameter(serviceLocator, null, commandId, style));
    }

    public static CommandContributionItem makeCommandContribution(@NotNull IServiceLocator serviceLocator, @NotNull String commandId, int style, @Nullable DBPImage icon) {
        CommandContributionItemParameter parameters = new CommandContributionItemParameter(serviceLocator, null, commandId, style);
        parameters.icon = DBeaverIcons.getImageDescriptor(icon);
        return new CommandContributionItem(parameters);
    }

    public static CommandContributionItem makeCommandContribution(IServiceLocator serviceLocator, String commandId, String name, DBPImage image) {
        return ActionUtils.makeCommandContribution(serviceLocator, commandId, name, image, null, false);
    }

    public static ContributionItem makeActionContribution(@NotNull IAction action, boolean showText) {
        ActionContributionItem item = new ActionContributionItem(action);
        if (showText) {
            item.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        }
        return item;
    }

    public static ContributionItem makeActionContribution(@NotNull IAction action, DBPImage image) {
        ActionContributionItem item = new ActionContributionItem(action);
        if (image != null) {
            action.setImageDescriptor(DBeaverIcons.getImageDescriptor(image));
        }
        return item;
    }

    public static CommandContributionItem makeCommandContribution(@NotNull IServiceLocator serviceLocator, @NotNull String commandId, @Nullable String name, @Nullable DBPImage image, @Nullable String toolTip, boolean showText) {
        return ActionUtils.makeCommandContribution(serviceLocator, commandId, 8, name, image, toolTip, showText, null);
    }

    public static CommandContributionItem makeCommandContribution(@NotNull IServiceLocator serviceLocator, @NotNull String commandId, int style, @Nullable String name, @Nullable DBPImage image, @Nullable String toolTip, boolean showText, @Nullable Map<String, Object> parameters) {
        CommandContributionItemParameter contributionParameters = new CommandContributionItemParameter(serviceLocator, null, commandId, null, image == null ? null : DBeaverIcons.getImageDescriptor(image), null, null, name, null, toolTip, style, null, false);
        contributionParameters.parameters = parameters;
        if (showText) {
            contributionParameters.mode = CommandContributionItem.MODE_FORCE_TEXT;
        }
        return new CommandContributionItem(contributionParameters);
    }

    public static boolean isCommandEnabled(String commandId, IServiceLocator site) {
        if (commandId != null && site != null) {
            try {
                ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
                if (commandService != null) {
                    Command command = commandService.getCommand(commandId);
                    return command != null && command.isEnabled();
                }
            }
            catch (Exception e) {
                log.error((Object)("Can't execute command '" + commandId + "'"), (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isCommandChecked(String commandId, IWorkbenchPartSite site) {
        if (commandId != null && site != null) {
            try {
                ICommandService commandService = (ICommandService)site.getService(ICommandService.class);
                if (commandService != null) {
                    Command command = commandService.getCommand(commandId);
                    return command != null && command.getState(ToggleState.class.getName()) != null;
                }
            }
            catch (Exception e) {
                log.error((Object)("Can't execute command '" + commandId + "'"), (Throwable)e);
            }
        }
        return false;
    }

    @Nullable
    public static String findCommandName(String commandId) {
        Command command;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null && (command = commandService.getCommand(commandId)) != null && command.isDefined()) {
            try {
                return command.getName();
            }
            catch (NotDefinedException e) {
                log.debug((Object)e);
            }
        }
        return "???";
    }

    @Nullable
    public static ImageDescriptor findCommandImage(String commandId) {
        ICommandImageService commandService = (ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class);
        if (commandService != null) {
            return commandService.getImageDescriptor(commandId);
        }
        return null;
    }

    @Nullable
    public static String findCommandDescription(String commandId, IServiceLocator serviceLocator, boolean shortcutOnly) {
        return ActionUtils.findCommandDescription(commandId, serviceLocator, shortcutOnly, null, null);
    }

    @Nullable
    public static String findCommandDescription(String commandId, IServiceLocator serviceLocator, boolean shortcutOnly, String paramName, String paramValue) {
        IBindingService bindingService;
        Command command;
        String commandName = null;
        String shortcut = null;
        ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
        if (commandService != null && (command = commandService.getCommand(commandId)) != null && command.isDefined()) {
            try {
                commandName = command.getName();
            }
            catch (NotDefinedException e) {
                log.debug((Object)e);
            }
        }
        if ((bindingService = (IBindingService)serviceLocator.getService(IBindingService.class)) != null) {
            TriggerSequence sequence = null;
            Binding[] bindings = bindingService.getBindings();
            if (bindings != null) {
                Binding[] bindingArray = bindings;
                int n = bindings.length;
                int n2 = 0;
                while (n2 < n) {
                    Object cmdParamValue;
                    Binding b = bindingArray[n2];
                    ParameterizedCommand parameterizedCommand = b.getParameterizedCommand();
                    if (parameterizedCommand != null && commandId.equals(parameterizedCommand.getId()) && (paramName == null || CommonUtils.equalObjects(cmdParamValue = parameterizedCommand.getParameterMap().get(paramName), (Object)paramValue))) {
                        sequence = b.getTriggerSequence();
                        if (b.getType() == 1) break;
                    }
                    ++n2;
                }
            }
            if (sequence == null) {
                sequence = bindingService.getBestActiveBindingFor(commandId);
            }
            if (sequence != null) {
                shortcut = sequence.format();
            }
        }
        if (shortcutOnly) {
            return shortcut == null ? "" : shortcut;
        }
        if (shortcut == null) {
            return commandName;
        }
        if (commandName == null) {
            return shortcut;
        }
        return commandName + " (" + shortcut + ")";
    }

    @Nullable
    public static Command findCommand(@NotNull String commandId) {
        Command command;
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null && (command = commandService.getCommand(commandId)) != null && command.isDefined()) {
            return command;
        }
        return null;
    }

    public static void runCommand(String commandId, IServiceLocator serviceLocator) {
        ActionUtils.runCommand(commandId, null, serviceLocator);
    }

    public static void runCommand(String commandId, ISelection selection, IServiceLocator serviceLocator) {
        ActionUtils.runCommand(commandId, selection, null, serviceLocator);
    }

    public static void runCommand(String commandId, ISelection selection, Map<String, Object> parameters, IServiceLocator serviceLocator) {
        if (commandId != null) {
            try {
                ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
                IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
                if (commandService != null) {
                    Command command = commandService.getCommand(commandId);
                    boolean needContextPatch = false;
                    if (selection != null) {
                        ISelection curSelection;
                        needContextPatch = true;
                        if (serviceLocator instanceof IWorkbenchPartSite && (curSelection = ((IWorkbenchSite)serviceLocator).getSelectionProvider().getSelection()) instanceof IStructuredSelection && selection instanceof IStructuredSelection && ((IStructuredSelection)curSelection).size() == ((IStructuredSelection)selection).size() && ((IStructuredSelection)curSelection).getFirstElement() == ((IStructuredSelection)selection).getFirstElement()) {
                            needContextPatch = false;
                        }
                    }
                    Parameterization[] parametrization = null;
                    if (!CommonUtils.isEmpty(parameters)) {
                        parametrization = new Parameterization[parameters.size()];
                        int paramIndex = 0;
                        for (Map.Entry<String, Object> param : parameters.entrySet()) {
                            IParameter parameter = command.getParameter(param.getKey());
                            if (parameter != null) {
                                parametrization[paramIndex] = new Parameterization(parameter, CommonUtils.toString((Object)param.getValue()));
                            } else {
                                log.debug((Object)("Parameter '" + param.getKey() + "' not found in command '" + commandId + "'"));
                                parametrization[paramIndex] = null;
                            }
                            ++paramIndex;
                        }
                    }
                    if (selection != null && needContextPatch) {
                        EvaluationContext context = new EvaluationContext(handlerService.createContextSnapshot(false), (Object)selection);
                        if (serviceLocator instanceof IWorkbenchPartSite) {
                            context.addVariable("activePart", (Object)((IWorkbenchPartSite)serviceLocator).getPart());
                        }
                        context.addVariable("selection", (Object)selection);
                        ParameterizedCommand pc = new ParameterizedCommand(command, parametrization);
                        handlerService.executeCommandInContext(pc, null, (IEvaluationContext)context);
                    } else if (command != null) {
                        if (command.isEnabled()) {
                            ParameterizedCommand pc = new ParameterizedCommand(command, parametrization);
                            handlerService.executeCommand(pc, null);
                        } else {
                            log.warn((Object)("Command '" + commandId + "' is disabled"));
                        }
                    } else {
                        log.warn((Object)("Command '" + commandId + "' not found"));
                    }
                }
            }
            catch (Exception e) {
                DBWorkbench.getPlatformUI().showError("Error running command", "Can't execute command '" + commandId + "'", (Throwable)e);
            }
        }
    }

    public static IAction makeAction(final @NotNull IActionDelegate actionDelegate, @Nullable IWorkbenchSite site, @Nullable ISelection selection, @Nullable String id, @Nullable String text, @Nullable ImageDescriptor image, @Nullable String toolTip) {
        Action actionImpl = new Action(){

            public void run() {
                actionDelegate.run((IAction)this);
            }
        };
        if (id != null) {
            actionImpl.setId(id);
        }
        if (text != null) {
            actionImpl.setText(text);
        }
        if (image != null) {
            actionImpl.setImageDescriptor(image);
        }
        if (toolTip != null) {
            actionImpl.setToolTipText(toolTip);
        }
        actionDelegate.selectionChanged((IAction)actionImpl, selection);
        if (site != null) {
            if (actionDelegate instanceof IObjectActionDelegate && site instanceof IWorkbenchPartSite) {
                ((IObjectActionDelegate)actionDelegate).setActivePart((IAction)actionImpl, ((IWorkbenchPartSite)site).getPart());
            } else if (actionDelegate instanceof IWorkbenchWindowActionDelegate) {
                ((IWorkbenchWindowActionDelegate)actionDelegate).init(site.getWorkbenchWindow());
            }
        }
        return actionImpl;
    }

    public static void evaluatePropertyState(String propertyName) {
        IEvaluationService service = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (service != null) {
            try {
                service.requestEvaluation(propertyName);
            }
            catch (Exception exception) {
                log.warn((Object)("Error evaluating property [" + propertyName + "]"));
            }
        }
        PropertyChangeEvent ev = new PropertyChangeEvent((Object)service, propertyName, null, null);
        for (IPropertyChangeListener listener : List.copyOf(propertyEvaluationRequestListeners)) {
            listener.propertyChange(ev);
        }
    }

    public static void fireCommandRefresh(String ... commandIDs) {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (commandService != null) {
            UIUtils.asyncExec(() -> {
                String[] stringArray2 = commandIDs;
                int n = commandIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    String commandID = stringArray2[n2];
                    commandService.refreshElements(commandID, null);
                    ++n2;
                }
            });
        }
    }

    @Nullable
    public static Point getLocationFromControl(@NotNull Shell activeShell, @NotNull Control focusControl) {
        Point location = null;
        Display display = activeShell.getDisplay();
        if (focusControl instanceof Table) {
            Table table = (Table)focusControl;
            int selectionIndex = table.getSelectionIndex();
            if (selectionIndex < 0) {
                location = display.map(focusControl, null, table.getLocation());
            } else {
                Rectangle absBounds = display.map(focusControl, null, table.getItem(selectionIndex).getBounds());
                location = new Point(absBounds.x, absBounds.y + table.getItemHeight());
            }
        } else if (focusControl instanceof Tree) {
            Tree tree = (Tree)focusControl;
            Object[] selection = tree.getSelection();
            if (ArrayUtils.isEmpty((Object[])selection)) {
                location = display.map(focusControl, null, tree.getLocation());
            } else {
                Rectangle absBounds = display.map(focusControl, null, selection[0].getBounds());
                location = new Point(absBounds.x, absBounds.y + tree.getItemHeight());
            }
        } else if (focusControl instanceof StyledText) {
            StyledText styledText = (StyledText)focusControl;
            int caretOffset = styledText.getCaretOffset();
            location = styledText.getLocationAtOffset(caretOffset);
            location = display.map((Control)styledText, null, location);
            location.y += styledText.getLineHeight();
        }
        return location;
    }

    @NotNull
    public static String getLabelWithIndexMnemonic(@NotNull String label, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("negative index: " + index);
        }
        if (index < 10) {
            return String.format("&%d. %s", index < 9 ? index + 1 : 0, label);
        }
        if (index < 36) {
            return String.format("&%c. %s", index - 10 + 65, label);
        }
        return label;
    }
}

