/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.sql.script;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithResource;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.rm.RMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.ui.sql.script.SQLScriptTaskConfigurationWizard;
import org.jkiss.dbeaver.tasks.ui.sql.script.SQLScriptTaskDataSourceSelectorDialog;
import org.jkiss.dbeaver.tasks.ui.sql.script.SQLScriptTaskScriptSelectorDialog;
import org.jkiss.dbeaver.tools.sql.SQLScriptExecuteSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ListContentProvider;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

class SQLScriptTaskPageSettings
extends ActiveWizardPage<SQLScriptTaskConfigurationWizard> {
    private static final Log log = Log.getLog(SQLScriptTaskPageSettings.class);
    private final SQLScriptTaskConfigurationWizard sqlWizard;
    private Button ignoreErrorsCheck;
    private Button dumpQueryCheck;
    private Button autoCommitCheck;
    private TableViewer scriptsViewer;
    private TableViewer dataSourceViewer;
    private final List<DBNNodeWithResource> selectedScripts = new ArrayList<DBNNodeWithResource>();
    private final List<DBNDataSource> selectedDataSources = new ArrayList<DBNDataSource>();

    SQLScriptTaskPageSettings(SQLScriptTaskConfigurationWizard wizard) {
        super(DTMessages.sql_script_task_title);
        this.setTitle(DTMessages.sql_script_task_page_settings_title);
        this.setDescription(DTMessages.sql_script_task_page_settings_description);
        this.sqlWizard = wizard;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        composite.setLayoutData((Object)new GridData(1808));
        SQLScriptExecuteSettings dtSettings = ((SQLScriptTaskConfigurationWizard)this.getWizard()).getSettings();
        SashForm mainGroup = new SashForm(composite, 0);
        mainGroup.setSashWidth(5);
        mainGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        final DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(this.sqlWizard.getProject());
        Group filesGroup = UIUtils.createControlGroup((Composite)mainGroup, (String)DTMessages.sql_script_task_page_settings_group_files, (int)2, (int)1808, (int)0);
        this.scriptsViewer = new TableViewer((Composite)filesGroup, 67586);
        this.scriptsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.scriptsViewer.getTable().setHeaderVisible(true);
        this.scriptsViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            /*
             * WARNING - void declaration
             */
            public String getText(Object element) {
                Object object = element;
                if (object instanceof DBNPathBase) {
                    void path;
                    DBNPathBase dBNPathBase = (DBNPathBase)object;
                    DBNPathBase cfr_ignored_0 = (DBNPathBase)object;
                    return path.getPath().toString();
                }
                return ((DBNNodeWithResource)element).getResource().getProjectRelativePath().toString();
            }

            public Image getImage(Object element) {
                DBPImage icon;
                DBNNode node = (DBNNode)element;
                DBNNode dBNNode = node;
                if (dBNNode instanceof DBNPathBase) {
                    DBNPathBase dBNPathBase = (DBNPathBase)dBNNode;
                    DBNPathBase cfr_ignored_0 = (DBNPathBase)dBNNode;
                    icon = DBIcon.TREE_SCRIPT;
                } else {
                    icon = node.getNodeIconDefault();
                }
                return DBeaverIcons.getImage((DBPImage)icon);
            }
        });
        this.scriptsViewer.addDoubleClickListener(event -> {
            DBPResourceHandler handler;
            StructuredSelection selection = (StructuredSelection)event.getSelection();
            IResource resource = ((DBNNodeWithResource)selection.getFirstElement()).getResource();
            if (resource != null && (handler = DBPPlatformDesktop.getInstance().getWorkspace().getResourceHandler(resource)) != null) {
                try {
                    handler.openResource(resource);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to open resource " + String.valueOf(resource)), (Throwable)e);
                }
            }
        });
        SQLScriptTaskScriptSelectorDialog.createScriptColumns((ColumnViewer)this.scriptsViewer);
        final Table scriptTable = this.scriptsViewer.getTable();
        scriptTable.setLayoutData((Object)new GridData(1808));
        ToolBar buttonsToolbar = new ToolBar((Composite)filesGroup, 512);
        buttonsToolbar.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)DTUIMessages.sql_script_task_page_settings_tool_item_text_add_script, (DBPImage)UIIcon.ROW_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLScriptTaskScriptSelectorDialog dialog = new SQLScriptTaskScriptSelectorDialog(SQLScriptTaskPageSettings.this.getShell(), projectNode);
                if (dialog.open() == 0) {
                    for (DBNNodeWithResource script : dialog.getSelectedScripts()) {
                        if (SQLScriptTaskPageSettings.this.selectedScripts.contains(script)) continue;
                        SQLScriptTaskPageSettings.this.selectedScripts.add(script);
                    }
                    SQLScriptTaskPageSettings.this.refreshScripts();
                }
            }
        });
        if (DBFUtils.supportsMultiFileSystems((DBPProject)this.sqlWizard.getProject())) {
            UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)UIMessages.text_with_open_dialog_browse_remote, (DBPImage)UIIcon.OPEN_EXTERNAL, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DBNPathBase selected = DBWorkbench.getPlatformUI().openFileSystemSelector(UIMessages.text_with_open_dialog_browse_remote, false, 4096, false, new String[]{"*.sql", "*"}, null);
                    if (selected != null) {
                        if (!SQLScriptTaskPageSettings.this.selectedScripts.contains(selected)) {
                            SQLScriptTaskPageSettings.this.selectedScripts.add((DBNNodeWithResource)selected);
                        }
                        SQLScriptTaskPageSettings.this.refreshScripts();
                    }
                }
            });
        }
        ToolItem deleteItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)DTUIMessages.sql_script_task_page_settings_tool_item_text_remove_script, (DBPImage)UIIcon.ROW_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = SQLScriptTaskPageSettings.this.scriptsViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    Object[] objectArray = ((IStructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof DBNNodeWithResource) {
                            SQLScriptTaskPageSettings.this.selectedScripts.remove(element);
                        }
                        ++n2;
                    }
                    SQLScriptTaskPageSettings.this.refreshScripts();
                }
            }
        });
        UIUtils.createToolBarSeparator((ToolBar)buttonsToolbar, (int)256);
        ToolItem moveUpItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)DTUIMessages.sql_script_task_page_settings_tool_item_text_move_script_up, (DBPImage)UIIcon.ARROW_UP, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = scriptTable.getSelectionIndex();
                if (selectionIndex > 0) {
                    DBNNodeWithResource prevScript = SQLScriptTaskPageSettings.this.selectedScripts.get(selectionIndex - 1);
                    SQLScriptTaskPageSettings.this.selectedScripts.set(selectionIndex - 1, SQLScriptTaskPageSettings.this.selectedScripts.get(selectionIndex));
                    SQLScriptTaskPageSettings.this.selectedScripts.set(selectionIndex, prevScript);
                    SQLScriptTaskPageSettings.this.refreshScripts();
                }
            }
        });
        ToolItem moveDownItem = UIUtils.createToolItem((ToolBar)buttonsToolbar, (String)DTUIMessages.sql_script_task_page_settings_tool_item_text_move_script_down, (DBPImage)UIIcon.ARROW_DOWN, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = scriptTable.getSelectionIndex();
                if (selectionIndex < scriptTable.getItemCount() - 1) {
                    DBNNodeWithResource nextScript = SQLScriptTaskPageSettings.this.selectedScripts.get(selectionIndex + 1);
                    SQLScriptTaskPageSettings.this.selectedScripts.set(selectionIndex + 1, SQLScriptTaskPageSettings.this.selectedScripts.get(selectionIndex));
                    SQLScriptTaskPageSettings.this.selectedScripts.set(selectionIndex, nextScript);
                    SQLScriptTaskPageSettings.this.refreshScripts();
                }
            }
        });
        this.scriptsViewer.addSelectionChangedListener(event -> {
            int selectionIndex = scriptTable.getSelectionIndex();
            deleteItem.setEnabled(selectionIndex >= 0);
            moveUpItem.setEnabled(selectionIndex > 0);
            moveDownItem.setEnabled(selectionIndex < scriptTable.getItemCount() - 1);
        });
        deleteItem.setEnabled(false);
        Group connectionsGroup = UIUtils.createControlGroup((Composite)mainGroup, (String)DTMessages.sql_script_task_page_settings_group_connections, (int)2, (int)1808, (int)0);
        this.dataSourceViewer = new TableViewer((Composite)connectionsGroup, 67586);
        this.dataSourceViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.dataSourceViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((DBNDataSource)element).getNodeName();
            }

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)((DBNDataSource)element).getNodeIcon());
            }
        });
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.dataSourceViewer.getTable().setLayoutData((Object)gd);
        final Table dsTable = this.dataSourceViewer.getTable();
        dsTable.setLayoutData((Object)new GridData(1808));
        ToolBar buttonsToolbar2 = new ToolBar((Composite)connectionsGroup, 512);
        buttonsToolbar2.setLayoutData((Object)new GridData(2));
        UIUtils.createToolItem((ToolBar)buttonsToolbar2, (String)DTUIMessages.sql_script_task_page_settings_tool_item_text_add_data_source, (DBPImage)UIIcon.ROW_ADD, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLScriptTaskDataSourceSelectorDialog dialog = new SQLScriptTaskDataSourceSelectorDialog(SQLScriptTaskPageSettings.this.getShell(), projectNode);
                if (dialog.open() == 0) {
                    for (DBNDataSource ds : dialog.getSelectedDataSources()) {
                        if (SQLScriptTaskPageSettings.this.selectedDataSources.contains(ds)) continue;
                        SQLScriptTaskPageSettings.this.selectedDataSources.add(ds);
                    }
                    SQLScriptTaskPageSettings.this.refreshDataSources();
                    SQLScriptTaskPageSettings.this.updatePageCompletion();
                }
            }
        });
        ToolItem deleteItem2 = UIUtils.createToolItem((ToolBar)buttonsToolbar2, (String)DTUIMessages.sql_script_task_page_settings_tool_item_text_remove_data_source, (DBPImage)UIIcon.ROW_DELETE, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = SQLScriptTaskPageSettings.this.dataSourceViewer.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                    Object[] objectArray = ((IStructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof DBNDataSource) {
                            SQLScriptTaskPageSettings.this.selectedDataSources.remove(element);
                        }
                        ++n2;
                    }
                    SQLScriptTaskPageSettings.this.refreshDataSources();
                    SQLScriptTaskPageSettings.this.updatePageCompletion();
                }
            }
        });
        UIUtils.createToolBarSeparator((ToolBar)buttonsToolbar2, (int)256);
        ToolItem moveUpItem2 = UIUtils.createToolItem((ToolBar)buttonsToolbar2, (String)DTUIMessages.sql_script_task_page_settings_tool_item_text_move_data_source_up, (DBPImage)UIIcon.ARROW_UP, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = dsTable.getSelectionIndex();
                if (selectionIndex > 0) {
                    DBNDataSource prevScript = SQLScriptTaskPageSettings.this.selectedDataSources.get(selectionIndex - 1);
                    SQLScriptTaskPageSettings.this.selectedDataSources.set(selectionIndex - 1, SQLScriptTaskPageSettings.this.selectedDataSources.get(selectionIndex));
                    SQLScriptTaskPageSettings.this.selectedDataSources.set(selectionIndex, prevScript);
                    SQLScriptTaskPageSettings.this.refreshDataSources();
                }
            }
        });
        ToolItem moveDownItem2 = UIUtils.createToolItem((ToolBar)buttonsToolbar2, (String)DTUIMessages.sql_script_task_page_settings_tool_item_text_move_data_source_down, (DBPImage)UIIcon.ARROW_DOWN, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = dsTable.getSelectionIndex();
                if (selectionIndex < dsTable.getItemCount() - 1) {
                    DBNDataSource nextScript = SQLScriptTaskPageSettings.this.selectedDataSources.get(selectionIndex + 1);
                    SQLScriptTaskPageSettings.this.selectedDataSources.set(selectionIndex + 1, SQLScriptTaskPageSettings.this.selectedDataSources.get(selectionIndex));
                    SQLScriptTaskPageSettings.this.selectedDataSources.set(selectionIndex, nextScript);
                    SQLScriptTaskPageSettings.this.refreshScripts();
                }
            }
        });
        this.dataSourceViewer.addSelectionChangedListener(event -> {
            int selectionIndex = dsTable.getSelectionIndex();
            deleteItem2.setEnabled(selectionIndex >= 0);
            moveUpItem2.setEnabled(selectionIndex > 0);
            moveDownItem2.setEnabled(selectionIndex < dsTable.getItemCount() - 1);
        });
        deleteItem2.setEnabled(false);
        mainGroup.setWeights(new int[]{700, 300});
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)DTMessages.sql_script_task_page_settings_group_script, (int)3, (int)770, (int)0);
        this.ignoreErrorsCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)DTMessages.sql_script_task_page_settings_option_ignore_errors, (String)"", (boolean)dtSettings.isIgnoreErrors(), (int)1);
        this.dumpQueryCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)DTMessages.sql_script_task_page_settings_option_dump_results, (String)"", (boolean)dtSettings.isDumpQueryResultsToLog(), (int)1);
        this.autoCommitCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)DTMessages.sql_script_task_page_settings_option_auto_commit, (String)"", (boolean)dtSettings.isAutoCommit(), (int)1);
        ((SQLScriptTaskConfigurationWizard)this.getWizard()).createVariablesEditButton(composite);
        try {
            ((SQLScriptTaskConfigurationWizard)this.getWizard()).getContainer().run(true, true, monitor -> {
                try {
                    this.loadSettings((DBRProgressMonitor)new DefaultProgressMonitor(monitor));
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage("Error loading settings: " + e.getTargetException().getMessage());
        }
        catch (InterruptedException interruptedException) {}
        this.setControl((Control)composite);
    }

    private void refreshScripts() {
        this.scriptsViewer.refresh(true, true);
        this.updateSelectedScripts();
    }

    private void refreshDataSources() {
        this.dataSourceViewer.refresh(true, true);
    }

    /*
     * WARNING - void declaration
     */
    private void updateSelectedScripts() {
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(this.sqlWizard.getProject());
        LinkedHashSet dataSources = new LinkedHashSet();
        for (DBNNodeWithResource element : this.selectedScripts) {
            void res;
            DBNNodeWithResource dBNNodeWithResource = element;
            if (!(dBNNodeWithResource instanceof DBNResource)) continue;
            DBNResource cfr_ignored_0 = (DBNResource)dBNNodeWithResource;
            DBNResource cfr_ignored_1 = (DBNResource)dBNNodeWithResource;
            Collection resDS = res.getAssociatedDataSources();
            if (CommonUtils.isEmpty((Collection)resDS)) continue;
            dataSources.addAll(resDS);
        }
        if (!dataSources.isEmpty()) {
            ArrayList<DBNDataSource> checkedDataSources = new ArrayList<DBNDataSource>();
            for (DBPDataSourceContainer ds : dataSources) {
                DBNDataSource dsNode = projectNode.getDatabases().getDataSource(ds);
                if (dsNode == null) continue;
                checkedDataSources.add(dsNode);
            }
            if (!checkedDataSources.isEmpty()) {
                this.refreshDataSources();
                for (DBNDataSource dsNode : checkedDataSources) {
                    if (this.selectedDataSources.contains(dsNode)) continue;
                    this.selectedDataSources.add(dsNode);
                }
            }
        }
        this.refreshDataSources();
        this.updatePageCompletion();
    }

    public void activatePage() {
        this.updatePageCompletion();
    }

    public void deactivatePage() {
    }

    protected boolean determinePageCompletion() {
        if (this.selectedScripts.isEmpty()) {
            this.setErrorMessage(DTUIMessages.sql_script_task_page_settings_error_message_you_must_select_script_execute);
            return false;
        }
        if (this.selectedDataSources.isEmpty()) {
            this.setErrorMessage(DTUIMessages.sql_script_task_page_settings_error_message_you_must_select_connection);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void loadSettings(DBRProgressMonitor monitor) throws DBException {
        SQLScriptExecuteSettings settings = this.sqlWizard.getSettings();
        DBPProject project = ((SQLScriptTaskConfigurationWizard)this.getWizard()).getProject();
        DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(project);
        if (projectNode != null) {
            List scriptFiles = settings.getScriptFiles();
            for (String filePath : scriptFiles) {
                DBNPathBase pathNode;
                if (IOUtils.isLocalFile((String)filePath)) {
                    IFile workspaceFile = RMUtils.findEclipseProjectFile((DBPProject)project, (String)filePath);
                    if (workspaceFile == null) {
                        log.debug((Object)("Script file '" + filePath + "' not found"));
                        continue;
                    }
                    DBNResource resource = projectNode.findResource(monitor, (IResource)workspaceFile);
                    if (resource == null) continue;
                    this.selectedScripts.add((DBNNodeWithResource)resource);
                    continue;
                }
                DBNFileSystems fsNode = (DBNFileSystems)projectNode.getExtraNode(DBNFileSystems.class);
                if (fsNode == null || (pathNode = fsNode.findNodeByPath(monitor, filePath)) == null) continue;
                this.selectedScripts.add((DBNNodeWithResource)pathNode);
            }
        }
        for (DBPDataSourceContainer dataSource : settings.getDataSources()) {
            DBNDataSource dsNode = projectNode.getDatabases().getDataSource(dataSource);
            if (dsNode == null) continue;
            this.selectedDataSources.add(dsNode);
        }
        UIUtils.syncExec(() -> {
            this.scriptsViewer.setInput(this.selectedScripts);
            this.dataSourceViewer.setInput(this.selectedDataSources);
        });
    }

    public void saveSettings() {
        if (this.sqlWizard == null) {
            return;
        }
        SQLScriptExecuteSettings settings = this.sqlWizard.getSettings();
        ArrayList<String> scriptPaths = new ArrayList<String>();
        for (DBNNodeWithResource resource : this.selectedScripts) {
            if (resource instanceof DBNPathBase) {
                scriptPaths.add(((DBNPathBase)resource).getPath().toString());
                continue;
            }
            IResource res = resource.getResource();
            if (!(res instanceof IFile)) continue;
            scriptPaths.add(((SQLScriptTaskConfigurationWizard)this.getWizard()).getProject().getResourcePath(res));
        }
        if (!CommonUtils.isEmpty(scriptPaths)) {
            settings.setScriptFiles(scriptPaths);
        }
        ArrayList<DBPDataSourceContainer> dsList = new ArrayList<DBPDataSourceContainer>();
        for (DBNDataSource dsNode : this.selectedDataSources) {
            dsList.add(dsNode.getDataSourceContainer());
        }
        if (!CommonUtils.isEmpty(dsList)) {
            settings.setDataSources(dsList);
        }
        if (this.ignoreErrorsCheck != null) {
            settings.setIgnoreErrors(this.ignoreErrorsCheck.getSelection());
        }
        if (this.dumpQueryCheck != null) {
            settings.setDumpQueryResultsToLog(this.dumpQueryCheck.getSelection());
        }
        if (this.autoCommitCheck != null) {
            settings.setAutoCommit(this.autoCommitCheck.getSelection());
        }
    }
}

