/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.AuthModelPgPassCredentials;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class AuthModelPgPass
extends AuthModelDatabaseNative<AuthModelPgPassCredentials> {
    private static final Log log = Log.getLog(AuthModelPgPass.class);
    public static final String PGPASSFILE_ENV_VARIABLE = "PGPASSFILE";

    @NotNull
    public AuthModelPgPassCredentials createCredentials() {
        return new AuthModelPgPassCredentials();
    }

    @NotNull
    public AuthModelPgPassCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelPgPassCredentials credentials = (AuthModelPgPassCredentials)super.loadCredentials(dataSource, configuration);
        try {
            this.loadPasswordFromPgPass(credentials, dataSource, configuration);
            credentials.setParseError(null);
        }
        catch (DBException e) {
            credentials.setParseError((Exception)((Object)e));
        }
        return credentials;
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelPgPassCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        if (credentials.getParseError() != null) {
            throw new DBCException("Couldn't get password from PGPASS file", (Throwable)credentials.getParseError());
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connectProps);
    }

    private String getSSHHost(@NotNull DBPDataSourceContainer dataSourceContainer) {
        Object host;
        DBWHandlerConfiguration sshHandler = dataSourceContainer.getActualConnectionConfiguration().getHandler("ssh_tunnel");
        if (sshHandler != null && (host = sshHandler.getProperty("host")) != null) {
            return (String)host;
        }
        return null;
    }

    private void loadPasswordFromPgPass(AuthModelPgPassCredentials credentials, DBPDataSourceContainer dataSource, DBPConnectionConfiguration configuration) throws DBException {
        File pgPassFile;
        Object pgPassPath;
        String providerProperty;
        DBPConnectionConfiguration originalConfiguration = dataSource.getConnectionConfiguration();
        String conHostName = originalConfiguration.getHostName();
        String sshHost = null;
        if (CommonUtils.isEmpty((String)conHostName) || conHostName.equals("localhost") || conHostName.equals("127.0.0.1")) {
            sshHost = this.getSSHHost(dataSource);
        }
        if (!CommonUtils.isEmpty((String)(providerProperty = dataSource.getConnectionConfiguration().getProviderProperty("overriddenUsername")))) {
            sshHost = providerProperty;
        }
        if (CommonUtils.isEmpty((String)(pgPassPath = System.getenv(PGPASSFILE_ENV_VARIABLE)))) {
            if (RuntimeUtils.isWindows()) {
                String appData = System.getenv("AppData");
                if (appData == null) {
                    appData = System.getProperty("user.home");
                }
                pgPassPath = appData + "/postgresql/pgpass.conf";
            } else {
                pgPassPath = System.getProperty("user.home") + "/.pgpass";
            }
        }
        if (!(pgPassFile = new File((String)pgPassPath)).exists()) {
            throw new DBException("PgPass file '" + pgPassFile.getAbsolutePath() + "' not found");
        }
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(pgPassFile), GeneralUtils.UTF8_CHARSET);){
                String passString = IOUtils.readToString((Reader)r);
                String[] lines = passString.split("\n");
                if (this.findHostCredentials(credentials, configuration, dataSource, sshHost, lines)) {
                    return;
                }
                if (this.findHostCredentials(credentials, configuration, dataSource, conHostName, lines)) {
                    return;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("Error reading pgpass", (Throwable)e);
        }
        throw new DBException("No matches in pgpass");
    }

    private boolean findHostCredentials(@NotNull AuthModelPgPassCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull DBPDataSourceContainer dataSourceContainer, @Nullable String hostName, @NotNull String[] lines) {
        if (hostName == null) {
            return false;
        }
        DBPConnectionConfiguration originalConfiguration = dataSourceContainer.getConnectionConfiguration();
        String conHostPort = originalConfiguration.getHostPort();
        String conDatabaseName = originalConfiguration.getDatabaseName();
        String conUserName = originalConfiguration.getUserName();
        if (CommonUtils.isEmpty((String)conHostPort)) {
            conHostPort = dataSourceContainer.getDriver().getDefaultPort();
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] params;
            String line = stringArray[n2];
            if (!(line = line.trim()).isEmpty() && !line.startsWith("#") && (params = AuthModelPgPass.splitPassLine(line)) != null) {
                String host = params[0];
                String port = params[1];
                String database = params[2];
                String user = params[3];
                String password = params[4];
                if (AuthModelPgPass.matchParam(hostName, host) && AuthModelPgPass.matchParam(conHostPort, port) && AuthModelPgPass.matchParam(conDatabaseName, database)) {
                    if (CommonUtils.isEmpty((String)conUserName)) {
                        credentials.setUserName(user);
                        credentials.setUserPassword(password);
                        return true;
                    }
                    if (AuthModelPgPass.matchParam(conUserName, user)) {
                        if (!user.equals("*")) {
                            configuration.setUserName(user);
                        }
                        credentials.setUserPassword(password);
                        return true;
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    @Nullable
    private static String[] splitPassLine(String line) {
        String[] params = (line = line.replace("\\\\", "@BSESC@").replace("\\:", "@CESC@")).split(":");
        if (params.length < 5) {
            return null;
        }
        int i = 0;
        while (i < params.length) {
            params[i] = params[i].replace("@CESC@", ":").replace("@BSESC@", "\\");
            ++i;
        }
        return params;
    }

    private static boolean matchParam(String cfgParam, String passParam) {
        return passParam.equals("*") || passParam.equalsIgnoreCase(cfgParam);
    }
}

