/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJob;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJobStep;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class PostgreJobStepManager
extends SQLObjectEditor<PostgreJobStep, PostgreJob>
implements DBEObjectRenamer<PostgreJobStep> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, PostgreJobStep> getObjectsCache(PostgreJobStep object) {
        return object.getParentObject().getStepCache();
    }

    protected PostgreJobStep createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        PostgreJob job = (PostgreJob)container;
        String name = DBUtils.makeNewObjectName((DBRProgressMonitor)monitor, (String)"Step{0}", (DBSObject)job, PostgreJobStep.class, PostgreJob::getStep, (DBECommandContext)context);
        return new PostgreJobStep(job, name);
    }

    protected void validateObjectProperties(DBRProgressMonitor monitor, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        PostgreJobStep step = (PostgreJobStep)command.getObject();
        if (step.getKind() == PostgreJobStep.StepKind.s && step.getTargetDatabase() == null && CommonUtils.isEmptyTrimmed((String)step.getRemoteConnectionString())) {
            throw new DBException("Target database or remote connection string must be set when step kind is 'SQL'");
        }
        if (!(step.getKind() != PostgreJobStep.StepKind.b || step.getTargetDatabase() == null && CommonUtils.isEmptyTrimmed((String)step.getRemoteConnectionString()))) {
            throw new DBException("Target database or remote connection string must not be set when step kind is 'Batch'");
        }
        if (CommonUtils.isEmptyTrimmed((String)step.getObjectDefinitionText(monitor, options))) {
            throw new DBException("Code must not be empty");
        }
    }

    protected StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, PostgreJob owner, DBECommandAbstract<PostgreJobStep> command, Map<String, Object> options) {
        return new StringBuilder(this.getCreateDDL(monitor, (PostgreJobStep)command.getObject(), options, true));
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create step", this.getCreateDDL(monitor, (PostgreJobStep)command.getObject(), options, false)));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        PostgreJobStep step = (PostgreJobStep)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Delete step", "DELETE FROM pgagent.pga_jobstep\nWHERE jstid=" + step.getObjectId()));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        PostgreJobStep step = (PostgreJobStep)command.getObject();
        StringJoiner values = new StringJoiner(",\n\t");
        if (command.hasProperty((Object)"description")) {
            values.add("jstdesc=" + SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)CommonUtils.notEmpty((String)step.getDescription())));
        }
        if (command.getProperty((Object)"kind") != null) {
            values.add("jstkind=" + SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)step.getKind().name()));
        }
        if (command.getProperty((Object)"onError") != null) {
            values.add("jstonerror=" + SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)step.getOnError().name()));
        }
        if (command.hasProperty((Object)"remoteConnectionString")) {
            values.add("jstconnstr=" + SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)CommonUtils.notEmpty((String)step.getRemoteConnectionString())));
        }
        if (command.hasProperty((Object)"targetDatabase")) {
            values.add("jstdbname=" + SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)(step.getTargetDatabase() == null ? "" : step.getTargetDatabase().getName())));
        }
        if (command.getProperty((Object)"enabled") != null) {
            values.add("jstenabled=" + step.isEnabled());
        }
        if (command.getProperty((Object)"objectDefinitionText") != null) {
            values.add("jstcode=" + SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)step.getObjectDefinitionText(monitor, options)));
        }
        if (values.length() > 0) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter step", "UPDATE pgagent.pga_jobstep\nSET\n\t" + String.valueOf(values) + "\nWHERE jstid=" + step.getObjectId()));
        }
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        PostgreJobStep step = (PostgreJobStep)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename step", "UPDATE pgagent.pga_jobstep\nSET\n\tjstname=" + SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)command.getNewName()) + "\nWHERE jstid=" + step.getObjectId()));
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull PostgreJobStep object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, object, options, newName);
    }

    @NotNull
    private String getCreateDDL(@NotNull DBRProgressMonitor monitor, @NotNull PostgreJobStep step, @NotNull Map<String, Object> options, boolean nested) {
        StringJoiner values = new StringJoiner(", ", "(", ")");
        values.add(nested ? "(SELECT jobid FROM job)" : String.valueOf(step.getParentObject().getObjectId()));
        values.add(SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)step.getName()));
        values.add(SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)step.getDescription()));
        values.add(String.valueOf(step.isEnabled()));
        values.add(SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)step.getKind().name()));
        values.add(SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)step.getOnError().name()));
        values.add(SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)step.getObjectDefinitionText(monitor, options)));
        values.add(SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)step.getRemoteConnectionString()));
        values.add(SQLUtils.quoteString((DBPDataSource)step.getDataSource(), (String)(step.getTargetDatabase() == null ? "" : step.getTargetDatabase().getName())));
        return "INSERT INTO pgagent.pga_jobstep (jstjobid, jstname, jstdesc, jstenabled, jstkind, jstonerror, jstcode, jstconnstr, jstdbname)\nVALUES " + String.valueOf(values);
    }
}

