/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql;

import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.postgresql.PostgreValueParser;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreCommandGrantPrivilege;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreViewManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDefaultPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreViewBase;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerType;
import org.jkiss.dbeaver.ext.postgresql.model.impls.PostgreServerTypeRegistry;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.exec.JDBCColumnMetaData;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class PostgreUtils {
    private static final Log log = Log.getLog(PostgreUtils.class);
    private static final int UNKNOWN_LENGTH = -1;

    public static String getObjectComment(DBRProgressMonitor monitor, GenericStructContainer container, String schema, String object) throws DBException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)container, (String)"Load PostgreSQL description");){
                return JDBCUtils.queryString((Connection)session, (String)"select description from pg_catalog.pg_description\njoin pg_catalog.pg_class on pg_description.objoid = pg_class.oid\njoin pg_catalog.pg_namespace on pg_class.relnamespace = pg_namespace.oid\nwhere pg_class.relname = ? and pg_namespace.nspname=?", (Object[])new Object[]{object, schema});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            return null;
        }
    }

    public static String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return "bool";
            }
            case NUMERIC: {
                return "int";
            }
            case STRING: {
                return "varchar";
            }
            case DATETIME: {
                return "timestamp";
            }
            case BINARY: {
                return "bytea";
            }
            case CONTENT: {
                return "bytea";
            }
            case ROWID: {
                return "oid";
            }
        }
        return "varchar";
    }

    public static <T extends PostgreAttribute> T getAttributeByNum(Collection<T> attrs, int attNum) {
        for (PostgreAttribute attr : attrs) {
            if (attr.getOrdinalPosition() != attNum) continue;
            return (T)attr;
        }
        return null;
    }

    public static boolean isPGObject(Object object) {
        if (object == null) {
            return false;
        }
        String className = object.getClass().getName();
        return className.equals("org.postgresql.util.PGobject") || className.equals("com.amazon.redshift.util.RedshiftObject") || className.equals("com.edb.util.PGobject");
    }

    public static Object extractPGObjectValue(Object pgObject) {
        if (pgObject == null) {
            return null;
        }
        if (!PostgreUtils.isPGObject(pgObject)) {
            return pgObject;
        }
        try {
            return pgObject.getClass().getMethod("getValue", new Class[0]).invoke(pgObject, new Object[0]);
        }
        catch (Exception e) {
            log.debug((Object)("Can't extract value from " + pgObject.getClass().getName()), (Throwable)e);
            return null;
        }
    }

    public static boolean supportsTypeCategory(JDBCDataSource dataSource) {
        return dataSource.isServerVersionAtLeast(8, 4);
    }

    @Nullable
    public static <OWNER extends DBSObject, OBJECT extends PostgreObject> OBJECT getObjectById(@NotNull DBRProgressMonitor monitor, @NotNull AbstractObjectCache<OWNER, OBJECT> cache, @NotNull OWNER owner, long objectId) throws DBException {
        for (PostgreObject object : cache.getAllObjects(monitor, owner)) {
            if (object.getObjectId() != objectId) continue;
            return (OBJECT)object;
        }
        return null;
    }

    public static long[] getIdVector(Object pgObject) {
        Object pgVector = PostgreUtils.extractPGObjectValue(pgObject);
        if (pgVector == null) {
            return null;
        }
        if (pgVector instanceof String) {
            String vector = (String)pgVector;
            if (vector.isEmpty()) {
                return null;
            }
            String[] strings = vector.split(" ");
            long[] ids = new long[strings.length];
            int i = 0;
            while (i < strings.length) {
                ids[i] = Long.parseLong(strings[i]);
                ++i;
            }
            return ids;
        }
        if (pgVector instanceof long[]) {
            return (long[])pgVector;
        }
        if (pgVector instanceof Long[]) {
            Long[] objVector = (Long[])pgVector;
            long[] result = new long[objVector.length];
            int i = 0;
            while (i < objVector.length) {
                result[i] = objVector[i];
                ++i;
            }
            return result;
        }
        if (pgVector instanceof Number) {
            return new long[]{((Number)pgVector).longValue()};
        }
        throw new IllegalArgumentException("Unsupported vector type: " + pgVector.getClass().getName());
    }

    public static int[] getIntVector(Object pgObject) {
        Object pgVector = PostgreUtils.extractPGObjectValue(pgObject);
        if (pgVector == null) {
            return null;
        }
        if (pgVector instanceof String) {
            String vector = (String)pgVector;
            if (vector.isEmpty()) {
                return null;
            }
            String[] strings = vector.split(" ");
            int[] ids = new int[strings.length];
            int i = 0;
            while (i < strings.length) {
                ids[i] = Integer.parseInt(strings[i]);
                ++i;
            }
            return ids;
        }
        if (pgVector instanceof int[]) {
            return (int[])pgVector;
        }
        if (pgVector instanceof Integer[]) {
            Integer[] objVector = (Integer[])pgVector;
            int[] result = new int[objVector.length];
            int i = 0;
            while (i < objVector.length) {
                result[i] = objVector[i];
                ++i;
            }
            return result;
        }
        if (pgVector instanceof Number) {
            return new int[]{((Number)pgVector).intValue()};
        }
        if (pgVector instanceof java.sql.Array) {
            Object array;
            block16: {
                array = ((java.sql.Array)pgVector).getArray();
                if (array != null) break block16;
                return null;
            }
            try {
                int length = Array.getLength(array);
                int[] result = new int[length];
                int i = 0;
                while (i < length) {
                    Object item = Array.get(array, i);
                    if (item instanceof Number) {
                        result[i] = ((Number)item).intValue();
                    } else if (item != null) {
                        throw new IllegalArgumentException("Bad array item type: " + item.getClass().getName());
                    }
                    ++i;
                }
                return result;
            }
            catch (SQLException sQLException) {
                throw new IllegalArgumentException("Error reading array value: " + String.valueOf(pgVector));
            }
        }
        throw new IllegalArgumentException("Unsupported vector type: " + pgVector.getClass().getName());
    }

    public static int getAttributePrecision(long typeOid, int typeMod) {
        switch ((int)typeOid) {
            case 21: {
                return 5;
            }
            case 23: 
            case 26: {
                return 10;
            }
            case 20: {
                return 19;
            }
            case 700: {
                return 8;
            }
            case 701: {
                return 17;
            }
            case 1700: {
                if (typeMod == -1) {
                    return 0;
                }
                return (typeMod - 4 & 0xFFFF0000) >> 16;
            }
            case 16: 
            case 18: {
                return 1;
            }
            case 1042: 
            case 1043: {
                if (typeMod == -1) {
                    return -1;
                }
                return typeMod - 4;
            }
            case 1082: 
            case 1083: 
            case 1114: 
            case 1184: 
            case 1186: 
            case 1266: {
                return PostgreUtils.getDisplaySize(typeOid, typeMod);
            }
            case 1560: {
                return typeMod;
            }
            case 1562: {
                if (typeMod == -1) {
                    return -1;
                }
                return typeMod;
            }
        }
        return -1;
    }

    public static int getDisplaySize(long oid, int typmod) {
        switch ((int)oid) {
            case 21: {
                return 6;
            }
            case 23: {
                return 11;
            }
            case 26: {
                return 10;
            }
            case 20: {
                return 20;
            }
            case 700: {
                return 15;
            }
            case 701: {
                return 25;
            }
            case 18: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 1082: {
                return 13;
            }
            case 1083: 
            case 1114: 
            case 1184: 
            case 1266: {
                int secondSize = switch (typmod) {
                    case -1 -> 7;
                    case 0 -> 0;
                    case 1 -> 3;
                    default -> typmod + 1;
                };
                switch ((int)oid) {
                    case 1083: {
                        return 8 + secondSize;
                    }
                    case 1266: {
                        return 8 + secondSize + 6;
                    }
                    case 1114: {
                        return 22 + secondSize;
                    }
                    case 1184: {
                        return 22 + secondSize + 6;
                    }
                }
            }
            case 1186: {
                return 49;
            }
            case 1042: 
            case 1043: {
                if (typmod == -1) {
                    return -1;
                }
                return typmod - 4;
            }
            case 1700: {
                if (typmod == -1) {
                    return 131089;
                }
                int precision = typmod - 4 >> 16 & 0xFFFF;
                int scale = typmod - 4 & 0xFFFF;
                return 1 + precision + (scale != 0 ? 1 : 0);
            }
            case 1560: {
                return typmod;
            }
            case 1562: {
                if (typmod == -1) {
                    return -1;
                }
                return typmod;
            }
            case 17: 
            case 25: {
                return -1;
            }
        }
        return -1;
    }

    public static PostgreDataType findDataType(DBCSession session, PostgreDataSource dataSource, DBSTypedObject type) throws DBCException {
        PostgreDataType localDataType;
        if (type instanceof PostgreDataType) {
            return (PostgreDataType)type;
        }
        if (type instanceof PostgreAttribute) {
            return ((PostgreAttribute)type).getDataType();
        }
        DBRProgressMonitor monitor = session.getProgressMonitor();
        if (type instanceof JDBCColumnMetaData) {
            try {
                DBCEntityMetaData entityMetaData = ((DBCAttributeMetaData)type).getEntityMetaData();
                if (entityMetaData != null) {
                    DBSDataType dataType;
                    DBSEntityAttribute attribute;
                    DBSEntity docEntity = DBUtils.getEntityFromMetaData((DBRProgressMonitor)monitor, (DBCExecutionContext)session.getExecutionContext(), (DBCEntityMetaData)entityMetaData);
                    if (docEntity != null && (attribute = docEntity.getAttribute(monitor, ((DBCAttributeMetaData)type).getName())) instanceof DBSTypedObjectEx && (dataType = ((DBSTypedObjectEx)attribute).getDataType()) instanceof PostgreDataType) {
                        return (PostgreDataType)dataType;
                    }
                } else {
                    String databaseName = ((JDBCColumnMetaData)type).getCatalogName();
                    PostgreDatabase database = dataSource.getDatabase(databaseName);
                    if (database != null) {
                        PostgreDataType dataType;
                        Object[] identifiers;
                        Object typeName = type.getTypeName();
                        if (PostgreUtils.isCompositeTypeName((String)typeName) && !ArrayUtils.isEmpty((Object[])(identifiers = SQLUtils.splitFullIdentifier((String)typeName, (String)".", (String[][])dataSource.getSQLDialect().getIdentifierQuoteStrings(), (boolean)false)))) {
                            PostgreDataType dataType2;
                            Object schemaName;
                            PostgreSchema schema;
                            typeName = identifiers[identifiers.length - 1];
                            if (identifiers.length == 2 && (schema = database.getSchema(monitor, (String)(schemaName = identifiers[0]))) != null && (dataType2 = (PostgreDataType)schema.getDataTypeCache().getObject(monitor, schema, (String)typeName)) != null) {
                                return dataType2;
                            }
                        }
                        if ((dataType = database.getDataType(monitor, (String)typeName)) != null) {
                            return dataType;
                        }
                    }
                }
            }
            catch (DBException e) {
                throw new DBCException("Error extracting column " + String.valueOf(type) + " data type", (Throwable)e);
            }
        }
        String typeName = type.getTypeName();
        DBSInstance ownerInstance = session.getExecutionContext().getOwnerInstance();
        if (ownerInstance instanceof PostgreDatabase && (localDataType = ((PostgreDatabase)ownerInstance).getDataType(monitor, typeName)) != null) {
            return localDataType;
        }
        return dataSource.getLocalDataType(typeName);
    }

    @Nullable
    public static PostgreDataType resolveTypeFullName(@NotNull DBRProgressMonitor monitor, @NotNull PostgreSchema schema, @NotNull String fullTypeName) throws DBException {
        return PostgreUtils.resolveTypeFullName(monitor, schema.getDataSource(), schema.getDatabase(), schema, fullTypeName);
    }

    @Nullable
    public static PostgreDataType resolveTypeFullName(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase database, @NotNull String fullTypeName) throws DBException {
        return PostgreUtils.resolveTypeFullName(monitor, database.getDataSource(), database, database.getMetaContext().getDefaultSchema(), fullTypeName);
    }

    @Nullable
    public static PostgreDataType resolveTypeFullName(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDataSource dataSource, @NotNull String fullTypeName) throws DBException {
        return PostgreUtils.resolveTypeFullName(monitor, dataSource, dataSource.getDefaultInstance(), dataSource.getDefaultInstance().getMetaContext().getDefaultSchema(), fullTypeName);
    }

    @Nullable
    private static PostgreDataType resolveTypeFullName(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDataSource dataSource, @NotNull PostgreDatabase database, @NotNull PostgreSchema schema, @NotNull String fullTypeName) throws DBException {
        PostgreDatabase resolvedDatabase;
        PostgreSchema resolvedSchema;
        String identifier = (String)DBUtils.getTypeModifiers((String)fullTypeName).getFirst();
        String[] parts = PostgreUtils.splitTypeNameIdentifier(dataSource, fullTypeName);
        PostgreDataType dataType = (PostgreDataType)schema.getDataTypeCache().getObject(monitor, schema, identifier);
        if (dataType != null) {
            return dataType;
        }
        dataType = database.getLocalDataType(identifier);
        if (dataType != null) {
            return dataType;
        }
        if (parts.length > 1 && (resolvedSchema = database.getSchema(monitor, parts[0])) != null) {
            String schemaTypeName = parts.length == 2 ? parts[1] : DBUtils.getFullyQualifiedName((DBPDataSource)dataSource, (String[])Arrays.copyOfRange(parts, 1, parts.length));
            dataType = (PostgreDataType)resolvedSchema.getDataTypeCache().getObject(monitor, resolvedSchema, schemaTypeName);
            if (dataType != null) {
                return dataType;
            }
        }
        if ((dataType = dataSource.getLocalDataType(identifier)) != null) {
            return dataType;
        }
        if (parts.length > 1 && (resolvedDatabase = dataSource.getDatabase(parts[0])) != null) {
            PostgreSchema resolvedSchema2;
            String dbTypeName = parts.length == 2 ? parts[1] : DBUtils.getFullyQualifiedName((DBPDataSource)dataSource, (String[])Arrays.copyOfRange(parts, 1, parts.length));
            dataType = resolvedDatabase.getLocalDataType(dbTypeName);
            if (dataType != null) {
                return dataType;
            }
            if (parts.length > 2 && (resolvedSchema2 = resolvedDatabase.getSchema(monitor, parts[1])) != null) {
                String dbSchemaTypeName = parts.length == 3 ? parts[2] : DBUtils.getFullyQualifiedName((DBPDataSource)dataSource, (String[])Arrays.copyOfRange(parts, 2, parts.length));
                dataType = (PostgreDataType)resolvedSchema2.getDataTypeCache().getObject(monitor, resolvedSchema2, dbSchemaTypeName);
                if (dataType != null) {
                    return dataType;
                }
            }
        }
        return null;
    }

    @NotNull
    private static String[] splitTypeNameIdentifier(@NotNull PostgreDataSource dataSource, @NotNull String fullTypeName) throws DBException {
        Pair typeNameInfo = DBUtils.getTypeModifiers((String)fullTypeName);
        String identifier = (String)typeNameInfo.getFirst();
        String[] parts = PostgreUtils.isCompositeTypeName(identifier) ? SQLUtils.splitFullIdentifier((String)identifier, (String)".", (String[][])dataSource.getSQLDialect().getIdentifierQuoteStrings(), (boolean)false) : new String[]{identifier};
        return parts;
    }

    private static boolean isCompositeTypeName(@NotNull String typeName) {
        return typeName.startsWith("\"") || typeName.contains(".");
    }

    public static void setArrayParameter(JDBCPreparedStatement dbStat, int index, List<? extends PostgreObject> objectList) throws SQLException {
        int i = 0;
        while (i < objectList.size()) {
            dbStat.setLong(index + i, objectList.get(i).getObjectId());
            ++i;
        }
    }

    public static String getViewDDL(DBRProgressMonitor monitor, PostgreViewBase view, String definition) throws DBException {
        if (definition.toLowerCase(Locale.ENGLISH).startsWith("create ")) {
            return definition;
        }
        StringBuilder sql = new StringBuilder(view instanceof PostgreView ? "CREATE OR REPLACE " : "CREATE ");
        sql.append(view.getTableTypeName()).append(" ").append(view.getFullyQualifiedName(DBPEvaluationContext.DDL));
        DBERegistry editorsRegistry = DBWorkbench.getPlatform().getEditorsRegistry();
        PostgreViewManager entityEditor = (PostgreViewManager)((Object)editorsRegistry.getObjectManager(view.getClass(), PostgreViewManager.class));
        if (entityEditor != null) {
            entityEditor.appendViewDeclarationPrefix(monitor, sql, view);
        }
        definition = definition.trim();
        while (definition.endsWith(";")) {
            definition = definition.substring(0, definition.length() - 1);
        }
        sql.append("\nAS ").append(definition);
        if (entityEditor != null) {
            entityEditor.appendViewDeclarationPostfix(monitor, sql, view);
        }
        view.appendTableModifiers(monitor, sql);
        sql.append(";");
        return sql.toString();
    }

    public static PostgreServerType getServerType(DBPDriver driver) {
        PostgreServerType serverType;
        String serverTypeName = CommonUtils.toString((Object)driver.getDriverParameter("serverType"));
        if (CommonUtils.isEmpty((String)serverTypeName)) {
            serverTypeName = "postgresql";
        }
        if ((serverType = PostgreServerTypeRegistry.getInstance().getServerType(serverTypeName)) == null) {
            throw new IllegalStateException("PostgreSQL server type '" + serverTypeName + "' not found");
        }
        return serverType;
    }

    public static String[] extractGranteesFromACL(@NotNull String[] acl) {
        ArrayList<String> grantees = new ArrayList<String>();
        String[] stringArray = acl;
        int n = acl.length;
        int n2 = 0;
        while (n2 < n) {
            String aclValue = stringArray[n2];
            if (!CommonUtils.isEmpty((String)aclValue)) {
                int divPos = aclValue.indexOf(61);
                if (divPos == -1) {
                    log.warn((Object)("Bad ACL item: " + aclValue));
                } else {
                    String grantee = aclValue.substring(0, divPos);
                    if (grantee.isEmpty()) {
                        grantee = "public";
                    }
                    grantees.add(grantee);
                }
            }
            ++n2;
        }
        return grantees.toArray(new String[0]);
    }

    public static List<PostgrePrivilege> extractPermissionsFromACL(@NotNull PostgrePrivilegeOwner owner, @NotNull String[] acl, boolean isDefault) {
        ArrayList<PostgrePrivilege> permissions = new ArrayList<PostgrePrivilege>();
        String[] stringArray = acl;
        int n = acl.length;
        int n2 = 0;
        while (n2 < n) {
            String aclValue = stringArray[n2];
            if (!CommonUtils.isEmpty((String)aclValue)) {
                int divPos = aclValue.indexOf(61);
                if (divPos == -1) {
                    log.warn((Object)("Bad ACL item: " + aclValue));
                } else {
                    String permString;
                    int divPos2;
                    String grantee = aclValue.substring(0, divPos);
                    if (grantee.isEmpty()) {
                        grantee = "public";
                    }
                    if ((divPos2 = (permString = aclValue.substring(divPos + 1)).indexOf(47)) == -1) {
                        log.warn((Object)("Bad permissions string: " + permString));
                    } else {
                        String privString = permString.substring(0, divPos2);
                        String grantor = permString.substring(divPos2 + 1);
                        ArrayList<PostgrePrivilegeGrant> privileges = new ArrayList<PostgrePrivilegeGrant>();
                        int k = 0;
                        while (k < privString.length()) {
                            char pCode = privString.charAt(k);
                            boolean withGrantOption = false;
                            if (k < privString.length() - 1 && privString.charAt(k + 1) == '*') {
                                withGrantOption = true;
                                ++k;
                            }
                            privileges.add(new PostgrePrivilegeGrant(grantor, grantee, owner.getDatabase().getName(), owner.getSchema().getName(), owner.getName(), PostgrePrivilegeType.getByCode(pCode), withGrantOption, false));
                            ++k;
                        }
                        if (isDefault) {
                            permissions.add(new PostgreDefaultPrivilege(owner, grantee, privileges));
                        } else {
                            permissions.add(new PostgreObjectPrivilege(owner, grantee, privileges));
                        }
                    }
                }
            }
            ++n2;
        }
        return permissions;
    }

    public static List<PostgrePrivilege> extractPermissionsFromACL(@NotNull DBRProgressMonitor monitor, @NotNull PostgrePrivilegeOwner owner, @Nullable Object acl, boolean isDefault) throws DBException {
        Object itemArray;
        if (!(acl instanceof java.sql.Array)) {
            if (acl == null) {
                PostgreRole objectOwner = owner.getOwner(monitor);
                String granteeName = objectOwner == null ? null : objectOwner.getName();
                ArrayList<PostgrePrivilegeGrant> privileges = new ArrayList<PostgrePrivilegeGrant>();
                privileges.add(new PostgrePrivilegeGrant(granteeName, granteeName, owner.getDatabase().getName(), owner.getSchema().getName(), owner.getName(), PostgrePrivilegeType.ALL, false, false));
                PostgreObjectPrivilege permission = new PostgreObjectPrivilege(owner, objectOwner == null ? null : objectOwner.getName(), privileges);
                return Collections.singletonList(permission);
            }
            return Collections.emptyList();
        }
        try {
            itemArray = ((java.sql.Array)acl).getArray();
        }
        catch (SQLException e) {
            log.error((Object)e);
            return Collections.emptyList();
        }
        int aclValuesCount = Array.getLength(itemArray);
        String[] aclValues = new String[aclValuesCount];
        int i = 0;
        while (i < aclValuesCount) {
            Object aclItem = Array.get(itemArray, i);
            String aclValue = CommonUtils.toString((Object)PostgreUtils.extractPGObjectValue(aclItem));
            aclValues[i] = aclValue = aclValue.replace("\\\"", "\"");
            ++i;
        }
        return PostgreUtils.extractPermissionsFromACL(owner, aclValues, isDefault);
    }

    public static String getOptionsString(String[] options) {
        StringBuilder opt = new StringBuilder();
        opt.append("(");
        if (!ArrayUtils.isEmpty((Object[])options)) {
            int i = 0;
            while (i < options.length) {
                int divPos;
                String option = options[i];
                if (i > 0) {
                    opt.append(", ");
                }
                if ((divPos = option.indexOf(61)) < 0) {
                    opt.append(option);
                } else {
                    opt.append(option.substring(0, divPos)).append(" '").append(option.substring(divPos + 1)).append("'");
                }
                ++i;
            }
        }
        opt.append(")");
        return opt.toString();
    }

    public static String getObjectTypeName(PostgrePrivilegeOwner object) {
        if (object instanceof PostgreSequence) {
            return "SEQUENCE";
        }
        if (object instanceof PostgreProcedure) {
            return ((PostgreProcedure)object).getProcedureTypeName();
        }
        if (object instanceof PostgreSchema) {
            return "SCHEMA";
        }
        if (object instanceof PostgreDatabase) {
            return "DATABASE";
        }
        return "TABLE";
    }

    public static String getObjectUniqueName(PostgrePrivilegeOwner object) {
        if (object instanceof PostgreProcedure) {
            return ((PostgreProcedure)object).getFullQualifiedSignature();
        }
        return DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.DDL);
    }

    public static void getObjectGrantPermissionActions(DBRProgressMonitor monitor, PostgrePrivilegeOwner object, List<DBEPersistAction> actions, Map<String, Object> options) throws DBException {
        if (object.isPersisted() && CommonUtils.getOption(options, (String)"ddl.includePermissions")) {
            Collection<PostgrePrivilege> permissions;
            String alterScript;
            PostgreRole owner;
            DBCExecutionContext executionContext = DBUtils.getDefaultContext((DBSObject)object, (boolean)true);
            if (object.getDataSource().getContainer().getPreferenceStore().getBoolean("database.meta.extra.ddl.info")) {
                actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)object.getDataSource(), "Permissions"));
            }
            if ((owner = object.getOwner(monitor)) != null && !CommonUtils.isEmpty((String)(alterScript = object.generateChangeOwnerQuery(DBUtils.getQuotedIdentifier((DBSObject)owner))))) {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Owner change", alterScript));
            }
            if (!CommonUtils.isEmpty(permissions = object.getPrivileges(monitor, true))) {
                for (PostgrePrivilege permission : permissions) {
                    if (permission.hasAllPrivileges(object)) {
                        Collections.addAll(actions, new PostgreCommandGrantPrivilege(permission.getOwner(), true, object, permission, new PostgrePrivilegeType[]{PostgrePrivilegeType.ALL}).getPersistActions(monitor, executionContext, options));
                        continue;
                    }
                    PostgreCommandGrantPrivilege grant = new PostgreCommandGrantPrivilege(permission.getOwner(), true, object, permission, permission.getPrivileges());
                    Collections.addAll(actions, grant.getPersistActions(monitor, executionContext, options));
                }
            }
        }
    }

    public static boolean isGISDataType(String typeName) {
        return "geometry".equals(typeName) || "geography".equals(typeName);
    }

    public static String getRealSchemaName(PostgreDatabase database, String name) {
        return name.replace("$user", database.getMetaContext().getActiveUser());
    }

    @NotNull
    public static String getQueryForSystemColumnChecking(@NotNull String tableName, @NotNull String columnName) {
        return "SELECT " + columnName + " FROM pg_catalog." + tableName + " WHERE 1<>1 LIMIT 1";
    }

    public static boolean isMetaObjectExists(@NotNull JDBCSession session, @NotNull String tableName, @NotNull String columnName) {
        try {
            JDBCUtils.queryString((Connection)session, (String)PostgreUtils.getQueryForSystemColumnChecking(tableName, columnName), (Object[])new Object[0]);
            return true;
        }
        catch (SQLException e) {
            log.debug((Object)("Error reading system information from the " + tableName + " table: " + e.getMessage()));
            return false;
        }
    }

    @NotNull
    public static String getArrayDelimiter(@NotNull DBSTypedObject type) {
        if (type instanceof PostgreDataType) {
            return ((PostgreDataType)type).getArrayDelimiter();
        }
        return ",";
    }

    @Nullable
    public static <T> T[] safeGetArray(@NotNull ResultSet dbResult, @NotNull String columnName, @NotNull Function<String, T> converter, @NotNull IntFunction<T[]> generator) {
        Exception exception = null;
        try {
            java.sql.Array value = dbResult.getArray(columnName);
            return value != null ? (Object[])value.getArray() : null;
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            String value = dbResult.getString(columnName);
            return value != null ? PostgreValueParser.parsePrimitiveArray(value, converter, generator) : null;
        }
        catch (Exception e) {
            if (exception == null) {
                exception = e;
            }
            log.debug((Object)("Can't get column '" + columnName + "': " + exception.getMessage()));
            return null;
        }
    }

    @Nullable
    public static String[] safeGetStringArray(@NotNull ResultSet dbResult, @NotNull String columnName) {
        return (String[])PostgreUtils.safeGetArray(dbResult, columnName, Function.identity(), String[]::new);
    }

    @Nullable
    public static Number[] safeGetNumberArray(@NotNull ResultSet dbResult, @NotNull String columnName) {
        return PostgreUtils.safeGetArray(dbResult, columnName, PostgreUtils::parseNumber, Number[]::new);
    }

    @Nullable
    public static Boolean[] safeGetBooleanArray(@NotNull ResultSet dbResult, @NotNull String columnName) {
        return PostgreUtils.safeGetArray(dbResult, columnName, Boolean::valueOf, Boolean[]::new);
    }

    @NotNull
    private static Number parseNumber(@NotNull String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            return Double.parseDouble(str);
        }
    }
}

