/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLNativeToolHandler;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLScriptExecuteSettings;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolHandler;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class MySQLScriptExecuteHandler
extends MySQLNativeToolHandler<MySQLScriptExecuteSettings, MySQLCatalog, MySQLCatalog> {
    public Collection<MySQLCatalog> getRunInfo(MySQLScriptExecuteSettings settings) {
        return settings.getDatabaseObjects();
    }

    protected MySQLScriptExecuteSettings createTaskSettings(DBRRunnableContext context, DBTTask task) throws DBException {
        MySQLScriptExecuteSettings settings = new MySQLScriptExecuteSettings();
        boolean isImport = task.getType().getId().equals("mysqlDatabaseRestore");
        settings.setImport(isImport);
        settings.loadSettings(context, (DBPPreferenceStore)new TaskPreferenceStore(task));
        return settings;
    }

    protected boolean validateTaskParameters(DBTTask task, MySQLScriptExecuteSettings settings, Log log) {
        DBPDataSource dataSource = settings.getDataSourceContainer().getDataSource();
        if (settings.isImport() && dataSource != null && DBUtils.isReadOnly((DBSObject)dataSource)) {
            log.error((Object)NLS.bind((String)ModelMessages.tasks_restore_readonly_message, (Object)dataSource.getName()));
            return false;
        }
        return true;
    }

    @Override
    protected List<String> getCommandLine(MySQLScriptExecuteSettings settings, MySQLCatalog arg) throws IOException {
        List<String> cmd = super.getCommandLine(settings, arg);
        if (settings.isVerbose()) {
            cmd.add("-v");
        }
        if (settings.isForeignKeyCheckDisabled()) {
            cmd.add("--init-command=SET SESSION FOREIGN_KEY_CHECKS=0;");
        }
        cmd.add(arg.getName());
        return cmd;
    }

    public void fillProcessParameters(MySQLScriptExecuteSettings settings, MySQLCatalog arg, List<String> cmd) throws IOException {
        String dumpPath = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)settings.getClientHome(), (String)"bin", (String)"mysql").getAbsolutePath();
        cmd.add(dumpPath);
        if (settings.getLogLevel() == MySQLScriptExecuteSettings.LogLevel.Debug) {
            cmd.add("--debug-info");
        }
        if (settings.isNoBeep()) {
            cmd.add("--no-beep");
        }
        settings.addExtraCommandArgs(cmd);
    }

    protected boolean isMergeProcessStreams() {
        return true;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, DBTTask task, MySQLScriptExecuteSettings settings, MySQLCatalog arg, ProcessBuilder processBuilder, Process process, Log log) throws IOException, DBException {
        Path inputFile = DBFUtils.resolvePathFromString((DBRProgressMonitor)monitor, (DBPProject)task.getProject(), (String)settings.getInputFile());
        if (!Files.exists(inputFile, new LinkOption[0])) {
            throw new IOException("File '" + String.valueOf(inputFile) + "' doesn't exist");
        }
        if (settings.isImport()) {
            super.startProcessHandler(monitor, task, (AbstractNativeToolSettings)settings, (Object)arg, processBuilder, process, log);
            new AbstractNativeToolHandler.BinaryFileTransformerJob(monitor, task, inputFile, process.getOutputStream(), log).start();
        } else {
            super.startProcessHandler(monitor, task, (AbstractNativeToolSettings)settings, (Object)arg, processBuilder, process, log);
            new AbstractNativeToolHandler.TextFileTransformerJob(monitor, task, inputFile, process.getOutputStream(), this.getInputCharset(), this.getOutputCharset(), log).start();
        }
    }
}

