/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model.session;

import java.sql.ResultSet;
import java.util.Map;
import java.util.Objects;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class MySQLSession
extends AbstractServerSession {
    static final String CAT_PERFORMANCE = "Performance";
    private final long pid;
    private String user;
    private String host;
    private final String db;
    private String command;
    private long time;
    private String state;
    private String info;
    private String statementLatency;
    private String lockLatency;
    private long rowsExamined;
    private long rowsSent;
    private long rowsAffected;
    private long tmpTables;
    private long tmpDiskTables;
    private String fullScan;
    private String lastStatement;
    private String lastStatementLatency;
    private String currentMemory;
    private String trxLatency;
    private String trxState;
    private String trxAutocommit;
    private long progress;
    private String source;
    private String programName;
    private boolean readPerformanceStats;

    public MySQLSession(ResultSet dbResult, Map<String, Object> options) {
        this.pid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"id");
        this.user = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"user");
        this.host = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"host");
        this.db = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"db");
        this.command = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"command");
        this.time = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"time");
        this.state = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"state");
        this.info = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"info");
        this.readPerformanceStats = CommonUtils.getOption(options, (String)"showPerformance");
        if (this.readPerformanceStats) {
            this.statementLatency = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"statement_latency");
            this.lockLatency = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"lock_latency");
            this.rowsExamined = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"rows_examined");
            this.rowsSent = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"rows_sent");
            this.rowsAffected = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"rows_affected");
            this.tmpTables = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"tmp_tables");
            this.tmpDiskTables = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"tmp_disk_tables");
            this.fullScan = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"full_scan");
            this.lastStatement = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"last_statement");
            this.lastStatementLatency = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"last_statement_latency");
            this.currentMemory = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"current_memory");
            this.trxLatency = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"trx_latency");
            this.trxState = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"trx_state");
            this.trxAutocommit = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"trx_autocommit");
            this.progress = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"progress");
            this.source = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"source");
            this.programName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"program_name");
        }
    }

    @Property(viewable=true, order=1)
    public long getPid() {
        return this.pid;
    }

    @Property(viewable=true, order=2)
    public String getUser() {
        return this.user;
    }

    @Property(viewable=true, order=3)
    public String getHost() {
        return this.host;
    }

    @Property(viewable=true, order=4)
    public String getDb() {
        return this.db;
    }

    @Property(viewable=true, order=5)
    public String getCommand() {
        return this.command;
    }

    @Property(viewable=true, order=6)
    public long getTime() {
        return this.time;
    }

    @Property(viewable=true, order=7)
    public String getState() {
        return this.state;
    }

    @Property(viewable=true, order=8)
    public String getActiveQuery() {
        return this.info;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=9)
    public String getStatementLatency() {
        return this.statementLatency;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=10)
    public String getLockLatency() {
        return this.lockLatency;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=11)
    public long getRowsExamined() {
        return this.rowsExamined;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=12)
    public long getRowsSent() {
        return this.rowsSent;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=13)
    public long getRowsAffected() {
        return this.rowsAffected;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=14)
    public long getTmpTables() {
        return this.tmpTables;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=15)
    public long getTmpDiskTables() {
        return this.tmpDiskTables;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=16)
    public String getFullScan() {
        return this.fullScan;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=17)
    public String getLastStatement() {
        return this.lastStatement;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=18)
    public String getLastStatementLatency() {
        return this.lastStatementLatency;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=19)
    public String getCurrentMemory() {
        return this.currentMemory;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=20)
    public String getTrxLatency() {
        return this.trxLatency;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=21)
    public String getTrxState() {
        return this.trxState;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=22)
    public String getTrxAutocommit() {
        return this.trxAutocommit;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=23)
    public long getProgress() {
        return this.progress;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=24)
    public String getSource() {
        return this.source;
    }

    @Property(category="Performance", visibleIf=PerformanceReadingValueValidator.class, order=25)
    public String getProgramName() {
        return this.programName;
    }

    private boolean isReadPerformanceStats() {
        return this.readPerformanceStats;
    }

    public String toString() {
        return this.pid + "@" + this.db;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MySQLSession that = (MySQLSession)((Object)o);
        return this.pid == that.pid && Objects.equals(this.db, that.db);
    }

    public int hashCode() {
        return Objects.hash(this.pid, this.db);
    }

    public static class PerformanceReadingValueValidator
    implements IPropertyValueValidator<MySQLSession, Object> {
        public boolean isValidValue(MySQLSession session, Object value) throws IllegalArgumentException {
            return session.isReadPerformanceStats();
        }
    }
}

