/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCharset;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCollation;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.MySQLEngine;
import org.jkiss.dbeaver.ext.mysql.model.MySQLPartition;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraint;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableConstraintColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKey;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableForeignKeyColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndex;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTrigger;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPReferentialIntegrityController;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.struct.AbstractTableConstraint;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.cache.SimpleObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSForeignKeyModifyRule;
import org.jkiss.dbeaver.model.struct.rdb.DBSPartitionContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class MySQLTable
extends MySQLTableBase
implements DBPObjectStatistics,
DBPReferentialIntegrityController,
DBSPartitionContainer {
    private static final Log log = Log.getLog(MySQLTable.class);
    private static final String INNODB_COMMENT = "InnoDB free";
    private static final String PARTITIONED_STATUS = "partitioned";
    private final SimpleObjectCache<MySQLTable, MySQLTableForeignKey> foreignKeys = new SimpleObjectCache();
    private final PartitionCache partitionCache = new PartitionCache();
    private final AdditionalInfo additionalInfo = new AdditionalInfo();
    private volatile List<MySQLTableForeignKey> referenceCache;
    @Nullable
    private String disableReferentialIntegrityStatement;
    @Nullable
    private String enableReferentialIntegrityStatement;

    public MySQLTable(MySQLCatalog catalog) {
        super(catalog);
    }

    public MySQLTable(DBRProgressMonitor monitor, MySQLCatalog catalog, DBSEntity source) throws DBException {
        super(monitor, catalog, source);
        if (source instanceof MySQLTable) {
            AdditionalInfo sourceAI = ((MySQLTable)source).getAdditionalInfo(monitor);
            this.additionalInfo.loaded = true;
            this.additionalInfo.description = sourceAI.description;
            this.additionalInfo.charset = sourceAI.charset;
            this.additionalInfo.collation = sourceAI.collation;
            this.additionalInfo.engine = sourceAI.engine;
            this.additionalInfo.partitioned = sourceAI.partitioned;
            for (MySQLTrigger srcTrigger : ((MySQLTable)source).getTriggers(monitor)) {
                MySQLTrigger trigger = new MySQLTrigger(catalog, this, srcTrigger);
                ((MySQLCatalog)this.getContainer()).triggerCache.cacheObject(trigger);
            }
            for (Object partition : ((MySQLTable)source).partitionCache.getCachedObjects()) {
                this.partitionCache.cacheObject(new MySQLPartition(monitor, this, (MySQLPartition)partition, source));
            }
        }
        if (source instanceof DBSTable) {
            for (DBSTableIndex srcIndex : CommonUtils.safeCollection((Collection)((DBSTable)source).getIndexes(monitor))) {
                if (srcIndex instanceof MySQLTableIndex && srcIndex.isPrimary()) continue;
                MySQLTableIndex index = new MySQLTableIndex(monitor, this, srcIndex);
                ((MySQLCatalog)this.getContainer()).indexCache.cacheObject((DBSObject)index);
            }
        }
        for (DBSEntityConstraint srcConstr : CommonUtils.safeCollection((Collection)source.getConstraints(monitor))) {
            MySQLTableConstraint constr = new MySQLTableConstraint(monitor, this, srcConstr);
            ((MySQLCatalog)this.getContainer()).uniqueKeyCache.cacheObject(constr);
        }
        ArrayList<MySQLTableForeignKey> fkList = new ArrayList<MySQLTableForeignKey>();
        for (DBSEntityAssociation srcFK : CommonUtils.safeCollection((Collection)source.getAssociations(monitor))) {
            MySQLTableForeignKey fk = new MySQLTableForeignKey(monitor, this, srcFK);
            if (fk.getReferencedConstraint() != null) {
                fk.setName(fk.getName() + "_copy");
                fkList.add(fk);
                continue;
            }
            log.debug((Object)("Can't copy association '" + srcFK.getName() + "' - can't find referenced constraint"));
        }
        this.foreignKeys.setCache(fkList);
    }

    public MySQLTable(MySQLCatalog catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup
    @LazyProperty(cacheValidator=AdditionalInfoValidator.class)
    public AdditionalInfo getAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        AdditionalInfo additionalInfo = this.additionalInfo;
        synchronized (additionalInfo) {
            if (!this.additionalInfo.loaded) {
                this.loadAdditionalInfo(monitor);
            }
            return this.additionalInfo;
        }
    }

    public boolean hasStatistics() {
        return this.additionalInfo.loaded;
    }

    public long getStatObjectSize() {
        return this.additionalInfo.dataLength + this.additionalInfo.indexLength;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        PropertyCollector collector = new PropertyCollector((Object)this.additionalInfo, true);
        collector.collectProperties();
        return collector;
    }

    public boolean isView() {
        return false;
    }

    @Association
    public boolean hasPartitions() {
        return this.additionalInfo.partitioned;
    }

    @Association
    public Collection<MySQLTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return ((MySQLCatalog)this.getContainer()).indexCache.getObjects(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this);
    }

    @Nullable
    @Association
    public Collection<MySQLTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        List constraintObjects = ((MySQLCatalog)this.getContainer()).uniqueKeyCache.getObjects(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this);
        if (((MySQLDataSource)this.getDataSource()).supportsCheckConstraints()) {
            List checkConstraintObjects = ((MySQLCatalog)this.getContainer()).checkConstraintCache.getObjects(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this);
            if (!CommonUtils.isEmpty((Collection)checkConstraintObjects)) {
                constraintObjects.addAll(checkConstraintObjects);
            }
            return constraintObjects;
        }
        return constraintObjects;
    }

    public MySQLTableConstraint getUniqueKey(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (MySQLTableConstraint)((MySQLCatalog)this.getContainer()).uniqueKeyCache.getObject(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this, ukName);
    }

    @Association
    public Collection<MySQLTableConstraint> getCheckConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((MySQLCatalog)this.getContainer()).checkConstraintCache.getObjects(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this);
    }

    public MySQLTableConstraint getCheckConstraint(DBRProgressMonitor monitor, String constName) throws DBException {
        return (MySQLTableConstraint)((MySQLCatalog)this.getContainer()).checkConstraintCache.getObject(monitor, (DBSObject)((MySQLCatalog)this.getContainer()), this, constName);
    }

    @Association
    public Collection<MySQLTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.referenceCache == null) {
            this.referenceCache = this.loadForeignKeys(monitor, true);
        }
        return this.referenceCache;
    }

    public synchronized Collection<MySQLTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!this.foreignKeys.isFullyCached() && ((MySQLDataSource)this.getDataSource()).getInfo().supportsReferentialIntegrity()) {
            List<MySQLTableForeignKey> fkList = this.loadForeignKeys(monitor, false);
            this.foreignKeys.setCache(fkList);
        }
        return this.foreignKeys.getCachedObjects();
    }

    public MySQLTableForeignKey getAssociation(DBRProgressMonitor monitor, String fkName) throws DBException {
        return (MySQLTableForeignKey)DBUtils.findObject(this.getAssociations(monitor), (String)fkName);
    }

    public DBSObjectCache<MySQLTable, MySQLTableForeignKey> getForeignKeyCache() {
        return this.foreignKeys;
    }

    @Nullable
    @Association
    public List<MySQLTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        ArrayList<MySQLTrigger> triggers = new ArrayList<MySQLTrigger>();
        for (MySQLTrigger trigger : ((MySQLCatalog)this.getContainer()).triggerCache.getAllObjects(monitor, (DBSObject)((MySQLCatalog)this.getContainer()))) {
            if (trigger.getTable() != this) continue;
            triggers.add(trigger);
        }
        return triggers;
    }

    @Association
    public Collection<MySQLPartition> getPartitions(DBRProgressMonitor monitor) throws DBException {
        return this.partitionCache.getAllObjects(monitor, this);
    }

    private void loadAdditionalInfo(DBRProgressMonitor monitor) throws DBCException {
        if (!this.isPersisted()) {
            this.additionalInfo.loaded = true;
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table status");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SHOW TABLE STATUS FROM " + DBUtils.getQuotedIdentifier((DBSObject)this.getContainer()) + " LIKE '" + this.getName() + "'");){
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.fetchAdditionalInfo(dbResult);
                        }
                        this.additionalInfo.loaded = true;
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    void fetchAdditionalInfo(JDBCResultSet dbResult) {
        MySQLDataSource dataSource = (MySQLDataSource)this.getDataSource();
        String desc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMMENT");
        if (desc != null) {
            int divPos;
            if (desc.startsWith(INNODB_COMMENT)) {
                desc = "";
            } else if (!CommonUtils.isEmpty((String)desc) && (divPos = desc.indexOf("; InnoDB free")) != -1) {
                desc = desc.substring(0, divPos);
            }
            this.additionalInfo.description = desc;
        }
        this.additionalInfo.engine = dataSource.getEngine(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ENGINE"));
        this.additionalInfo.rowCount = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ROWS");
        this.additionalInfo.autoIncrement = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"AUTO_INCREMENT");
        this.additionalInfo.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.additionalInfo.updateTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"Update_time");
        this.additionalInfo.checkTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"Check_time");
        this.additionalInfo.collation = dataSource.getCollation(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLLATION"));
        if (this.additionalInfo.collation != null) {
            this.additionalInfo.charset = this.additionalInfo.collation.getCharset();
        }
        this.additionalInfo.avgRowLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"AVG_ROW_LENGTH");
        this.additionalInfo.dataLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"DATA_LENGTH");
        this.additionalInfo.maxDataLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"Max_data_length");
        this.additionalInfo.dataFree = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"Data_free");
        this.additionalInfo.indexLength = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"Index_length");
        this.additionalInfo.rowFormat = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Row_format");
        String createOptions = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Create_options");
        if (CommonUtils.isNotEmpty((String)createOptions)) {
            this.additionalInfo.partitioned = createOptions.contains(PARTITIONED_STATUS);
        }
        this.additionalInfo.loaded = true;
    }

    private List<MySQLTableForeignKey> loadForeignKeys(DBRProgressMonitor monitor, boolean references) throws DBException {
        ArrayList<MySQLTableForeignKey> fkList = new ArrayList<MySQLTableForeignKey>();
        if (!this.isPersisted()) {
            return fkList;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table relations");){
                HashMap<String, MySQLTableForeignKey> fkMap = new HashMap<String, MySQLTableForeignKey>();
                HashMap<CallSite, MySQLTableConstraint> pkMap = new HashMap<CallSite, MySQLTableConstraint>();
                JDBCDatabaseMetaData metaData = session.getMetaData();
                try (JDBCResultSet dbResult = references ? metaData.getExportedKeys(((MySQLCatalog)this.getContainer()).getName(), null, this.getName()) : metaData.getImportedKeys(((MySQLCatalog)this.getContainer()).getName(), null, this.getName());){
                    while (dbResult.next()) {
                        MySQLTableForeignKeyColumn fkColumnInfo;
                        Collection<MySQLTableConstraint> constraints;
                        MySQLTableColumn fkColumn;
                        MySQLTableColumn pkColumn;
                        MySQLTable fkTable;
                        String pkTableCatalog = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PKTABLE_CAT");
                        String pkTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PKTABLE_NAME");
                        String pkColumnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PKCOLUMN_NAME");
                        String fkTableCatalog = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FKTABLE_CAT");
                        String fkTableName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FKTABLE_NAME");
                        String fkColumnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FKCOLUMN_NAME");
                        int keySeq = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"KEY_SEQ");
                        int updateRuleNum = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"UPDATE_RULE");
                        int deleteRuleNum = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DELETE_RULE");
                        String fkName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FK_NAME");
                        String pkName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PK_NAME");
                        DBSForeignKeyModifyRule deleteRule = JDBCUtils.getCascadeFromNum((int)deleteRuleNum);
                        DBSForeignKeyModifyRule updateRule = JDBCUtils.getCascadeFromNum((int)updateRuleNum);
                        MySQLTable pkTable = ((MySQLDataSource)this.getDataSource()).findTable(monitor, pkTableCatalog, pkTableName);
                        if (pkTable == null) {
                            log.debug((Object)("Can't find PK table " + pkTableName));
                            if (references) continue;
                        }
                        if ((fkTable = ((MySQLDataSource)this.getDataSource()).findTable(monitor, fkTableCatalog, fkTableName)) == null) {
                            log.warn((Object)("Can't find FK table " + fkTableName));
                            if (!references) continue;
                        }
                        MySQLTableColumn mySQLTableColumn = pkColumn = pkTable == null ? null : pkTable.getAttribute(monitor, pkColumnName);
                        if (pkColumn == null) {
                            log.debug((Object)("Can't find PK table " + pkTableName + " column " + pkColumnName));
                            if (references) continue;
                        }
                        MySQLTableColumn mySQLTableColumn2 = fkColumn = fkTable == null ? null : fkTable.getAttribute(monitor, fkColumnName);
                        if (fkColumn == null) {
                            log.debug((Object)("Can't find FK table " + fkTableName + " column " + fkColumnName));
                            if (!references) continue;
                        }
                        MySQLTableConstraint pk = null;
                        if (pkTable != null && (constraints = pkTable.getConstraints(monitor)) != null) {
                            for (MySQLTableConstraint pkConstraint : constraints) {
                                if (!pkConstraint.getConstraintType().isUnique() || DBUtils.getConstraintAttribute((DBRProgressMonitor)monitor, (DBSEntityReferrer)pkConstraint, (DBSEntityAttribute)pkColumn) == null) continue;
                                pk = pkConstraint;
                                if (pkConstraint.getName().equals(pkName)) break;
                            }
                        }
                        if (pk == null && pkTable != null && pkName != null && (pk = (MySQLTableConstraint)DBUtils.findObject(constraints = pkTable.getConstraints(monitor), (String)pkName)) == null) {
                            log.warn((Object)("Unique key '" + pkName + "' not found in table " + pkTable.getFullyQualifiedName(DBPEvaluationContext.DDL)));
                        }
                        if (pk == null && pkTable != null) {
                            log.warn((Object)("Can't find primary key for table " + pkTable.getFullyQualifiedName(DBPEvaluationContext.DDL)));
                            String pkFullName = pkTable.getFullyQualifiedName(DBPEvaluationContext.DDL) + "." + pkName;
                            pk = (MySQLTableConstraint)pkMap.get(pkFullName);
                            if (pk == null) {
                                pk = new MySQLTableConstraint(pkTable, pkName, null, DBSEntityConstraintType.PRIMARY_KEY, true);
                                pk.addColumn(new MySQLTableConstraintColumn((AbstractTableConstraint<MySQLTable>)pk, pkColumn, keySeq));
                                pkMap.put((CallSite)((Object)pkFullName), pk);
                            }
                        }
                        MySQLTableForeignKey fk = null;
                        if (references && fkTable != null) {
                            fk = (MySQLTableForeignKey)DBUtils.findObject(fkTable.getAssociations(monitor), (String)fkName);
                            if (fk == null) {
                                log.warn((Object)("Can't find foreign key '" + fkName + "' for table " + fkTable.getFullyQualifiedName(DBPEvaluationContext.DDL)));
                            } else if (!fkList.contains((Object)fk)) {
                                fkList.add(fk);
                            }
                        }
                        if (fk != null) continue;
                        fk = (MySQLTableForeignKey)((Object)fkMap.get(fkName));
                        if (fk == null) {
                            fk = new MySQLTableForeignKey(fkTable, fkName, null, pk, deleteRule, updateRule, true);
                            fkMap.put(fkName, fk);
                            fkList.add(fk);
                        }
                        if (fk.hasColumn(fkColumnInfo = new MySQLTableForeignKeyColumn(fk, fkColumn, keySeq, pkColumn))) {
                            log.debug((Object)("FK " + fkName + " has already been added, skip"));
                            continue;
                        }
                        fk.addColumn(fkColumnInfo);
                    }
                }
                return fkList;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex, this.getDataSource());
        }
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.getDDL(monitor, options);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        throw new DBException("Table DDL is read-only");
    }

    @Nullable
    public String getDescription() {
        return this.additionalInfo.description;
    }

    @Override
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((MySQLCatalog)this.getContainer()).uniqueKeyCache.clearObjectCache(this);
        if (((MySQLDataSource)this.getDataSource()).supportsCheckConstraints()) {
            ((MySQLCatalog)this.getContainer()).checkConstraintCache.clearObjectCache(this);
        }
        ((MySQLCatalog)this.getContainer()).indexCache.clearObjectCache(this);
        ((MySQLCatalog)this.getContainer()).triggerCache.clearChildrenOf(this);
        this.referenceCache = null;
        return super.refreshObject(monitor);
    }

    public boolean supportsChangingReferentialIntegrity(@NotNull DBRProgressMonitor monitor) {
        return true;
    }

    public void enableReferentialIntegrity(@NotNull DBRProgressMonitor monitor, boolean enable) throws DBException {
        String sql = this.getChangeReferentialIntegrityStatement(monitor, enable);
        sql = sql.replace("?", this.getFullyQualifiedName(DBPEvaluationContext.DDL));
        try {
            JDBCUtils.executeInMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Changing referential integrity", (String)sql);
        }
        catch (SQLException e) {
            throw new DBException("Unable to change referential integrity", (Throwable)e);
        }
    }

    @NotNull
    public String getChangeReferentialIntegrityStatement(@NotNull DBRProgressMonitor monitor, boolean enable) {
        if (enable && this.enableReferentialIntegrityStatement != null) {
            return this.enableReferentialIntegrityStatement;
        }
        if (!enable && this.disableReferentialIntegrityStatement != null) {
            return this.disableReferentialIntegrityStatement;
        }
        boolean supportsAlterTableKeysStmt = false;
        try {
            AdditionalInfo info = this.getAdditionalInfo(monitor);
            if (info != null && info.getEngine() != null && "MyISAM".equals(info.getEngine().getName())) {
                supportsAlterTableKeysStmt = true;
            }
        }
        catch (DBCException e) {
            log.debug((Object)"Unable to retrieve additional info for mysql table", (Throwable)e);
        }
        if (supportsAlterTableKeysStmt) {
            this.disableReferentialIntegrityStatement = "ALTER TABLE ? DISABLE KEYS";
            this.enableReferentialIntegrityStatement = "ALTER TABLE ? ENABLE KEYS";
        } else {
            this.disableReferentialIntegrityStatement = "SET GLOBAL FOREIGN_KEY_CHECKS=0";
            this.enableReferentialIntegrityStatement = "SET GLOBAL FOREIGN_KEY_CHECKS=1";
        }
        if (enable) {
            return this.enableReferentialIntegrityStatement;
        }
        return this.disableReferentialIntegrityStatement;
    }

    public static class AdditionalInfo {
        private volatile boolean loaded = false;
        private long rowCount;
        private long autoIncrement;
        private String description;
        private Date createTime;
        private Date updateTime;
        private Date checkTime;
        private MySQLCharset charset;
        private MySQLCollation collation;
        private MySQLEngine engine;
        private long avgRowLength;
        private long dataLength;
        private long maxDataLength;
        private long dataFree;
        private long indexLength;
        private String rowFormat;
        private boolean partitioned;

        @Property(viewable=true, editable=true, updatable=true, listProvider=EngineListProvider.class, visibleIf=PartitionedTablePropertyValidator.class, order=3)
        public MySQLEngine getEngine() {
            return this.engine;
        }

        @Property(viewable=true, editable=true, updatable=true, visibleIf=PartitionedTablePropertyValidator.class, order=4)
        public long getAutoIncrement() {
            return this.autoIncrement;
        }

        @Property(editable=true, updatable=true, listProvider=CharsetListProvider.class, visibleIf=PartitionedTablePropertyValidator.class, order=5)
        public MySQLCharset getCharset() {
            return this.charset;
        }

        @Property(editable=true, updatable=true, listProvider=CollationListProvider.class, visibleIf=PartitionedTablePropertyValidator.class, order=6)
        public MySQLCollation getCollation() {
            return this.collation;
        }

        @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, visibleIf=PartitionedTablePropertyValidator.class, order=100)
        public String getDescription() {
            return this.description;
        }

        @Property(category="Statistics", visibleIf=PartitionedTablePropertyValidator.class, order=10)
        public long getRowCount() {
            return this.rowCount;
        }

        @Property(category="Statistics", visibleIf=PartitionedTablePropertyValidator.class, order=11)
        public long getAvgRowLength() {
            return this.avgRowLength;
        }

        @Property(category="Statistics", viewable=true, order=12, visibleIf=PartitionedTablePropertyValidator.class, formatter=ByteNumberFormat.class)
        public long getDataLength() {
            return this.dataLength;
        }

        @Property(category="Statistics", order=13, visibleIf=PartitionedTablePropertyValidator.class, formatter=ByteNumberFormat.class)
        public long getMaxDataLength() {
            return this.maxDataLength;
        }

        @Property(category="Statistics", order=14, visibleIf=PartitionedTablePropertyValidator.class, formatter=ByteNumberFormat.class)
        public long getDataFree() {
            return this.dataFree;
        }

        @Property(category="Statistics", order=15, visibleIf=PartitionedTablePropertyValidator.class, formatter=ByteNumberFormat.class)
        public long getIndexLength() {
            return this.indexLength;
        }

        @Property(category="Statistics", order=16, visibleIf=PartitionedTablePropertyValidator.class)
        public String getRowFormat() {
            return this.rowFormat;
        }

        @Property(category="Statistics", visibleIf=PartitionedTablePropertyValidator.class, order=20)
        public Date getCreateTime() {
            return this.createTime;
        }

        @Property(category="Statistics", visibleIf=PartitionedTablePropertyValidator.class, order=21)
        public Date getUpdateTime() {
            return this.updateTime;
        }

        @Property(category="Statistics", visibleIf=PartitionedTablePropertyValidator.class, order=22)
        public Date getCheckTime() {
            return this.checkTime;
        }

        @Property(viewable=true, visibleIf=PartitionedTablePropertyValidator.class, order=23)
        public boolean isPartitioned() {
            return this.partitioned;
        }

        public void setEngine(MySQLEngine engine) {
            this.engine = engine;
        }

        public void setAutoIncrement(long autoIncrement) {
            this.autoIncrement = autoIncrement;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setCharset(MySQLCharset charset) {
            this.charset = charset;
            this.collation = charset == null ? null : charset.getDefaultCollation();
        }

        public void setCollation(MySQLCollation collation) {
            this.collation = collation;
        }
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<MySQLTable> {
        public boolean isPropertyCached(MySQLTable object, Object propertyId) {
            return object.additionalInfo.loaded;
        }
    }

    public static class CharsetListProvider
    implements IPropertyValueListProvider<MySQLTable> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(MySQLTable object) {
            return ((MySQLDataSource)object.getDataSource()).getCharsets().toArray();
        }
    }

    public static class CollationListProvider
    implements IPropertyValueListProvider<MySQLTable> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(MySQLTable object) {
            if (object.additionalInfo.charset == null) {
                return null;
            }
            return object.additionalInfo.charset.getCollations().toArray();
        }
    }

    public static class EngineListProvider
    implements IPropertyValueListProvider<MySQLTable> {
        public boolean allowCustomValue() {
            return false;
        }

        public Object[] getPossibleValues(MySQLTable object) {
            ArrayList<MySQLEngine> engines = new ArrayList<MySQLEngine>();
            for (MySQLEngine engine : ((MySQLDataSource)object.getDataSource()).getEngines()) {
                if (engine.getSupport() != MySQLEngine.Support.YES && engine.getSupport() != MySQLEngine.Support.DEFAULT) continue;
                engines.add(engine);
            }
            Collections.sort(engines, DBUtils.nameComparator());
            return engines.toArray(new MySQLEngine[engines.size()]);
        }
    }

    class PartitionCache
    extends JDBCObjectCache<MySQLTable, MySQLPartition> {
        Map<String, MySQLPartition> partitionMap = new HashMap<String, MySQLPartition>();

        PartitionCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull MySQLTable mySQLTable) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA=? AND TABLE_NAME=?  ORDER BY PARTITION_ORDINAL_POSITION,SUBPARTITION_ORDINAL_POSITION");
            dbStat.setString(1, ((MySQLCatalog)MySQLTable.this.getContainer()).getName());
            dbStat.setString(2, MySQLTable.this.getName());
            return dbStat;
        }

        protected MySQLPartition fetchObject(@NotNull JDBCSession session, @NotNull MySQLTable table, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            String partitionName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PARTITION_NAME");
            String subPartitionName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SUBPARTITION_NAME");
            if (CommonUtils.isEmpty((String)partitionName) && CommonUtils.isEmpty((String)subPartitionName)) {
                return null;
            }
            if (partitionName == null) {
                partitionName = "PARTITION";
            }
            if (CommonUtils.isEmpty((String)subPartitionName)) {
                return new MySQLPartition(table, null, partitionName, (ResultSet)dbResult);
            }
            MySQLPartition parentPartition = this.partitionMap.get(partitionName);
            boolean parentFetched = false;
            if (parentPartition == null) {
                parentPartition = new MySQLPartition(table, null, partitionName, (ResultSet)dbResult);
                this.partitionMap.put(partitionName, parentPartition);
            } else {
                parentFetched = true;
            }
            new MySQLPartition(table, parentPartition, subPartitionName, (ResultSet)dbResult);
            if (!parentFetched) {
                return parentPartition;
            }
            return null;
        }

        protected void invalidateObjects(DBRProgressMonitor monitor, MySQLTable owner, Iterator<MySQLPartition> objectIter) {
            this.partitionMap.clear();
        }
    }

    public static class PartitionedTablePropertyValidator
    implements IPropertyValueValidator<MySQLTable, Object> {
        public boolean isValidValue(MySQLTable object, Object value) throws IllegalArgumentException {
            return !object.isPartition();
        }
    }
}

