/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCSQLDialect;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialectSchemaController;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;
import org.jkiss.utils.ArrayUtils;

public class MySQLDialect
extends JDBCSQLDialect
implements SQLDialectSchemaController {
    public static final String[] MYSQL_NON_TRANSACTIONAL_KEYWORDS = (String[])ArrayUtils.concatArrays((Object[])BasicSQLDialect.NON_TRANSACTIONAL_KEYWORDS, (Object[])new String[]{"USE", "SHOW", "CREATE", "ALTER", "DROP", "EXPLAIN", "DESCRIBE", "DESC"});
    private static final String[] ADVANCED_KEYWORDS = new String[]{"AUTO_INCREMENT", "DATABASES", "COLUMNS", "ALGORITHM", "REPAIR", "ENGINE"};
    public static final String[][] MYSQL_QUOTE_STRINGS = new String[][]{{"`", "`"}, {"\"", "\""}};
    private static final String[] MYSQL_EXTRA_FUNCTIONS = new String[]{"ADDDATE", "ADDTIME", "ANY_VALUE", "CAST", "COALESCE", "COLLATION", "COMPRESS", "DATE_ADD", "DATE_SUB", "DATEDIFF", "EXTRACT", "FIRST_VALUE", "FORMAT", "FOUND_ROWS", "FROM_BASE64", "GET_FORMAT", "GROUP_CONCAT", "HOUR", "DAY", "IFNULL", "ISNULL", "LAG", "LAST_VALUE", "LEAD", "LEAST", "LENGTH", "MAKEDATE", "MAKETIME", "MINUTE", "MONTH", "NULLIF", "RANDOM_BYTES", "REPLACE", "REGEXP_LIKE", "REGEXP_INSTR", "REGEXP_REPLACE", "REGEXP_SUBSTR", "SESSION_USER", "SPACE", "SUBSTR", "SUBTIME", "TIMEDIFF", "TO_BASE64", "TO_SECONDS", "UUID", "UUID_TO_BIN", "WEEKOFYEAR", "YEAR"};
    private static final String[] MYSQL_GEOMETRY_FUNCTIONS = new String[]{"ST_ASWKT", "ST_GEOMCOLLFROMTEXT", "ST_GEOMETRYCOLLECTIONFROMTEXT", "ST_GEOMFROMTEXT", "ST_LINEFROMTEXT", "ST_MLINEFROMTEXT", "ST_MPOINTFROMTEXT", "ST_MPOLYFROMTEXT", "ST_POINTFROMTEXT", "ST_POLYFROMTEXT"};
    private static final String[] JSON_FUNCTIONS = new String[]{"JSON_ARRAY", "JSON_ARRAYAGG", "JSON_ARRAY_APPEND", "JSON_ARRAY_INSERT", "JSON_CONTAINS", "JSON_CONTAINS_PATH", "JSON_DEPTH", "JSON_EXTRACT", "JSON_INSERT", "JSON_KEYS", "JSON_LENGTH", "JSON_MERGE", "JSON_MERGE_PATCH", "JSON_MERGE_PRESERVE", "JSON_OBJECT", "JSON_OBJECTAGG", "JSON_QUOTE", "JSON_REMOVE", "JSON_REPLACE", "JSON_SEARCH", "JSON_SET", "JSON_TABLE", "JSON_TYPE", "JSON_UNQUOTE", "JSON_VALID", "JSON_VALUE"};
    private static final Pattern ONE_OR_MORE_DIGITS_PATTERN = Pattern.compile("[0-9]+");
    private static final String[] EXEC_KEYWORDS = new String[]{"CALL"};
    private int lowerCaseTableNames;

    public MySQLDialect() {
        super("MySQL", "mysql");
    }

    public MySQLDialect(String name, String id) {
        super(name, id);
    }

    public void initBaseDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.lowerCaseTableNames = ((MySQLDataSource)dataSource).getLowerCaseTableNames();
        this.setSupportsUnquotedMixedCase(this.lowerCaseTableNames != 2);
        this.addTableQueryKeywords(new String[]{"EXPLAIN", "DESCRIBE", "DESC"});
        this.addFunctions(List.of("SLEEP"));
        this.addSQLKeywords(Arrays.asList(ADVANCED_KEYWORDS));
        this.removeSQLKeyword("SOURCE");
        this.removeSQLKeyword("CHAR");
        this.addDataTypes(List.of("CHAR"));
        this.addFunctions(Arrays.asList(MYSQL_EXTRA_FUNCTIONS));
        this.addFunctions(Arrays.asList(JSON_FUNCTIONS));
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        this.initBaseDriverSettings(session, dataSource, metaData);
        this.addDataTypes(Arrays.asList("GEOMETRY", "POINT"));
        this.addFunctions(Arrays.asList(MYSQL_GEOMETRY_FUNCTIONS));
    }

    @Nullable
    public String[][] getIdentifierQuoteStrings() {
        return MYSQL_QUOTE_STRINGS;
    }

    @NotNull
    public String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    public int getSchemaUsage() {
        return Integer.MAX_VALUE;
    }

    public char getStringEscapeCharacter() {
        return '\\';
    }

    @Nullable
    public String getScriptDelimiterRedefiner() {
        return "DELIMITER";
    }

    public String[][] getBlockBoundStrings() {
        return null;
    }

    public boolean useCaseInsensitiveNameLookup() {
        return this.lowerCaseTableNames != 0;
    }

    public boolean mustBeQuoted(String str, boolean forceCaseSensitive) {
        Matcher matcher = ONE_OR_MORE_DIGITS_PATTERN.matcher(str);
        if (matcher.lookingAt()) {
            return true;
        }
        return super.mustBeQuoted(str, forceCaseSensitive);
    }

    @NotNull
    protected String quoteIdentifier(@NotNull String str, @NotNull String[][] quoteStrings) {
        return quoteStrings[0][0] + this.escapeString(str, quoteStrings[0]) + quoteStrings[0][1];
    }

    @NotNull
    public String escapeString(String string) {
        return this.escapeString(string, null);
    }

    @NotNull
    protected String escapeString(@NotNull String string, @Nullable String[] quotes) {
        string = quotes != null ? string.replace(quotes[0], quotes[0] + quotes[0]) : string.replace("'", "''").replace("`", "``");
        return string.replaceAll("\\\\(?![_%?])", "\\\\\\\\");
    }

    @NotNull
    public String unEscapeString(String string) {
        return string.replace("''", "'").replace("``", "`").replace("\\\\", "\\");
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean supportsTableDropCascade() {
        return true;
    }

    public boolean supportsCommentQuery() {
        return true;
    }

    public String[] getSingleLineComments() {
        return new String[]{"-- ", "--\t", "#"};
    }

    public String getTestSQL() {
        return "SELECT 1";
    }

    @NotNull
    public String[] getNonTransactionKeywords() {
        return MYSQL_NON_TRANSACTIONAL_KEYWORDS;
    }

    public boolean isAmbiguousCountBroken() {
        return true;
    }

    protected boolean useBracketsForExec(DBSProcedure procedure) {
        return procedure.getProcedureType() == DBSProcedureType.PROCEDURE;
    }

    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        if (attribute.getTypeName().equalsIgnoreCase("json")) {
            return "'" + this.escapeString(strValue) + "'";
        }
        return super.escapeScriptValue(attribute, value, strValue);
    }

    public boolean validIdentifierStart(char c) {
        return Character.isLetterOrDigit(c);
    }

    @NotNull
    public String getTypeCastClause(@NotNull DBSTypedObject attribute, @NotNull String expression, boolean isInCondition) {
        if (isInCondition && attribute.getTypeName().equalsIgnoreCase("json")) {
            return "CAST(" + expression + " AS JSON)";
        }
        return super.getTypeCastClause(attribute, expression, isInCondition);
    }

    @NotNull
    public String getSchemaExistQuery(@NotNull String schemaName) {
        return "SHOW DATABASES LIKE " + this.getQuotedString(schemaName);
    }

    @NotNull
    public String getCreateSchemaQuery(@NotNull String schemaName) {
        return "CREATE DATABASE " + schemaName;
    }
}

