/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import java.util.StringJoiner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Version;

public class DatabaseNavigatorLabelProvider
extends ColumnLabelProvider
implements IFontProvider,
IColorProvider {
    public static final String TREE_TABLE_FONT = "org.eclipse.ui.workbench.TREE_TABLE_FONT";
    private final IPropertyChangeListener themeChangeListener;
    protected Font normalFont;
    protected Font boldFont;
    protected Font italicFont;
    protected Color lockedForeground = Display.getDefault().getSystemColor(16);
    protected Color transientForeground = Display.getDefault().getSystemColor(4);
    private ILabelDecorator labelDecorator;

    public DatabaseNavigatorLabelProvider(@NotNull DatabaseNavigatorTree tree) {
        this.themeChangeListener = e -> {
            ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            this.normalFont = theme.getFontRegistry().get(TREE_TABLE_FONT);
            this.boldFont = theme.getFontRegistry().getBold(TREE_TABLE_FONT);
            this.italicFont = theme.getFontRegistry().getItalic(TREE_TABLE_FONT);
            TreeViewer viewer = tree.getViewer();
            viewer.getControl().setFont(this.normalFont);
            viewer.refresh();
            Text filter = tree.getFilterControl();
            if (filter != null) {
                filter.setFont(this.normalFont);
            }
        };
        this.themeChangeListener.propertyChange(null);
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeChangeListener);
    }

    public void dispose() {
        PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeChangeListener);
        super.dispose();
    }

    ILabelDecorator getLabelDecorator() {
        return this.labelDecorator;
    }

    void setLabelDecorator(ILabelDecorator labelDecorator) {
        this.labelDecorator = labelDecorator;
    }

    public String getText(Object obj) {
        Object text = null;
        if (obj instanceof ILabelProvider) {
            text = ((ILabelProvider)obj).getText(obj);
        } else if (obj instanceof DBNNode) {
            String briefInfo;
            text = ((DBNNode)obj).getNodeName();
            if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.objects.tips") && !CommonUtils.isEmpty((String)(briefInfo = ((DBNNode)obj).getNodeBriefInfo()))) {
                text = (String)text + " (" + briefInfo + ")";
            }
        } else if (obj != null) {
            text = obj.toString();
        }
        if (text == null) {
            text = "?";
        }
        if (this.isFilteredElement(obj)) {
            text = (String)text + " (...)";
        }
        return text;
    }

    public Image getImage(Object obj) {
        Image image = null;
        if (obj instanceof ILabelProvider) {
            image = ((ILabelProvider)obj).getImage(obj);
        } else if (obj instanceof DBNNode) {
            image = DBeaverIcons.getImage((DBPImage)((DBNNode)obj).getNodeIconDefault());
        }
        if (this.labelDecorator != null && obj instanceof DBNResource) {
            image = this.labelDecorator.decorateImage(image, obj);
        }
        return image;
    }

    public Font getFont(Object element) {
        DBPDataSourceContainer ds;
        if (DBNUtils.isDefaultElement((Object)element)) {
            return this.boldFont;
        }
        if (element instanceof DBNDataSource && (ds = ((DBNDataSource)element).getDataSourceContainer()) != null && (ds.isProvided() || ds.isTemporary())) {
            return this.italicFont;
        }
        return this.normalFont;
    }

    public Color getForeground(Object element) {
        if (element instanceof DBNNode) {
            DBNNode node = (DBNNode)element;
            if (node instanceof DBNDataSource) {
                DBPDataSourceContainer ds = ((DBNDataSource)element).getDataSourceContainer();
                Color bgColor = UIUtils.getConnectionColor((DBPConnectionConfiguration)ds.getConnectionConfiguration());
                return bgColor == null ? null : UIUtils.getContrastColor((Color)bgColor);
            }
            if (node.isLocked()) {
                return this.lockedForeground;
            }
            if (node instanceof DBSWrapper && ((DBSWrapper)node).getObject() != null && !((DBSWrapper)node).getObject().isPersisted()) {
                return this.transientForeground;
            }
        }
        if (element instanceof TreeNodeSpecial) {
            return this.lockedForeground;
        }
        return null;
    }

    public Color getBackground(Object element) {
        DBPDataSourceContainer ds;
        if (element instanceof DBNDataSource && (ds = ((DBNDataSource)element).getDataSourceContainer()) != null) {
            return UIUtils.getConnectionColor((DBPConnectionConfiguration)ds.getConnectionConfiguration());
        }
        return null;
    }

    private boolean isFilteredElement(Object element) {
        return element instanceof DBNNode && ((DBNNode)element).isFiltered();
    }

    /*
     * WARNING - void declaration
     */
    public String getToolTipText(Object element) {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.tooltips")) {
            return null;
        }
        if (element instanceof DBNDataSource) {
            DBPDataSourceContainer ds = ((DBNDataSource)element).getDataSourceContainer();
            if (ds != null) {
                Version databaseVersion;
                StringJoiner tooltip = new StringJoiner("\n");
                tooltip.add(NLS.bind((String)UINavigatorMessages.navigator_provider_element_tooltip_datasource_name, (Object)ds.getName()));
                DBPConnectionConfiguration cfg = ds.getConnectionConfiguration();
                if (!CommonUtils.isEmpty((String)cfg.getUrl())) {
                    tooltip.add(NLS.bind((String)UINavigatorMessages.navigator_provider_element_tooltip_datasource_url, (Object)cfg.getUrl()));
                } else if (!CommonUtils.isEmpty((String)cfg.getDatabaseName())) {
                    tooltip.add(NLS.bind((String)UINavigatorMessages.navigator_provider_element_tooltip_datasource_database_name, (Object)cfg.getDatabaseName()));
                }
                DBPDataSource dataSource = ds.getDataSource();
                if (dataSource != null && (databaseVersion = dataSource.getInfo().getDatabaseVersion()) != null) {
                    tooltip.add(NLS.bind((String)UINavigatorMessages.navigator_provider_element_tooltip_datasource_database_version, (Object)databaseVersion.toString()));
                }
                if (!CommonUtils.isEmpty((String)cfg.getUserName())) {
                    tooltip.add(NLS.bind((String)UINavigatorMessages.navigator_provider_element_tooltip_datasource_user, (Object)cfg.getUserName()));
                }
                if (!CommonUtils.isEmpty((String)ds.getDescription())) {
                    tooltip.add(NLS.bind((String)UINavigatorMessages.navigator_provider_element_tooltip_datasource_description, (Object)ds.getDescription()));
                }
                if (ds.isConnectionReadOnly()) {
                    tooltip.add(UINavigatorMessages.navigator_provider_element_tooltip_datasource_read_only);
                }
                if (ds.isProvided()) {
                    tooltip.add(UINavigatorMessages.navigator_provider_element_tooltip_datasource_provided);
                }
                if (ds.getConnectionError() != null) {
                    tooltip.add(NLS.bind((String)UINavigatorMessages.navigator_provider_element_tooltip_datasource_error, (Object)ds.getConnectionError()));
                }
                return tooltip.toString();
            }
        } else {
            if (element instanceof DBNNode) {
                if (element instanceof DBNResource && !DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.tooltips.file.contents")) {
                    return null;
                }
                String description = ((DBNNode)element).getNodeDescription();
                if (!CommonUtils.isEmptyTrimmed((String)description)) {
                    return description;
                }
                return ((DBNNode)element).getNodeName();
            }
            Object object = element;
            if (object instanceof IToolTipProvider) {
                void provider;
                IToolTipProvider description = (IToolTipProvider)object;
                IToolTipProvider cfr_ignored_0 = (IToolTipProvider)object;
                return provider.getToolTipText(element);
            }
        }
        return null;
    }

    public Image getToolTipImage(Object element) {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.tooltips")) {
            return null;
        }
        if (element instanceof DBNNode) {
            return DBeaverIcons.getImage((DBPImage)((DBNNode)element).getNodeIconDefault());
        }
        return null;
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 0;
    }

    public int getToolTipStyle(Object object) {
        return super.getToolTipStyle(object);
    }

    public boolean useNativeToolTip(Object object) {
        return true;
    }
}

