/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class NavigatorHandlerSaveResource
extends AbstractHandler
implements IElementUpdater {
    public static final int DIRECTORY_FILE_SIZE = 1000;
    public static final int FILES_SIZE_MONITOR_DIV = 1;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        List<DBNPathBase> pathNodes = NavigatorUtils.getSelectedNodes(HandlerUtil.getCurrentSelection((ExecutionEvent)event)).stream().filter(n -> n instanceof DBNPathBase).map(n -> (DBNPathBase)n).toList();
        if (pathNodes.isEmpty()) {
            return null;
        }
        if (pathNodes.size() == 1 && !pathNodes.get(0).allowsChildren()) {
            this.saveSingleFile(shell, pathNodes.get(0));
        } else {
            this.saveMultipleResources(shell, pathNodes);
        }
        return null;
    }

    private void saveSingleFile(Shell shell, DBNPathBase pathNode) {
        FileDialog saveDialog = new FileDialog(shell, 8192);
        saveDialog.setFileName(pathNode.getName());
        String targetPath = DialogUtils.openFileDialog((FileDialog)saveDialog);
        if (targetPath == null) {
            return;
        }
        Path targetFile = Path.of(targetPath, new String[0]);
        if (Files.exists(targetFile, new LinkOption[0]) && !UIUtils.confirmAction((Shell)shell, (String)"File exists", (String)("Overwrite file '" + String.valueOf(targetFile.toAbsolutePath()) + "'?"))) {
            return;
        }
        try {
            UIUtils.runInProgressDialog(monitor -> {
                try {
                    Path sourcePath = pathNode.getPath();
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStream is = Files.newInputStream(sourcePath, new OpenOption[0]);){
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try (OutputStream os = Files.newOutputStream(targetFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                            ContentUtils.copyStreams((InputStream)is, (long)Files.size(sourcePath), (OutputStream)os, (DBRProgressMonitor)monitor);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("File save IO error", null, (Throwable)e);
        }
    }

    private void saveMultipleResources(Shell shell, List<DBNPathBase> nodes) {
        String targetPath = DialogUtils.openDirectoryDialog((Shell)shell, (String)"Choose target folder", null);
        if (targetPath == null) {
            return;
        }
        ArrayList<DBNPathBase> dupList = new ArrayList<DBNPathBase>();
        block0: for (DBNPathBase node : nodes) {
            for (DBNPathBase n2 : nodes) {
                if (!node.isChildOf((DBNNode)n2)) continue;
                dupList.add(n2);
                continue block0;
            }
        }
        nodes = nodes.stream().filter(n -> !dupList.contains(n)).collect(Collectors.toList());
        this.saveMultipleResources(shell, Path.of(targetPath, new String[0]), nodes);
    }

    private void saveMultipleResources(Shell shell, Path targetFolder, List<DBNPathBase> nodes) {
        try {
            UIUtils.runInProgressDialog(monitor -> {
                try {
                    Map<DBNPathBase, List<PathInfo>> sourceResources = this.collectSourceFiles(nodes, monitor);
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.saveSourceFiles(monitor, shell, sourceResources, targetFolder);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("File save IO error", null, (Throwable)e);
        }
    }

    private void saveSourceFiles(DBRProgressMonitor monitor, Shell shell, Map<DBNPathBase, List<PathInfo>> sourceResources, Path targetFolder) {
        long totalFilesSize = 0L;
        for (Map.Entry<DBNPathBase, List<PathInfo>> srcPathEntry : sourceResources.entrySet()) {
            for (PathInfo itemPath : srcPathEntry.getValue()) {
                totalFilesSize += itemPath.size;
            }
        }
        monitor.beginTask("Save resources", (int)(totalFilesSize / 1L));
        for (Map.Entry<DBNPathBase, List<PathInfo>> srcPathEntry : sourceResources.entrySet()) {
            Path srcPath = srcPathEntry.getKey().getPath();
            Path srcParent = srcPath.getParent();
            String basePath = (srcParent == null ? srcPath : srcParent).toAbsolutePath().toString();
            block15: for (PathInfo itemPath : srcPathEntry.getValue()) {
                if (monitor.isCanceled()) {
                    return;
                }
                String srcFilePath = URLDecoder.decode(itemPath.path.toAbsolutePath().toString(), StandardCharsets.UTF_8);
                monitor.subTask(srcFilePath + (String)(itemPath.directory ? "" : " (" + ByteNumberFormat.getInstance().format(itemPath.size) + ")"));
                if (srcFilePath.startsWith(basePath)) {
                    srcFilePath = srcFilePath.substring(basePath.length());
                }
                srcFilePath = CommonUtils.removeLeadingSlash((String)srcFilePath);
                Path targetPath = targetFolder.resolve(srcFilePath);
                try {
                    if (itemPath.directory) {
                        if (!Files.exists(targetPath, new LinkOption[0])) {
                            Files.createDirectories(targetPath, new FileAttribute[0]);
                        }
                        monitor.worked(1000);
                        continue;
                    }
                    byte[] buffer = new byte[10000];
                    Throwable throwable = null;
                    Object var18_19 = null;
                    try (InputStream is = Files.newInputStream(itemPath.path, new OpenOption[0]);){
                        Throwable throwable2 = null;
                        Object var21_24 = null;
                        try (OutputStream os = Files.newOutputStream(targetPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                            while (true) {
                                if (monitor.isCanceled()) {
                                    continue block15;
                                }
                                int count = is.read(buffer);
                                if (count <= 0) {
                                    continue block15;
                                }
                                monitor.worked(count / 1);
                                os.write(buffer, 0, count);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    DBWorkbench.getPlatformUI().showError("IO error", null, (Throwable)e);
                }
            }
            monitor.worked(1);
        }
        monitor.done();
    }

    @NotNull
    private Map<DBNPathBase, List<PathInfo>> collectSourceFiles(List<DBNPathBase> nodes, final DBRProgressMonitor monitor) throws IOException {
        monitor.beginTask("Collect statistics", nodes.size());
        final LinkedHashMap<DBNPathBase, List<PathInfo>> sourceResources = new LinkedHashMap<DBNPathBase, List<PathInfo>>();
        for (final DBNPathBase node : nodes) {
            monitor.subTask(node.getNodeName());
            Path path = node.getPath();
            if (Files.isDirectory(path, new LinkOption[0])) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (monitor.isCanceled()) {
                            return FileVisitResult.TERMINATE;
                        }
                        monitor.subTask("Scan directory " + String.valueOf(dir.toAbsolutePath()));
                        sourceResources.computeIfAbsent(node, p -> new ArrayList()).add(NavigatorHandlerSaveResource.this.makePathInfo(dir, true));
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (monitor.isCanceled()) {
                            return FileVisitResult.TERMINATE;
                        }
                        sourceResources.computeIfAbsent(node, p -> new ArrayList()).add(NavigatorHandlerSaveResource.this.makePathInfo(file, false));
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                sourceResources.computeIfAbsent(node, p -> new ArrayList()).add(this.makePathInfo(path, false));
            }
            monitor.worked(1);
        }
        monitor.done();
        return sourceResources;
    }

    private PathInfo makePathInfo(Path path, boolean directory) throws IOException {
        return new PathInfo(path, directory ? 0L : Files.size(path), directory);
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    private static class PathInfo {
        Path path;
        long size;
        boolean directory;

        public PathInfo(Path path, long size, boolean directory) {
            this.path = path;
            this.size = size;
            this.directory = directory;
        }
    }
}

