/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDContentStorage;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.stream.IAppendableDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferUtils;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.QuoteStrategy;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterCSV
extends StreamExporterAbstract
implements IAppendableDataExporter {
    private static final String PROP_DELIMITER = "delimiter";
    private static final String PROP_ROW_DELIMITER = "rowDelimiter";
    private static final String PROP_HEADER = "header";
    private static final String PROP_HEADER_FORMAT = "headerFormat";
    private static final String PROP_QUOTE_CHAR = "quoteChar";
    private static final String PROP_QUOTE_ALWAYS = "quoteAlways";
    private static final String PROP_QUOTE_NEVER = "quoteNever";
    private static final String PROP_NULL_STRING = "nullString";
    private static final String PROP_FORMAT_NUMBERS = "formatNumbers";
    private static final String DEF_QUOTE_CHAR = "\"";
    private boolean formatNumbers;
    private static final String ROW_DELIMITER_DEFAULT = "default";
    private String delimiter;
    private char quoteChar = (char)34;
    private boolean useQuotes = true;
    private QuoteStrategy quoteStrategy = QuoteStrategy.DISABLED;
    private String rowDelimiter;
    private String nullString;
    private HeaderPosition headerPosition;
    private HeaderFormat headerFormat;
    private DBDAttributeBinding[] columns;
    private final StringBuilder buffer = new StringBuilder();

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        Object nullStringProp;
        Object quoteProp;
        String quoteStr;
        super.init(site);
        Map<String, Object> properties = site.getProperties();
        this.delimiter = StreamTransferUtils.getDelimiterString(properties, PROP_DELIMITER);
        this.rowDelimiter = StreamTransferUtils.getDelimiterString(properties, PROP_ROW_DELIMITER);
        if (ROW_DELIMITER_DEFAULT.equalsIgnoreCase(this.rowDelimiter.trim())) {
            this.rowDelimiter = GeneralUtils.getDefaultLineSeparator();
        }
        String string = quoteStr = (quoteProp = properties.get(PROP_QUOTE_CHAR)) == null ? DEF_QUOTE_CHAR : quoteProp.toString();
        if (!CommonUtils.isEmpty((String)quoteStr)) {
            this.quoteChar = quoteStr.charAt(0);
        }
        if (CommonUtils.toBoolean((Object)properties.get(PROP_QUOTE_NEVER))) {
            this.quoteChar = (char)32;
        }
        this.nullString = (nullStringProp = properties.get(PROP_NULL_STRING)) == null ? null : nullStringProp.toString();
        this.useQuotes = this.quoteChar != ' ';
        this.quoteStrategy = QuoteStrategy.fromValue(CommonUtils.toString((Object)properties.get(PROP_QUOTE_ALWAYS)));
        if (this.headerPosition == null) {
            this.headerPosition = (HeaderPosition)CommonUtils.valueOf(HeaderPosition.class, (String)String.valueOf(properties.get(PROP_HEADER)), (Enum)HeaderPosition.top);
        }
        this.headerFormat = (HeaderFormat)CommonUtils.valueOf(HeaderFormat.class, (String)String.valueOf(properties.get(PROP_HEADER_FORMAT)), (Enum)HeaderFormat.label);
        this.formatNumbers = CommonUtils.toBoolean((Object)this.getSite().getProperties().get(PROP_FORMAT_NUMBERS));
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected DBDDisplayFormat getValueExportFormat(DBDAttributeBinding column) {
        if (column.getDataKind() == DBPDataKind.NUMERIC && !this.formatNumbers || column.getDataKind() == DBPDataKind.ARRAY) {
            return DBDDisplayFormat.NATIVE;
        }
        return super.getValueExportFormat(column);
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        if (this.headerPosition == HeaderPosition.top || this.headerPosition == HeaderPosition.both) {
            if (this.headerFormat != HeaderFormat.label) {
                DBSEntity srcEntity = (DBSEntity)DBUtils.getAdapter(DBSEntity.class, (Object)this.getSite().getSource());
                DBExecUtils.bindAttributes((DBCSession)session, (DBSEntity)srcEntity, null, (DBDAttributeBinding[])this.columns, null);
            }
            this.printHeader();
        }
    }

    private void printHeader() {
        int i = 0;
        int columnsSize = this.columns.length;
        while (i < columnsSize) {
            DBDAttributeBinding column = this.columns[i];
            Object colName = column.getName();
            if (this.headerFormat == HeaderFormat.description) {
                colName = column.getDescription();
                if (colName == null) {
                    colName = column.getLabel();
                }
            } else {
                String description;
                String colLabel = column.getLabel();
                if (CommonUtils.equalObjects((Object)colLabel, (Object)colName)) {
                    colName = column.getParentObject() == null ? column.getName() : DBUtils.getObjectFullName((DBPNamedObject)column, (DBPEvaluationContext)DBPEvaluationContext.UI);
                } else if (!CommonUtils.isEmpty((String)colLabel)) {
                    colName = colLabel;
                }
                if (this.headerFormat == HeaderFormat.both && !CommonUtils.isEmpty((String)(description = column.getDescription()))) {
                    colName = (String)colName + ":" + description;
                }
            }
            this.writeCellValue((String)colName, true);
            if (i < columnsSize - 1) {
                this.writeDelimiter();
            }
            ++i;
        }
        this.writeRowLimit();
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        int i = 0;
        while (i < row.length && i < this.columns.length) {
            DBDAttributeBinding column = this.columns[i];
            if (row[i] instanceof DBDContent) {
                DBDContent content = (DBDContent)row[i];
                try {
                    DBDContentStorage cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) {
                        this.writeCellValue("[NULL]", false);
                    }
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        this.writeCellValue(cs.getContentReader());
                    }
                    this.getSite().writeBinaryData(cs);
                }
                finally {
                    DTUtils.closeContents(resultSet, content);
                }
            } else {
                String stringValue = super.getValueDisplayString(column, row[i]);
                boolean quote = false;
                if (this.quoteStrategy == QuoteStrategy.DISABLED) {
                    if (!stringValue.isEmpty() && !(row[i] instanceof Number) && !(row[i] instanceof Date) && Character.isDigit(stringValue.charAt(0))) {
                        quote = true;
                    }
                } else if (this.quoteStrategy == QuoteStrategy.STRINGS) {
                    if (!(stringValue.isEmpty() || row[i] instanceof Number || row[i] instanceof Date)) {
                        quote = true;
                    }
                } else if (this.quoteStrategy == QuoteStrategy.ALL_BUT_NUMBERS) {
                    if (!(row[i] instanceof Number)) {
                        quote = true;
                    }
                } else if (this.quoteStrategy == QuoteStrategy.ALL_BUT_NULLS && !DBUtils.isNullValue((Object)row[i])) {
                    quote = true;
                }
                if (DBUtils.isNullValue((Object)row[i])) {
                    if (CommonUtils.isNotEmpty((String)this.nullString)) {
                        this.writeCellValue(this.nullString, quote);
                    }
                } else {
                    this.writeCellValue(stringValue, quote);
                }
            }
            if (i < row.length - 1) {
                this.writeDelimiter();
            }
            ++i;
        }
        this.writeRowLimit();
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) {
        if (this.headerPosition == HeaderPosition.bottom || this.headerPosition == HeaderPosition.both) {
            this.printHeader();
        }
    }

    @Override
    public void importData(@NotNull IStreamDataExporterSite site) {
        Path file = site.getOutputFile();
        if (file == null || !Files.exists(file, new LinkOption[0])) {
            return;
        }
        this.headerPosition = HeaderPosition.none;
    }

    @Override
    public boolean shouldTruncateOutputFileBeforeExport() {
        return false;
    }

    private void writeCellValue(String value, boolean quote) {
        boolean hasQuotes;
        if (!this.useQuotes) {
            quote = false;
        }
        boolean bl = hasQuotes = this.useQuotes && value.indexOf(this.quoteChar) != -1;
        if (this.quoteStrategy == QuoteStrategy.ALL || this.useQuotes && value.isEmpty()) {
            quote = true;
        } else if (!quote && (hasQuotes || value.contains(this.delimiter) || value.indexOf(13) != -1 || value.indexOf(10) != -1 || value.contains(this.rowDelimiter))) {
            quote = true;
        }
        if (quote && hasQuotes) {
            this.buffer.setLength(0);
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (c == this.quoteChar) {
                    this.buffer.append(this.quoteChar);
                }
                this.buffer.append(c);
                ++i;
            }
            value = this.buffer.toString();
        }
        PrintWriter out = this.getWriter();
        if (quote && this.useQuotes) {
            out.write(this.quoteChar);
        }
        out.write(value);
        if (quote && this.useQuotes) {
            out.write(this.quoteChar);
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        try {
            int count;
            PrintWriter out = this.getWriter();
            if (this.useQuotes) {
                out.write(this.quoteChar);
            }
            char[] buffer = new char[2000];
            while ((count = reader.read(buffer)) > 0) {
                int i = 0;
                while (i < count) {
                    if (this.useQuotes && buffer[i] == this.quoteChar) {
                        out.write(this.quoteChar);
                    }
                    out.write(buffer[i]);
                    ++i;
                }
            }
            if (this.useQuotes) {
                out.write(this.quoteChar);
            }
        }
        finally {
            ContentUtils.close((Closeable)reader);
        }
    }

    private void writeDelimiter() {
        this.getWriter().write(this.delimiter);
    }

    private void writeRowLimit() {
        this.getWriter().write(this.rowDelimiter);
    }

    static enum HeaderFormat {
        label,
        description,
        both;

    }

    static enum HeaderPosition {
        none,
        top,
        bottom,
        both;

    }
}

