/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.AgentConnector;
import com.jcraft.jsch.AgentIdentityRepository;
import com.jcraft.jsch.JUnixSocketFactory;
import com.jcraft.jsch.PageantConnector;
import com.jcraft.jsch.SSHAgentConnector;
import com.jcraft.jsch.USocketFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWUtils;
import org.jkiss.dbeaver.model.net.ssh.SSHConstants;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementation;
import org.jkiss.dbeaver.model.net.ssh.SSHUtils;
import org.jkiss.dbeaver.model.net.ssh.config.SSHAuthConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHHostConfiguration;
import org.jkiss.dbeaver.model.net.ssh.config.SSHPortForwardConfiguration;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationDescriptor;
import org.jkiss.dbeaver.model.net.ssh.registry.SSHImplementationRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public abstract class SSHImplementationAbstract
implements SSHImplementation {
    private static final Log log = Log.getLog(SSHImplementationAbstract.class);
    private transient int savedLocalPort = 0;
    protected transient DBWHandlerConfiguration savedConfiguration;
    protected transient DBPConnectionConfiguration savedConnectionInfo;
    protected AgentIdentityRepository agentIdentityRepository;

    @Override
    public DBPConnectionConfiguration initTunnel(DBRProgressMonitor monitor, DBWHandlerConfiguration configuration, DBPConnectionConfiguration connectionInfo) throws DBException, IOException {
        String prefix;
        String dbPortString = connectionInfo.getHostPort();
        if (CommonUtils.isEmpty((String)dbPortString) && CommonUtils.isEmpty((String)(dbPortString = configuration.getDriver().getDefaultPort()))) {
            throw new DBException("Database port not specified and no default port number for driver '" + configuration.getDriver().getName() + "'");
        }
        int connectTimeout = configuration.getIntProperty("sshConnectTimeout");
        String sshLocalHost = CommonUtils.toString((Object)configuration.getProperty("localHost"));
        int sshLocalPort = configuration.getIntProperty("localPort");
        String sshRemoteHost = CommonUtils.toString((Object)configuration.getProperty("remoteHost"));
        int sshRemotePort = configuration.getIntProperty("remotePort");
        if (sshLocalPort == 0) {
            sshLocalPort = this.savedLocalPort != 0 ? this.savedLocalPort : SSHUtils.findFreePort();
        }
        if (CommonUtils.isEmpty((String)sshRemoteHost)) {
            sshRemoteHost = connectionInfo.getHostName();
        }
        if (sshRemotePort == 0 && configuration.getDriver() != null) {
            sshRemotePort = CommonUtils.toInt((Object)connectionInfo.getHostPort());
        }
        if (connectTimeout == 0) {
            configuration.setProperty("sshConnectTimeout", (Object)10000);
        }
        SSHPortForwardConfiguration portForwardConfiguration = new SSHPortForwardConfiguration(sshLocalHost, sshLocalPort, sshRemoteHost, sshRemotePort);
        ArrayList<SSHHostConfiguration> hostConfigurations = new ArrayList<SSHHostConfiguration>();
        hostConfigurations.add(SSHImplementationAbstract.loadConfiguration(configuration, ""));
        if (this.isSupportsJumpServer() && configuration.getBooleanProperty((prefix = SSHImplementationAbstract.getJumpServerSettingsPrefix(0)) + "enabled")) {
            hostConfigurations.add(0, SSHImplementationAbstract.loadConfiguration(configuration, prefix));
        }
        for (SSHHostConfiguration host : hostConfigurations) {
            if (host.getAuthConfiguration().getType() != SSHConstants.AuthType.AGENT) continue;
            PageantConnector connector = null;
            try {
                connector = new PageantConnector();
                log.debug((Object)"SSH: Connected with pageant");
            }
            catch (Exception e) {
                log.debug((Object)"pageant connect exception", (Throwable)e);
            }
            if (connector == null) {
                try {
                    connector = new SSHAgentConnector((USocketFactory)new JUnixSocketFactory());
                    log.debug((Object)"SSH: Connected with ssh-agent");
                }
                catch (Exception e) {
                    log.debug((Object)"ssh-agent connection exception", (Throwable)e);
                }
            }
            if (connector == null) {
                throw new DBException("Unable to initialize SSH agent");
            }
            this.agentIdentityRepository = new AgentIdentityRepository((AgentConnector)connector);
            break;
        }
        this.setupTunnel(monitor, configuration, hostConfigurations.toArray(new SSHHostConfiguration[0]), portForwardConfiguration);
        this.savedLocalPort = sshLocalPort;
        this.savedConfiguration = configuration;
        this.savedConnectionInfo = connectionInfo;
        connectionInfo = new DBPConnectionConfiguration(connectionInfo);
        DBWUtils.updateConfigWithTunnelInfo((DBWHandlerConfiguration)configuration, (DBPConnectionConfiguration)connectionInfo, (String)sshLocalHost, (int)sshLocalPort);
        return connectionInfo;
    }

    protected abstract void setupTunnel(@NotNull DBRProgressMonitor var1, @NotNull DBWHandlerConfiguration var2, @NotNull SSHHostConfiguration[] var3, @NotNull SSHPortForwardConfiguration var4) throws DBException, IOException;

    @NotNull
    private static SSHHostConfiguration loadConfiguration(@NotNull DBWHandlerConfiguration configuration, @NotNull String prefix) throws DBException {
        String password;
        String username;
        SSHConstants.AuthType authType = (SSHConstants.AuthType)CommonUtils.valueOf(SSHConstants.AuthType.class, (String)configuration.getStringProperty(prefix + "authType"), (Enum)SSHConstants.AuthType.PASSWORD);
        String hostname = configuration.getStringProperty(prefix + "host");
        int port = configuration.getIntProperty(prefix + "port");
        boolean savePassword = configuration.isSavePassword();
        if (prefix.isEmpty()) {
            username = CommonUtils.notEmpty((String)configuration.getUserName());
            password = CommonUtils.notEmpty((String)configuration.getPassword());
        } else {
            username = CommonUtils.notEmpty((String)configuration.getStringProperty(prefix + "name"));
            password = CommonUtils.notEmpty((String)configuration.getSecureProperty(prefix + "password"));
        }
        if (CommonUtils.isEmpty((String)hostname)) {
            throw new DBException("SSH host not specified");
        }
        if (port == 0) {
            throw new DBException("SSH port not specified");
        }
        if (CommonUtils.isEmpty((String)username)) {
            username = System.getProperty("user.name");
        }
        return new SSHHostConfiguration(username, hostname, port, switch (authType) {
            case SSHConstants.AuthType.PUBLIC_KEY -> {
                String path = configuration.getStringProperty(prefix + "keyPath");
                if (CommonUtils.isEmpty((String)path)) {
                    String privKeyValue = configuration.getSecureProperty(prefix + "keyValue");
                    if (privKeyValue == null) {
                        throw new DBException("Private key not specified");
                    }
                    yield SSHAuthConfiguration.usingKey(privKeyValue, password, savePassword);
                }
                Path file = Path.of(path, new String[0]);
                if (!Files.exists(file, new LinkOption[0])) {
                    throw new DBException("Private key file '" + path + "' does not exist");
                }
                yield SSHAuthConfiguration.usingKey(file, password, savePassword);
            }
            case SSHConstants.AuthType.PASSWORD -> SSHAuthConfiguration.usingPassword(password, savePassword);
            default -> SSHAuthConfiguration.usingAgent();
        });
    }

    @NotNull
    public static String getJumpServerSettingsPrefix(int index) {
        return "jumpServer" + index + ".";
    }

    protected boolean isSupportsJumpServer() {
        for (SSHImplementationDescriptor descriptor : SSHImplementationRegistry.getInstance().getDescriptors()) {
            if (descriptor.getImplClass().getObjectClass() != this.getClass()) continue;
            return descriptor.isSupportsJumpServer();
        }
        return false;
    }
}

