/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleScanner;

public class SQLTokenAdapter
extends Token {
    private final TPToken token;

    public SQLTokenAdapter(TPToken token, SQLRuleScanner scanner) {
        super((Object)SQLTokenAdapter.makeTextAttribute(token, scanner));
        this.token = token;
    }

    public TPToken getToken() {
        return this.token;
    }

    public String toString() {
        return "Adapter of [" + this.token.toString() + "]";
    }

    private static TextAttribute makeTextAttribute(TPToken token, SQLRuleScanner scanner) {
        int style;
        String colorKey;
        if (token instanceof TPTokenDefault && token.getData() instanceof SQLTokenType) {
            switch ((SQLTokenType)token.getData()) {
                case T_KEYWORD: 
                case T_BLOCK_BEGIN: 
                case T_BLOCK_END: 
                case T_BLOCK_HEADER: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.keyword.foreground";
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_STRING: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.string.foreground";
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_QUOTED: 
                case T_TYPE: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.datatype.foreground";
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_NUMBER: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.number.foreground";
                    style = 0;
                    break;
                }
                case T_COMMENT: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.comment.foreground";
                    style = 0;
                    break;
                }
                case T_DELIMITER: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.delimiter.foreground";
                    style = 0;
                    break;
                }
                case T_BLOCK_TOGGLE: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.delimiter.foreground";
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_CONTROL: 
                case T_SET_DELIMITER: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.command.foreground";
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_PARAMETER: 
                case T_VARIABLE: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.parameter.foreground";
                    style = scanner.getKeywordStyle();
                    break;
                }
                case T_TABLE: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.table.foreground";
                    style = 0;
                    break;
                }
                case T_TABLE_ALIAS: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.table.alias.foreground";
                    style = 2;
                    break;
                }
                case T_COLUMN: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.column.foreground";
                    style = 0;
                    break;
                }
                case T_COLUMN_DERIVED: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.column.derived.foreground";
                    style = 2;
                    break;
                }
                case T_SCHEMA: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.schema.foreground";
                    style = 0;
                    break;
                }
                case T_SEMANTIC_ERROR: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.semanticError.foreground";
                    style = 0x40000003;
                    break;
                }
                default: {
                    colorKey = "org.jkiss.dbeaver.sql.editor.color.text.foreground";
                    style = 0;
                    break;
                }
            }
        } else {
            colorKey = "org.jkiss.dbeaver.sql.editor.color.text.foreground";
            style = 0;
        }
        Color color = scanner.getColor(colorKey);
        if (UIStyles.isDarkHighContrastTheme()) {
            color = "org.jkiss.dbeaver.sql.editor.color.text.foreground".equals(colorKey) ? UIUtils.COLOR_WHITE : UIUtils.getInvertedColor((Color)color);
        }
        return new TextAttribute(color, null, style);
    }
}

