/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.text.parser.TPCharacterScanner;
import org.jkiss.dbeaver.model.text.parser.TPPredicateRule;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.dbeaver.model.text.parser.TPTokenType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLDocumentSyntaxContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLScriptPosition;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLTokenAdapter;

public class SQLRuleScanner
extends RuleBasedScanner
implements TPCharacterScanner {
    @NotNull
    private final IThemeManager themeManager;
    @NotNull
    private TreeMap<Integer, SQLScriptPosition> positions = new TreeMap();
    private Set<SQLScriptPosition> addedPositions = new HashSet<SQLScriptPosition>();
    private Set<SQLScriptPosition> removedPositions = new HashSet<SQLScriptPosition>();
    private final HashMap<SQLTokenType, IToken> extraSyntaxTokens = new HashMap();
    private SQLEditorBase editor = null;
    private final Map<TPToken, IToken> tokenMap = new IdentityHashMap<TPToken, IToken>();
    private boolean evalMode;
    private int keywordStyle = 0;

    public SQLRuleScanner() {
        this.themeManager = PlatformUI.getWorkbench().getThemeManager();
    }

    public int getKeywordStyle() {
        return this.keywordStyle;
    }

    public void dispose() {
    }

    @NotNull
    public Collection<? extends Position> getPositions(int offset, int length) {
        return this.positions.subMap(offset, offset + length).values();
    }

    @NotNull
    public synchronized Set<SQLScriptPosition> getRemovedPositions(boolean clear) {
        Set<SQLScriptPosition> posList = this.removedPositions;
        if (clear) {
            this.removedPositions = new HashSet<SQLScriptPosition>();
        }
        return posList;
    }

    @NotNull
    public synchronized Set<SQLScriptPosition> getAddedPositions(boolean clear) {
        Set<SQLScriptPosition> posList = this.addedPositions;
        if (clear) {
            this.addedPositions = new HashSet<SQLScriptPosition>();
        }
        return posList;
    }

    public void refreshRules(@Nullable DBPDataSource dataSource, SQLRuleManager ruleManager, SQLEditorBase editor) {
        this.tokenMap.clear();
        boolean boldKeywords = dataSource == null ? DBWorkbench.getPlatform().getPreferenceStore().getBoolean("SQLEditor.format.boldKeywords") : dataSource.getContainer().getPreferenceStore().getBoolean("SQLEditor.format.boldKeywords");
        this.keywordStyle = boldKeywords ? 1 : 0;
        TPRule[] allRules = ruleManager.getAllRules();
        IRule[] result = new IRule[allRules.length];
        int i = 0;
        while (i < allRules.length) {
            result[i] = this.adaptRule(allRules[i]);
            ++i;
        }
        this.setRules(result);
        this.editor = editor;
    }

    private IRule adaptRule(TPRule rule) {
        if (rule instanceof TPPredicateRule) {
            return new PredicateRuleAdapter((TPPredicateRule)rule);
        }
        return new SimpleRuleAdapter(this, rule);
    }

    private IToken adaptToken(TPToken token) {
        if (token.isEOF()) {
            return Token.EOF;
        }
        if (token.isUndefined()) {
            return Token.UNDEFINED;
        }
        if (token.isWhitespace()) {
            return Token.WHITESPACE;
        }
        Object jfToken = this.tokenMap.get(token);
        if (jfToken == null) {
            jfToken = new SQLTokenAdapter(token, this);
            this.tokenMap.put(token, (IToken)jfToken);
        }
        return jfToken;
    }

    public Color getColor(String colorKey) {
        return this.getColor(colorKey, 2);
    }

    private Color getColor(String colorKey, int colorDefault) {
        ITheme currentTheme = this.themeManager.getCurrentTheme();
        Color color = currentTheme.getColorRegistry().get(colorKey);
        if (color == null) {
            color = Display.getDefault().getSystemColor(colorDefault);
        }
        return color;
    }

    public int getOffset() {
        return this.fOffset;
    }

    private IToken tryResolveExtraToken() {
        SQLDocumentSyntaxContext syntaxContext;
        SQLDocumentSyntaxContext sQLDocumentSyntaxContext = syntaxContext = this.editor == null ? null : this.editor.getSyntaxContext();
        if (syntaxContext == null) {
            return Token.UNDEFINED;
        }
        int offset = this.getOffset();
        SQLQuerySymbolEntry entry = syntaxContext.findToken(offset);
        if (entry != null) {
            int end = syntaxContext.getLastAccessedTokenOffset() + entry.getInterval().length();
            if (end > offset) {
                while (this.getOffset() < end) {
                    super.read();
                }
                return this.extraSyntaxTokens.computeIfAbsent(entry.getSymbolClass().getTokenType(), tt -> new SQLTokenAdapter((TPToken)new LazyToken((TPTokenType)tt), this));
            }
            return Token.UNDEFINED;
        }
        return Token.UNDEFINED;
    }

    public IToken nextToken() {
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.fRules != null) {
            IToken token = this.tryResolveExtraToken();
            if (!token.isUndefined()) {
                return token;
            }
            IRule[] iRuleArray = this.fRules;
            int n = this.fRules.length;
            int n2 = 0;
            while (n2 < n) {
                IRule fRule = iRuleArray[n2];
                IToken token2 = fRule.evaluate((ICharacterScanner)this);
                if (!token2.isUndefined()) {
                    return token2;
                }
                ++n2;
            }
        }
        if (this.read() == -1) {
            return Token.EOF;
        }
        return this.fDefaultReturnToken;
    }

    private static class LazyToken
    extends TPTokenDefault {
        public LazyToken(TPTokenType type) {
            super(type);
        }
    }

    private class PredicateRuleAdapter
    extends SimpleRuleAdapter<TPPredicateRule>
    implements IPredicateRule {
        PredicateRuleAdapter(TPPredicateRule rule) {
            super(SQLRuleScanner.this, (TPRule)rule);
        }

        public IToken getSuccessToken() {
            return SQLRuleScanner.this.adaptToken(((TPPredicateRule)this.rule).getSuccessToken());
        }

        public IToken evaluate(ICharacterScanner scanner, boolean resume) {
            return SQLRuleScanner.this.adaptToken(((TPPredicateRule)this.rule).evaluate((TPCharacterScanner)scanner, resume));
        }

        @Override
        public IToken evaluate(ICharacterScanner scanner) {
            return SQLRuleScanner.this.adaptToken(((TPPredicateRule)this.rule).evaluate((TPCharacterScanner)scanner));
        }

        public String toString() {
            return "Adapter of [" + ((TPPredicateRule)this.rule).toString() + "]";
        }
    }

    private static class SimpleRuleAdapter<RULE extends TPRule>
    implements IRule {
        protected final RULE rule;
        final /* synthetic */ SQLRuleScanner this$0;

        SimpleRuleAdapter(RULE rule) {
            this.this$0 = var1_1;
            this.rule = rule;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            return this.this$0.adaptToken(this.rule.evaluate((TPCharacterScanner)scanner));
        }
    }
}

