/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.syntax;

import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.impl.struct.DirectObjectReference;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.ui.editors.entity.EntityHyperlink;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLDocumentSyntaxContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLContextInformer;

public class SQLHyperlinkDetector
extends AbstractHyperlinkDetector {
    protected static final Log log = Log.getLog(SQLHyperlinkDetector.class);
    private SQLContextInformer contextInformer;

    public SQLHyperlinkDetector(SQLEditorBase editor, SQLContextInformer contextInformer) {
        this.contextInformer = contextInformer;
    }

    @Nullable
    public synchronized IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        this.contextInformer.searchInformation(region);
        if (!this.contextInformer.hasObjects() || this.contextInformer.getKeywordType() == DBPKeywordType.KEYWORD) {
            return this.findLocalScopeReference(region.getOffset());
        }
        SQLIdentifierDetector.WordRegion wordRegion = this.contextInformer.getWordRegion();
        Region hlRegion = new Region(wordRegion.identStart, wordRegion.identEnd - wordRegion.identStart);
        List<DBSObjectReference> references = this.contextInformer.getObjectReferences();
        IHyperlink[] links = new IHyperlink[references.size()];
        int i = 0;
        int objectsSize = references.size();
        while (i < objectsSize) {
            links[i] = new EntityHyperlink((IWorkbenchSite)this.contextInformer.getEditor().getSite(), references.get(i), (IRegion)hlRegion);
            ++i;
        }
        return links;
    }

    /*
     * WARNING - void declaration
     */
    private IHyperlink[] findLocalScopeReference(int offset) {
        SQLQuerySymbolEntry token;
        SQLEditorBase editor = this.contextInformer.getEditor();
        SQLDocumentSyntaxContext context = editor.getSyntaxContext();
        if (context != null && (token = context.findToken(offset)) != null) {
            Region refRegion = new Region(context.getLastAccessedTokenOffset(), token.getInterval().length());
            SQLQuerySymbolDefinition sQLQuerySymbolDefinition = token.getDefinition();
            if (sQLQuerySymbolDefinition instanceof SQLQuerySymbolEntry) {
                void def;
                SQLQuerySymbolEntry sQLQuerySymbolEntry = (SQLQuerySymbolEntry)sQLQuerySymbolDefinition;
                SQLQuerySymbolEntry cfr_ignored_0 = (SQLQuerySymbolEntry)sQLQuerySymbolDefinition;
                Interval interval = def.getInterval();
                Region defRegion = new Region(interval.a + context.getLastAccessedScriptElementOffset(), interval.length());
                return new IHyperlink[]{new IHyperlink((IRegion)refRegion, (SQLQuerySymbolEntry)def, editor, (IRegion)defRegion){
                    private final /* synthetic */ IRegion val$refRegion;
                    private final /* synthetic */ SQLQuerySymbolEntry val$def;
                    private final /* synthetic */ SQLEditorBase val$editor;
                    private final /* synthetic */ IRegion val$defRegion;
                    {
                        this.val$refRegion = iRegion;
                        this.val$def = sQLQuerySymbolEntry;
                        this.val$editor = sQLEditorBase;
                        this.val$defRegion = iRegion2;
                    }

                    public IRegion getHyperlinkRegion() {
                        return this.val$refRegion;
                    }

                    public String getTypeLabel() {
                        return null;
                    }

                    public String getHyperlinkText() {
                        return this.val$def.getName();
                    }

                    public void open() {
                        TextViewer textViewer = this.val$editor.getTextViewer();
                        if (textViewer != null) {
                            textViewer.setSelectedRange(this.val$defRegion.getOffset(), this.val$defRegion.getLength());
                            textViewer.revealRange(this.val$defRegion.getOffset(), this.val$defRegion.getLength());
                        }
                    }
                }};
            }
            SQLQuerySymbolDefinition sQLQuerySymbolDefinition2 = token.getDefinition();
            if (sQLQuerySymbolDefinition2 instanceof SQLQuerySymbolByDbObjectDefinition) {
                void def;
                SQLQuerySymbolByDbObjectDefinition interval = (SQLQuerySymbolByDbObjectDefinition)sQLQuerySymbolDefinition2;
                SQLQuerySymbolByDbObjectDefinition cfr_ignored_1 = (SQLQuerySymbolByDbObjectDefinition)sQLQuerySymbolDefinition2;
                if (def.getDbObject().getDataSource().getContainer() != null) {
                    return new IHyperlink[]{new EntityHyperlink((IWorkbenchSite)editor.getSite(), (DBSObjectReference)new DirectObjectReference(def.getDbObject().getParentObject(), null, def.getDbObject()), (IRegion)refRegion)};
                }
            }
        }
        return null;
    }

    public String getLastKeyword() {
        SQLIdentifierDetector.WordRegion wordRegion = this.contextInformer.getWordRegion();
        if (wordRegion != null) {
            Region hlRegion = new Region(wordRegion.identStart, wordRegion.identEnd - wordRegion.identStart);
            try {
                IDocument document = this.contextInformer.getEditor().getDocument();
                if (document != null) {
                    return this.contextInformer.getEditor().getDocument().get(hlRegion.getOffset(), hlRegion.getLength());
                }
            }
            catch (BadLocationException e) {
                log.error((Object)e);
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
    }
}

