/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolDefinition;

public class SQLQuerySymbolEntry
implements SQLQuerySymbolDefinition {
    private final Interval region;
    private final String name;
    private SQLQuerySymbol symbol = null;
    private SQLQuerySymbolDefinition definition = null;

    public SQLQuerySymbolEntry(@NotNull Interval region, @NotNull String name) {
        this.region = region;
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public Interval getInterval() {
        return this.region;
    }

    @Nullable
    public SQLQuerySymbolDefinition getDefinition() {
        return this.definition != null ? this.definition : (this.symbol != null ? this.symbol.getDefinition() : null);
    }

    public void setDefinition(@Nullable SQLQuerySymbolDefinition definition) {
        if (this.definition != null) {
            throw new UnsupportedOperationException("Symbol entry definition has already been set");
        }
        this.definition = definition;
        this.getSymbol().setSymbolClass(definition.getSymbolClass());
    }

    @NotNull
    public SQLQuerySymbol getSymbol() {
        if (this.symbol == null) {
            this.symbol = new SQLQuerySymbol(this.name);
            this.symbol.registerEntry(this);
        }
        return this.symbol;
    }

    @Override
    @NotNull
    public SQLQuerySymbolClass getSymbolClass() {
        return this.getSymbol().getSymbolClass();
    }

    public void merge(@Nullable SQLQuerySymbol symbol) {
        if (this.symbol == null) {
            this.symbol = symbol;
            this.symbol.registerEntry(this);
        }
    }

    public SQLQuerySymbol merge(@NotNull SQLQuerySymbolEntry other) {
        SQLQuerySymbol symbol;
        if (this.symbol != null && other.symbol != null) {
            symbol = this.symbol.merge(other.symbol);
        } else if (this.symbol == null && other.symbol == null) {
            symbol = new SQLQuerySymbol(this.name);
            symbol.registerEntry(other);
            symbol.registerEntry(this);
            this.symbol = symbol;
            other.symbol = symbol;
        } else if (this.symbol != null) {
            symbol = this.symbol;
            symbol.registerEntry(other);
            other.symbol = symbol;
        } else {
            symbol = other.symbol;
            symbol.registerEntry(this);
            this.symbol = symbol;
        }
        return symbol;
    }

    static void updateSymbol(@NotNull SQLQuerySymbolEntry entry, @NotNull SQLQuerySymbol newSymbol) {
        entry.symbol = newSymbol;
    }

    public String toString() {
        return super.toString() + "[" + this.name + ", " + String.valueOf((Object)this.getSymbolClass()) + "]";
    }
}

