/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolByDbObjectDefinition;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.ui.editors.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.ui.editors.sql.semantics.model.SQLQueryRowsTableDataModel;

public class SQLQueryQualifiedName {
    public final SQLQuerySymbolEntry catalogName;
    public final SQLQuerySymbolEntry schemaName;
    public final SQLQuerySymbolEntry entityName;

    public SQLQueryQualifiedName(@NotNull SQLQuerySymbolEntry entityName) {
        this(null, null, entityName);
    }

    public SQLQueryQualifiedName(@Nullable SQLQuerySymbolEntry schemaName, @NotNull SQLQuerySymbolEntry entityName) {
        this(null, schemaName, entityName);
    }

    public SQLQueryQualifiedName(@Nullable SQLQuerySymbolEntry catalogName, @Nullable SQLQuerySymbolEntry schemaName, @NotNull SQLQuerySymbolEntry entityName) {
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        this.entityName = entityName;
    }

    public void setSymbolClass(@NotNull SQLQuerySymbolClass symbolClass) {
        if (this.entityName != null) {
            this.entityName.getSymbol().setSymbolClass(symbolClass);
        }
        if (this.schemaName != null) {
            this.schemaName.getSymbol().setSymbolClass(symbolClass);
        }
        if (this.catalogName != null) {
            this.catalogName.getSymbol().setSymbolClass(symbolClass);
        }
    }

    public void setDefinition(@NotNull DBSEntity realTable) {
        if (this.entityName != null) {
            this.entityName.setDefinition(new SQLQuerySymbolByDbObjectDefinition((DBSObject)realTable, SQLQuerySymbolClass.TABLE));
            if (this.schemaName != null) {
                DBSObject schema = realTable.getParentObject();
                if (schema != null) {
                    this.schemaName.setDefinition(new SQLQuerySymbolByDbObjectDefinition(schema, SQLQuerySymbolClass.SCHEMA));
                } else {
                    this.schemaName.getSymbol().setSymbolClass(SQLQuerySymbolClass.SCHEMA);
                }
                if (this.catalogName != null) {
                    DBSObject catalog = realTable.getParentObject();
                    if (catalog != null) {
                        this.catalogName.setDefinition(new SQLQuerySymbolByDbObjectDefinition(catalog, SQLQuerySymbolClass.CATALOG));
                    } else {
                        this.catalogName.getSymbol().setSymbolClass(SQLQuerySymbolClass.CATALOG);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setDefinition(@NotNull SourceResolutionResult rr) {
        if (rr.aliasOrNull != null) {
            this.entityName.merge(rr.aliasOrNull);
        } else {
            SQLQueryRowsSourceModel sQLQueryRowsSourceModel = rr.source;
            if (sQLQueryRowsSourceModel instanceof SQLQueryRowsTableDataModel) {
                SQLQueryRowsTableDataModel sQLQueryRowsTableDataModel = (SQLQueryRowsTableDataModel)sQLQueryRowsSourceModel;
                SQLQueryRowsTableDataModel cfr_ignored_0 = (SQLQueryRowsTableDataModel)sQLQueryRowsSourceModel;
                if (this.entityName != null) {
                    void tableModel;
                    this.entityName.setDefinition((SQLQuerySymbolDefinition)tableModel);
                    if (this.schemaName != null) {
                        this.entityName.setDefinition((SQLQuerySymbolDefinition)tableModel);
                    }
                    if (this.catalogName != null) {
                        this.entityName.setDefinition((SQLQuerySymbolDefinition)tableModel);
                    }
                }
            }
        }
    }

    @NotNull
    public List<String> toListOfStrings() {
        if (this.catalogName != null && this.schemaName != null) {
            return List.of(this.catalogName.getName(), this.schemaName.getName(), this.entityName.getName());
        }
        if (this.schemaName != null) {
            return List.of(this.schemaName.getName(), this.entityName.getName());
        }
        return List.of(this.entityName.getName());
    }

    public String toString() {
        return super.toString() + "[" + String.join((CharSequence)".", this.toListOfStrings()) + "]";
    }

    public int hashCode() {
        return this.toListOfStrings().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof SQLQueryQualifiedName) {
            void other;
            SQLQueryQualifiedName sQLQueryQualifiedName = (SQLQueryQualifiedName)object;
            SQLQueryQualifiedName cfr_ignored_0 = (SQLQueryQualifiedName)object;
            if (this.toListOfStrings().equals(other.toListOfStrings())) {
                return true;
            }
        }
        return false;
    }
}

