/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.semantics;

import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.sql.semantics.OffsetKeyedTreeMap;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLDocumentScriptItemSyntaxContext;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.utils.ListNode;

public class SQLDocumentSyntaxContext {
    private static final Log log = Log.getLog(SQLDocumentSyntaxContext.class);
    private final OffsetKeyedTreeMap<SQLDocumentScriptItemSyntaxContext> scriptItems = new OffsetKeyedTreeMap();
    private int lastTokenAccessOffset = Integer.MAX_VALUE;
    private int lastAccessedTokenOffset = Integer.MAX_VALUE;
    private SQLQuerySymbolEntry lastAccessedTokenEntry = null;
    private int lastItemAccessOffset = Integer.MAX_VALUE;
    private int lastAccessedItemOffset = Integer.MAX_VALUE;
    private SQLDocumentScriptItemSyntaxContext lastAccessedScriptItem = null;

    public ScriptItemAtOffset findScriptItem(int offset) {
        if (offset != this.lastItemAccessOffset) {
            if (offset >= this.lastAccessedItemOffset && this.lastAccessedScriptItem != null && offset < this.lastAccessedItemOffset + this.lastAccessedScriptItem.length()) {
                this.lastItemAccessOffset = offset;
            } else {
                OffsetKeyedTreeMap.NodesIterator<SQLDocumentScriptItemSyntaxContext> it = this.scriptItems.nodesIteratorAt(offset);
                SQLDocumentScriptItemSyntaxContext scriptItem = it.getCurrValue();
                int itemOffset = it.getCurrOffset();
                if (scriptItem == null && it.prev()) {
                    scriptItem = it.getCurrValue();
                    itemOffset = it.getCurrOffset();
                }
                this.lastItemAccessOffset = offset;
                if (scriptItem != null && itemOffset <= offset && itemOffset + scriptItem.length() > offset) {
                    this.lastAccessedItemOffset = itemOffset;
                    this.lastAccessedScriptItem = scriptItem;
                } else {
                    this.lastAccessedItemOffset = Integer.MAX_VALUE;
                    this.lastAccessedScriptItem = null;
                }
            }
        }
        return this.lastAccessedScriptItem == null ? null : new ScriptItemAtOffset(this.lastAccessedItemOffset, this.lastAccessedScriptItem);
    }

    @Nullable
    public SQLQuerySymbolEntry findToken(int offset) {
        if (offset != this.lastTokenAccessOffset) {
            if (offset >= this.lastAccessedTokenOffset && this.lastAccessedTokenEntry != null && offset < this.lastAccessedTokenOffset + this.lastAccessedTokenEntry.getInterval().length()) {
                this.lastTokenAccessOffset = offset;
            } else {
                ScriptItemAtOffset scriptItem = this.findScriptItem(offset);
                SQLDocumentScriptItemSyntaxContext.TokenEntryAtOffset token = scriptItem == null ? null : scriptItem.item.findToken(offset - scriptItem.offset);
                this.lastTokenAccessOffset = offset;
                if (token != null) {
                    this.lastAccessedTokenOffset = token.offset + scriptItem.offset;
                    this.lastAccessedTokenEntry = token.entry;
                } else {
                    this.lastAccessedTokenOffset = Integer.MAX_VALUE;
                    this.lastAccessedTokenEntry = null;
                }
            }
        }
        return this.lastAccessedTokenEntry;
    }

    public int getLastAccessedTokenOffset() {
        return this.lastAccessedTokenOffset;
    }

    public int getLastAccessedScriptElementOffset() {
        return this.lastAccessedItemOffset;
    }

    public void resetLastAccessCache() {
        this.lastTokenAccessOffset = Integer.MAX_VALUE;
        this.lastAccessedTokenOffset = Integer.MAX_VALUE;
        this.lastAccessedTokenEntry = null;
        this.lastItemAccessOffset = Integer.MAX_VALUE;
        this.lastAccessedItemOffset = Integer.MAX_VALUE;
        this.lastAccessedScriptItem = null;
    }

    public SQLDocumentScriptItemSyntaxContext registerScriptItemContext(int offset, int length) {
        SQLDocumentScriptItemSyntaxContext scriptItem = new SQLDocumentScriptItemSyntaxContext(length);
        this.scriptItems.put(offset, scriptItem);
        return scriptItem;
    }

    public IRegion applyDelta(int offset, int oldLength, int newLength) {
        Object affectedRegion;
        if (oldLength > 0) {
            int currOffset;
            int delta = newLength - oldLength;
            ListNode keyOffsetsToRemove = null;
            OffsetKeyedTreeMap.NodesIterator<SQLDocumentScriptItemSyntaxContext> it = this.scriptItems.nodesIteratorAt(offset);
            SQLDocumentScriptItemSyntaxContext currItem = it.getCurrValue();
            int lastAffectedOffset = currOffset = it.getCurrOffset();
            if (currItem != null) {
                keyOffsetsToRemove = ListNode.push(keyOffsetsToRemove, (Object)currOffset);
                lastAffectedOffset = currOffset + currItem.length();
            } else if (it.prev()) {
                currOffset = it.getCurrOffset();
                currItem = it.getCurrValue();
                if (currOffset <= offset && currOffset + currItem.length() > offset) {
                    keyOffsetsToRemove = ListNode.push((ListNode)keyOffsetsToRemove, (Object)currOffset);
                    lastAffectedOffset = currOffset + currItem.length();
                }
            } else {
                lastAffectedOffset = offset + oldLength;
            }
            while (it.next() && (delta < 0 || lastAffectedOffset <= offset + oldLength)) {
                currOffset = it.getCurrOffset();
                currItem = it.getCurrValue();
                keyOffsetsToRemove = ListNode.push((ListNode)keyOffsetsToRemove, (Object)currOffset);
                lastAffectedOffset = currOffset + currItem.length();
            }
            int firstAffectedOffset = 0;
            ListNode kn = keyOffsetsToRemove;
            while (kn != null) {
                firstAffectedOffset = (Integer)kn.data;
                this.scriptItems.removeAt((Integer)kn.data);
                kn = kn.next;
            }
            if (delta > 0) {
                this.scriptItems.applyOffset(offset, delta);
            }
            affectedRegion = keyOffsetsToRemove != null ? new Region(firstAffectedOffset, lastAffectedOffset - firstAffectedOffset - oldLength + newLength) : null;
        } else {
            ScriptItemAtOffset scriptItem = this.findScriptItem(offset);
            if (scriptItem != null) {
                scriptItem.item.applyDelta(offset, oldLength, newLength);
                affectedRegion = new Region(scriptItem.offset, scriptItem.item.length());
            } else {
                OffsetKeyedTreeMap.NodesIterator<SQLDocumentScriptItemSyntaxContext> it = this.scriptItems.nodesIteratorAt(offset);
                int start = it.prev() ? it.getCurrOffset() + it.getCurrValue().length() : 0;
                int length = it.next() ? it.getCurrOffset() - start : Integer.MAX_VALUE;
                affectedRegion = new Region(start, length);
            }
            this.scriptItems.applyOffset(offset, newLength);
        }
        this.resetLastAccessCache();
        if (affectedRegion == null) {
            affectedRegion = new Region(offset, newLength);
        }
        return affectedRegion;
    }

    public void clear() {
        this.scriptItems.clear();
        this.resetLastAccessCache();
    }

    public Interval dropInvisibleScriptItems(Interval actualFragment) {
        int rangeStart = actualFragment.a;
        int rangeEnd = actualFragment.b;
        ListNode keyOffsetsToRemove = null;
        OffsetKeyedTreeMap.NodesIterator<SQLDocumentScriptItemSyntaxContext> it1 = this.scriptItems.nodesIteratorAt(0);
        int off1 = it1.getCurrOffset();
        if (it1.getCurrValue() != null && off1 < rangeStart) {
            keyOffsetsToRemove = ListNode.push(keyOffsetsToRemove, (Object)off1);
        }
        while (it1.next() && (off1 = it1.getCurrOffset()) < rangeStart) {
            keyOffsetsToRemove = ListNode.push((ListNode)keyOffsetsToRemove, (Object)off1);
        }
        int actualStart = it1.next() ? it1.getCurrOffset() : Integer.MAX_VALUE;
        OffsetKeyedTreeMap.NodesIterator<SQLDocumentScriptItemSyntaxContext> it2 = this.scriptItems.nodesIteratorAt(Integer.MAX_VALUE);
        int off2 = it2.getCurrOffset();
        if (it2.getCurrValue() != null && off2 > rangeEnd) {
            keyOffsetsToRemove = ListNode.push((ListNode)keyOffsetsToRemove, (Object)off2);
        }
        while (it2.prev() && (off2 = it2.getCurrOffset()) > rangeEnd) {
            keyOffsetsToRemove = ListNode.push((ListNode)keyOffsetsToRemove, (Object)off2);
        }
        int actualEnd = it1.prev() ? it2.getCurrOffset() : 0;
        ListNode kn = keyOffsetsToRemove;
        while (kn != null) {
            this.scriptItems.removeAt((Integer)kn.data);
            kn = kn.next;
        }
        return new Interval(actualStart, actualEnd);
    }

    public static class ScriptItemAtOffset {
        public final int offset;
        public final SQLDocumentScriptItemSyntaxContext item;

        public ScriptItemAtOffset(int offset, SQLDocumentScriptItemSyntaxContext item) {
            this.offset = offset;
            this.item = item;
        }
    }
}

