/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hive.model.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.hive.model.HiveTable;
import org.jkiss.dbeaver.ext.hive.model.HiveTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.DBECommandAbstract;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class HiveTableColumnManager
extends GenericTableColumnManager {
    private static final Log log = Log.getLog(HiveTableColumnManager.class);

    public boolean canCreateObject(Object container) {
        return true;
    }

    public boolean canDeleteObject(GenericTableColumn object) {
        return true;
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        HiveTable table = (HiveTable)((GenericTableColumn)command.getObject()).getParentObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Add table column", "ALTER TABLE " + DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DDL) + " ADD COLUMNS (" + String.valueOf(this.getNestedDeclaration(monitor, (GenericTableBase)table, (DBECommandAbstract<GenericTableColumn>)command, options)) + ")"));
    }

    public StringBuilder getNestedDeclaration(DBRProgressMonitor monitor, GenericTableBase owner, DBECommandAbstract<GenericTableColumn> command, Map<String, Object> options) {
        StringBuilder decl = super.getNestedDeclaration(monitor, owner, command, options);
        return decl;
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        HiveTableColumn hiveTableColumn = (HiveTableColumn)command.getObject();
        HiveTable table = (HiveTable)hiveTableColumn.getParentObject();
        try {
            List<HiveTableColumn> attributes = table.getAttributes(monitor);
            StringBuilder ddl = new StringBuilder();
            ddl.append("ALTER TABLE ").append(DBUtils.getObjectFullName((DBPNamedObject)table, (DBPEvaluationContext)DBPEvaluationContext.DDL)).append(" REPLACE COLUMNS (");
            if (attributes != null) {
                int i = 0;
                while (i < attributes.size()) {
                    GenericTableColumn column = attributes.get(i);
                    if (column != hiveTableColumn) {
                        if (i != 0) {
                            ddl.append(" ");
                        }
                        ddl.append(DBUtils.getQuotedIdentifier((DBSObject)column)).append(" ").append(column.getTypeName());
                        String typeModifiers = SQLUtils.getColumnTypeModifiers((DBPDataSource)table.getDataSource(), (DBSTypedObject)column, (String)column.getTypeName(), (DBPDataKind)column.getDataKind());
                        if (typeModifiers != null) {
                            ddl.append(typeModifiers);
                        }
                        String description = column.getDescription();
                        if (column.getDescription() != null) {
                            ddl.append(" COMMENT '").append(description).append("'");
                        }
                        if (i != attributes.size() - 1) {
                            ddl.append(",");
                        }
                    }
                    ++i;
                }
            }
            ddl.append(")");
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop table column", ddl.toString()));
        }
        catch (DBException e) {
            log.debug((Object)("Columns not found in table: " + table.getName()), (Throwable)e);
        }
    }
}

