/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.layout.algorithm.direct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class OrthoDirectedGraphLayout
extends DirectedGraphLayout {
    private AbstractGraphicalEditPart diagram;
    private TreeMap<String, List<Node>> nodeByLevels;
    private List<Node> isolatedNodes = new LinkedList<Node>();
    private static final int DEFAUL_OFFSET_FROM_TOP_LINE = 40;
    private static final int DEFAULT_ISO_OFFSET_HORZ = 100;
    private static final int DEFAULT_OFFSET_BY_X = 250;
    private static final int DEFAULT_OFFSET_BY_Y = 75;

    public OrthoDirectedGraphLayout(AbstractGraphicalEditPart diagram) {
        this.diagram = diagram;
    }

    public void visit(DirectedGraph graph) {
        this.nodeByLevels = this.computeRootNodes(graph);
        this.isolatedNodes = this.computeIsolatedNodes(graph);
        this.nodeByLevels = this.balanceRoots(this.isolatedNodes, this.nodeByLevels);
        this.nodeByLevels = this.computeGraph(this.nodeByLevels);
        this.nodeByLevels = this.verifyDirectedGraph(graph, this.nodeByLevels);
        this.drawGraphNodes(this.nodeByLevels);
        this.drawIsolatedNodes(this.isolatedNodes, this.nodeByLevels);
        List<Node> nodeMissed = this.findMissedGraphNodes(graph, this.nodeByLevels);
        this.drawMissedNodes(this.isolatedNodes, nodeMissed, this.nodeByLevels);
    }

    private TreeMap<String, List<Node>> verifyDirectedGraph(DirectedGraph graph, TreeMap<String, List<Node>> nodeByLevels) {
        if (nodeByLevels.isEmpty() && !graph.nodes.isEmpty()) {
            nodeByLevels.put(String.valueOf(0), (List<Node>)graph.nodes);
        }
        return nodeByLevels;
    }

    private TreeMap<String, List<Node>> balanceRoots(List<Node> islands, TreeMap<String, List<Node>> nodeByLevels) {
        List<Node> listOfNodes = nodeByLevels.get(String.valueOf(0));
        if (listOfNodes != null) {
            listOfNodes.removeAll(islands);
            nodeByLevels.put(String.valueOf(0), listOfNodes);
        }
        return nodeByLevels;
    }

    private void drawIsolatedNodes(List<Node> islands, TreeMap<String, List<Node>> nodeByLevels) {
        Map.Entry<String, List<Node>> lastEntry = nodeByLevels.lastEntry();
        int offsetX = 100;
        for (Node n : lastEntry.getValue()) {
            if (offsetX >= n.width) continue;
            offsetX = n.width;
        }
        int currentX = 0;
        if (lastEntry.getValue() == null || lastEntry.getValue().isEmpty()) {
            currentX = 100;
        } else {
            Node lastNode = nodeByLevels.lastEntry().getValue().get(0);
            currentX = lastNode.x + offsetX + 100;
        }
        int currentY = 40;
        for (Node nodeSource : islands) {
            nodeSource.x = currentX;
            nodeSource.y = currentY;
            for (Edge edge : nodeSource.outgoing) {
                Node nodeTarget = edge.target;
                nodeTarget.x = currentX + nodeSource.width + 125;
                nodeTarget.y = currentY;
                if (nodeSource.height > nodeTarget.height) {
                    currentY += nodeSource.height + 75;
                    continue;
                }
                currentY += nodeTarget.height + 75;
            }
        }
    }

    private void drawMissedNodes(List<Node> islands, List<Node> missedNodes, TreeMap<String, List<Node>> nodeByLevels) {
        Map.Entry<String, List<Node>> lastEntry = nodeByLevels.lastEntry();
        int offsetX = 100;
        for (Node n : lastEntry.getValue()) {
            if (offsetX >= n.width) continue;
            offsetX = n.width;
        }
        int currentX = 0;
        if (lastEntry.getValue() == null || lastEntry.getValue().isEmpty()) {
            currentX = 100;
        } else {
            Node lastNode = nodeByLevels.lastEntry().getValue().get(0);
            currentX = lastNode.x + offsetX + 100;
        }
        int currentY = 40;
        for (Node nodeSource : islands) {
            currentY += nodeSource.height + 75;
        }
        for (Node node : missedNodes) {
            node.x = currentX;
            node.y = currentY;
            currentY += node.height + 75;
        }
    }

    private void drawGraphNodes(TreeMap<String, List<Node>> nodeByEdges) {
        int currentX = 40;
        int currentY = 40;
        Map<String, Integer> height2Level = this.computeHeight(this.nodeByLevels);
        int middle = Collections.max(height2Level.values()) / 2;
        int index = 0;
        for (Map.Entry<String, List<Node>> entry : nodeByEdges.entrySet()) {
            Integer height = height2Level.get(String.valueOf(index));
            currentY = height / 2 > middle ? 40 : 40 + middle - height / 2;
            List<Node> nodes = entry.getValue();
            int offsetX = 100;
            for (Node n : nodes) {
                n.x = currentX;
                n.y = currentY;
                currentY += n.height + 75;
                if (offsetX >= n.width) continue;
                offsetX = n.width;
            }
            if (!nodes.isEmpty()) {
                currentX += 100 + offsetX;
            }
            ++index;
        }
    }

    private List<Node> computeIsolatedNodes(DirectedGraph graph) {
        LinkedList<Node> isolated = new LinkedList<Node>();
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = (Node)graph.nodes.get(i);
            if (node.outgoing.size() == 1 && node.incoming.size() == 0) {
                boolean hasNoFurtherConnections = false;
                Node nodeTarget = null;
                for (Edge edge : node.outgoing) {
                    nodeTarget = edge.target;
                    hasNoFurtherConnections = nodeTarget != null && nodeTarget.outgoing.size() == 0 && nodeTarget.incoming.size() == 1;
                }
                if (hasNoFurtherConnections) {
                    isolated.add(node);
                }
            }
            ++i;
        }
        return isolated;
    }

    private TreeMap<String, List<Node>> computeRootNodes(DirectedGraph graph) {
        TreeMap<String, List<Node>> nodeByLevels = new TreeMap<String, List<Node>>();
        LinkedList<Node> firstLineOutput = new LinkedList<Node>();
        int i = 0;
        while (i < graph.nodes.size()) {
            Node node = (Node)graph.nodes.get(i);
            if (node.outgoing.size() > 0 && node.incoming.size() == 0) {
                firstLineOutput.add(node);
            }
            ++i;
        }
        if (!firstLineOutput.isEmpty()) {
            nodeByLevels.put(String.valueOf(0), firstLineOutput);
        }
        return nodeByLevels;
    }

    private TreeMap<String, List<Node>> computeGraph(TreeMap<String, List<Node>> graph) {
        int idx = 0;
        while (idx < graph.keySet().size()) {
            this.createGraphLayers(graph, idx);
            ++idx;
        }
        return graph;
    }

    private List<Node> findMissedGraphNodes(DirectedGraph graph, TreeMap<String, List<Node>> nodeByEdges) {
        ArrayList<Node> missedNodes = new ArrayList<Node>();
        for (Node node : graph.nodes) {
            boolean isContains = false;
            for (Map.Entry<String, List<Node>> entry : nodeByEdges.entrySet()) {
                if (entry.getValue().contains(node) || this.isolatedNodes.contains(node)) {
                    isContains = true;
                    break;
                }
                block2: for (Node isoNode : this.isolatedNodes) {
                    for (Edge edge : isoNode.outgoing) {
                        Node nodeTarget = edge.target;
                        if (nodeTarget == null || !node.equals(nodeTarget)) continue;
                        isContains = true;
                        continue block2;
                    }
                }
            }
            if (isContains) continue;
            missedNodes.add(node);
        }
        return missedNodes;
    }

    private void createGraphLayers(TreeMap<String, List<Node>> nodeByEdges, int idx) {
        HashMap<Node, String> duplicationNode2index = new HashMap<Node, String>();
        List<Node> nodesLine = nodeByEdges.get(String.valueOf(idx));
        for (Node inNode : nodesLine) {
            for (Edge edge : inNode.outgoing) {
                String index;
                Node trg;
                Node src = edge.source;
                if (src != null && !src.equals(inNode)) {
                    String nodeIndex = this.getNodeIndex(nodeByEdges, src);
                    if (!nodeIndex.isEmpty()) {
                        duplicationNode2index.put(src, nodeIndex);
                        index = String.valueOf(idx + 2);
                        nodeByEdges.computeIfAbsent(index, n -> new ArrayList()).add(src);
                    } else {
                        index = String.valueOf(idx + 2);
                        nodeByEdges.computeIfAbsent(index, n -> new ArrayList()).add(src);
                    }
                }
                if ((trg = edge.target) == null) continue;
                String nodeIndex = this.getNodeIndex(nodeByEdges, trg);
                if (!nodeIndex.isEmpty()) {
                    duplicationNode2index.put(trg, nodeIndex);
                    index = String.valueOf(idx + 1);
                    nodeByEdges.computeIfAbsent(index, n -> new ArrayList()).add(trg);
                    continue;
                }
                index = String.valueOf(idx + 1);
                nodeByEdges.computeIfAbsent(index, n -> new ArrayList()).add(trg);
            }
        }
        duplicationNode2index.entrySet().stream().forEach(node2index -> ((List)nodeByEdges.get(node2index.getValue())).remove(node2index.getKey()));
    }

    private String getNodeIndex(TreeMap<String, List<Node>> nodeByEdges, Node src) {
        for (Map.Entry<String, List<Node>> nodeOnLevel : nodeByEdges.entrySet()) {
            if (!nodeOnLevel.getValue().contains(src)) continue;
            return nodeOnLevel.getKey();
        }
        return "";
    }

    private Map<String, Integer> computeHeight(TreeMap<String, List<Node>> nodeByEdges) {
        HashMap<String, Integer> mapOfHeight = new HashMap<String, Integer>();
        for (Map.Entry<String, List<Node>> entry : nodeByEdges.entrySet()) {
            int height = 0;
            for (Node node : entry.getValue()) {
                height += node.height + 75;
            }
            mapOfHeight.put(entry.getKey(), height);
        }
        return mapOfHeight;
    }

    public AbstractGraphicalEditPart getDiagram() {
        return this.diagram;
    }
}

