/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.command;

import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.part.AttributePart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.UIUtils;

public class AssociationDeleteCommand
extends Command {
    protected final AssociationPart part;
    protected final ERDElement sourceEntity;
    protected final ERDElement targetEntity;
    protected final ERDAssociation association;

    public AssociationDeleteCommand(AssociationPart part) {
        this.part = part;
        this.association = part.getAssociation();
        this.sourceEntity = this.association.getSourceEntity() == null && part.getSource() instanceof AttributePart ? ((EntityPart)part.getSource().getParent()).getEntity() : this.association.getSourceEntity();
        this.targetEntity = this.association.getTargetEntity() == null && part.getTarget() instanceof AttributePart ? ((EntityPart)part.getTarget().getParent()).getEntity() : this.association.getTargetEntity();
    }

    public void execute() {
        DBSEntityAssociation entityAssociation = (DBSEntityAssociation)this.association.getObject();
        if (entityAssociation instanceof DBVEntityForeignKey) {
            if (!UIUtils.confirmAction((String)"Delete logical key", (String)("Are you sure you want to delete logical key '" + this.part.getAssociation().getName() + "'?"))) {
                return;
            }
            DBVEntity vEntity = DBVUtils.getVirtualEntity((DBSEntity)entityAssociation.getParentObject(), (boolean)false);
            if (vEntity == null) {
                UIUtils.showMessageBox((Shell)UIUtils.getActiveWorkbenchShell(), (String)"No virtual entity", (String)"Can't find association owner virtual entity", (int)1);
                return;
            }
            vEntity.removeForeignKey((DBVEntityForeignKey)entityAssociation);
        }
        this.removeAssociationFromDiagram();
    }

    protected void removeAssociationFromDiagram() {
        this.part.setSelected(0);
        this.targetEntity.removeReferenceAssociation(this.association, true);
        this.sourceEntity.removeAssociation(this.association, true);
        this.association.setSourceEntity(null);
        this.association.setTargetEntity(null);
    }

    public void undo() {
        DBVEntity vEntity;
        if (this.association.getSourceEntity() != null) {
            return;
        }
        DBSEntityAssociation entityAssociation = (DBSEntityAssociation)this.association.getObject();
        if (entityAssociation instanceof DBVEntityForeignKey && (vEntity = DBVUtils.getVirtualEntity((DBSEntity)entityAssociation.getParentObject(), (boolean)false)) != null) {
            vEntity.addForeignKey((DBVEntityForeignKey)entityAssociation);
        }
        this.association.setSourceEntity(this.sourceEntity);
        this.association.setTargetEntity(this.targetEntity);
        this.sourceEntity.addAssociation(this.association, true);
        this.targetEntity.addReferenceAssociation(this.association, true);
        this.part.activate();
    }
}

