/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.session;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Objects;
import org.jkiss.dbeaver.model.admin.sessions.AbstractServerSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class OracleServerSession
extends AbstractServerSession {
    public static final String CAT_SESSION = "Session";
    public static final String CAT_SQL = "SQL";
    public static final String CAT_PROCESS = "Process";
    public static final String CAT_IO = "IO";
    public static final String CAT_WAIT = "Wait";
    private long instId;
    private final long sid;
    private long serial;
    private long sqlChildNumber;
    private String user;
    private String schema;
    private String type;
    private String status;
    private String state;
    private String sqlId;
    private String sql;
    private final String event;
    private long secondsInWait;
    private long elapsedTime;
    private Timestamp logonTime;
    private String serviceName;
    private String server;
    private String remoteHost;
    private String remoteUser;
    private String remoteProgram;
    private String module;
    private final String action;
    private final String clientInfo;
    private final String process;
    private final long blockGets;
    private final long consistentGets;
    private final long physicalReads;
    private final long blockChanges;
    private final long consistentChanges;

    public OracleServerSession(ResultSet dbResult) {
        this.instId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"INST_ID");
        this.sid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SID");
        this.serial = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SERIAL#");
        this.user = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"USERNAME");
        this.schema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEMANAME");
        this.type = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE");
        this.status = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS");
        this.state = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATE");
        this.sqlId = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQL_ID");
        this.sqlChildNumber = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SQL_CHILD_NUMBER");
        this.sql = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SQL_FULLTEXT");
        this.elapsedTime = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"LAST_CALL_ET");
        this.logonTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LOGON_TIME");
        this.serviceName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SERVICE_NAME");
        this.server = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SERVER");
        this.remoteHost = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MACHINE");
        this.remoteUser = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OSUSER");
        this.remoteProgram = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROGRAM");
        this.module = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"MODULE");
        this.action = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ACTION");
        this.clientInfo = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLIENT_INFO");
        this.process = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"PROCESS");
        this.blockGets = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"BLOCK_GETS");
        this.consistentGets = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CONSISTENT_GETS");
        this.physicalReads = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"PHYSICAL_READS");
        this.blockChanges = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"BLOCK_CHANGES");
        this.consistentChanges = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CONSISTENT_CHANGES");
        this.event = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EVENT");
        this.secondsInWait = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SECONDS_IN_WAIT");
    }

    @Property(category="Session", viewable=false, order=1)
    public long getInstId() {
        return this.instId;
    }

    @Property(category="Session", viewable=true, order=2)
    public long getSid() {
        return this.sid;
    }

    @Property(category="Session", viewable=false, order=3)
    public long getSerial() {
        return this.serial;
    }

    @Property(category="Session", viewable=true, order=4)
    public String getUser() {
        return this.user;
    }

    @Property(category="Session", viewable=true, order=5)
    public String getSchema() {
        return this.schema;
    }

    @Property(category="Session", viewable=true, order=6)
    public String getType() {
        return this.type;
    }

    @Property(category="Session", viewable=true, order=7)
    public String getStatus() {
        return this.status;
    }

    @Property(category="Session", viewable=true, order=8)
    public String getState() {
        return this.state;
    }

    @Property(category="Session", viewable=true, order=9)
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    @Property(category="Session", order=10)
    public Timestamp getLogonTime() {
        return this.logonTime;
    }

    @Property(category="Session", order=11)
    public String getServiceName() {
        return this.serviceName;
    }

    @Property(category="SQL", order=20)
    public String getSql() {
        return this.sql;
    }

    @Property(category="SQL", order=21)
    public String getSqlId() {
        return this.sqlId;
    }

    @Property(category="SQL", order=22)
    public long getSqlChildNumber() {
        return this.sqlChildNumber;
    }

    @Property(category="Process", viewable=true, order=30)
    public String getServer() {
        return this.server;
    }

    @Property(category="Process", viewable=true, order=30)
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Property(category="Process", viewable=true, order=31)
    public String getRemoteUser() {
        return this.remoteUser;
    }

    @Property(category="Process", viewable=true, order=32)
    public String getRemoteProgram() {
        return this.remoteProgram;
    }

    @Property(category="Process", viewable=false, order=32)
    public String getModule() {
        return this.module;
    }

    @Property(category="Process", viewable=false, order=32)
    public String getAction() {
        return this.action;
    }

    @Property(category="Process", viewable=false, order=32)
    public String getClientInfo() {
        return this.clientInfo;
    }

    @Property(category="Process", viewable=false, order=32)
    public String getProcess() {
        return this.process;
    }

    @Property(category="IO", viewable=false, order=70)
    public long getBlockGets() {
        return this.blockGets;
    }

    @Property(category="IO", viewable=false, order=70)
    public long getConsistentGets() {
        return this.consistentGets;
    }

    @Property(category="IO", viewable=false, order=70)
    public long getPhysicalReads() {
        return this.physicalReads;
    }

    @Property(category="IO", viewable=false, order=70)
    public long getBlockChanges() {
        return this.blockChanges;
    }

    @Property(category="IO", viewable=false, order=70)
    public long getConsistentChanges() {
        return this.consistentChanges;
    }

    @Property(category="Wait", viewable=true, order=41)
    public String getEvent() {
        return this.event;
    }

    @Property(category="Wait", viewable=true, order=42)
    public long getSecondsInWait() {
        return this.secondsInWait;
    }

    public String getActiveQuery() {
        return this.sql;
    }

    public Object getActiveQueryId() {
        return this.sqlId;
    }

    public String toString() {
        return this.sid + " - " + this.event;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OracleServerSession that = (OracleServerSession)((Object)o);
        return this.sid == that.sid && Objects.equals(this.event, that.event);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.event);
    }
}

